<?php
ob_start();
session_start();
include_once("../config/index.php");
include_once("includes/auth.php");
$now = date('Y-m-d H:i:s');
?>
<!DOCTYPE html>
<html lang="en-US">
<head>
<meta charset="UTF-8">
<title>Braches | Kuza Fine Africa</title>
<meta name="viewport" content="width=device-width,initial-scale=1">
<link rel="shortcut icon" href="<?php echo $base_url;?>assets/images/logo/favicon.ico">
<link href="<?php echo $base_url;?>assets/bootstrap/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="<?php echo $base_url;?>assets/css/dataTables.bootstrap4.min.css"/>
<link rel="stylesheet" href="<?php echo $base_url;?>assets/fontawesome/css/all.min.css"> 
<link href="<?php echo $base_url;?>assets/css/dashboard.css" rel="stylesheet">
<script src="<?php echo $base_url;?>assets/js/jquery.min.js"></script>
<style>
.modal-dialog{
  max-width: 450px;
}
form{
  padding-left: 5px;
  padding-right: 10px;
}
</style>
</head>
<body> 
<?php include_once("includes/header.php");?>
<section id="main">
<div class="container-fluid">
 <div class="row">
   <?php include_once("includes/aside.php");?>
   <div class="content">
    <div class="col-md-12">
     <div class="breadcrumbs row">
      <ul class="breadcrumb">
       <li><i class="fas fa-tachometer-alt"></i>&nbsp;Dashboard</li>
       <li><i class="fas fa-sitemap"></i> &nbsp;&nbsp;Branches</li>
      </ul>
    </div>

    <div class="row wrapper">
      <button class="btn item item1" data-dismiss="modal" data-toggle="modal" data-target="#branchmodal"><i class="fa fa-plus"></i> New Branch</button>
      <span class="item item2" data-dismiss="modal" data-toggle="modal" data-target="#branchmodal" style="display: none;"></span>
    </div>

     <div class="panel panel-default">
       <div class="panel-header dvtitle">Branches</div>
       <div class="panel-body">
        <div class="table-responsive row">
        <table id="tb_branches" class="table table-striped table-bordered" cellspacing="0" width="100%">
         <thead>
           <tr><th>Branch Name</th><th>Location</th><th>Phone</th><th>Email</th><th style="min-width: 100px;">Action</th></tr>
          </thead>
           <tbody>
             <?php
             $chkbranches = mysqli_query($con,"SELECT * FROM branches");
             while($row = mysqli_fetch_assoc($chkbranches)){  ?>
             <tr>
              <td><?php echo $row["name"];?></td>
              <td><?php echo $row["location"];?></td>
              <td><?php echo $row["phone"];?></td>
              <td><?php echo $row["email"];?></td>
              <td>
               <a data-toggle="tooltip" data-placement="bottom" title="Edit Branch"><button class="btn btn-xs btn-primary edtbranch" data-id="<?php echo $row["id"];?>" data-name="<?php echo $row["name"];?>" data-location="<?php echo $row["location"];?>" data-phone="<?php echo $row["phone"];?>" data-email="<?php echo $row["email"];?>"><i class="fas fa-pencil-alt"></i></button></a>
               <button class="btn btn-xs btn-danger delbranch" id="<?php echo $row["id"];?>" data-toggle="tooltip" data-placement="bottom" title="Delete Branch"><i class="fa fa-trash"></i></button>
              </td>
             </tr>
             <?php }
            ?>
         </tbody>
       </table>
      </div>
    </div>
   </div>
  

<div id="branchmodal" class="modal fade" role="dialog">
 <div class="modal-dialog">
  <div class="modal-content">
   <h3><i class="fas fa-sitemap"></i> Branches Management<span class="close pull-right" data-dismiss="modal"><i class="fas fa-times"></i></span></h3>
   <form role="form" id="branchfrm">
    <div class="form-group">
     <label>Branch Name <span>*</span></label>
     <input type="hidden" id="id" value="">
     <input type="text" class="form-control" id="name" required>
    </div>
    <div class="form-group">
     <label>Location <span>*</span></label>
     <input type="text" class="form-control" id="location" required>
    </div>
    <div class="form-group">
     <label>Phone <span>*</span></label>
     <input type="tel" class="form-control" id="phone" required>
    </div>
    <div class="form-group">
     <label>Email <span>*</span></label>
     <input type="email" class="form-control" id="email" required>
    </div>
    <div class="form-group" style="border-top: 1px solid #ddd;padding-top: 5px;">
      <button class="btn btn-block" type="submit"> <i class="fa fa-save"></i> Save Branch</button>
    </div>
    <div class="form-group">
     <div id="status"></div>
    </div>
   </form>
  </div>
 </div>
</div>

  </div>
 </div>
</div>
</div>
</section>
<script src="<?php echo $base_url;?>assets/bootstrap/bootstrap.min.js"></script>
<script src="<?php echo $base_url;?>assets/js/dashboard.js"></script>
<script src="<?php echo $base_url;?>assets/js/jquery.dataTables.min.js"></script>
<script src="<?php echo $base_url;?>assets/js/dataTables.bootstrap4.min.js"></script>
<script>
$(function(){
 $("#brnch").attr("class","active");
 $('#tb_branches').DataTable({"aaSorting":[]});

 $("body").on("click",".edtbranch",function(){
  $("#id").val($(this).attr("data-id"));
  $("#name").val($(this).attr("data-name"));
  $("#location").val($(this).attr("data-location"));
  $("#phone").val($(this).attr("data-phone"));
  $("#email").val($(this).attr("data-email"));
  $("#status").html("");
  $(".item1").click();
 });

 $("#branchfrm").submit(function(e){
  e.preventDefault();
  var id = $("#id").val();
  var name = $("#name").val();
  var location = $("#location").val();
  var phone = $("#phone").val();
  var email = $("#email").val();
  
  $("#status").html("<p class='text-success bg-success'><i class='fa fa-spinner fa-pulse'></i> Saving the branch...</p>"); 
  $.ajax({
    method: "POST",
    url: $("#portal_url").html()+"app/branches",
    data: {
      id:id,
      name:name,
      location:location,
      phone:phone,
      email:email
    },
    cache:false
  }).done(function(data){
   if(data.status == 200){
    $("#status").html("<p class='alert alert-success'><i class='fa fa-check'></i> Branch saved successfully.</p>").delay(5000);
     window.location.replace($("#portal_url").html()+"branches");
   }
   if(data.status == 300){
    $("#status").html("<p class='alert alert-danger'><i class='fa fa-exclamation-circle'></i> An error occured, please try again later.</p>");
   }
  });
 });

 //Deleting a branch
 $(".delbranch").click(function(){
  var delbranch = $(this).attr("id");
  var d = confirm('Are you sure you want to delete this branch?');
  if(d == false){
   return false;
  }
  else{
    $.ajax({
      method:"post",
      url: $("#portal_url").html()+"app/branches",
      data:{
        delbranch:delbranch
      },
      cache:false
    }).done(function(data){
      if(data.status == "200"){
       window.location.replace($("#portal_url").html()+"branches");
      }
    });
    }
   });
 });
</script>
</body>
</html>