<?php
ob_start();
session_start();
include_once("../config/index.php");
include_once("includes/auth.php");
$now = date('Y-m-d H:i:s');
?>
<!DOCTYPE html>
<html lang="en-US">
<head>
<meta charset="UTF-8">
<title>Bulk SMS | Kuza Work Africa</title>
<meta name="viewport" content="width=device-width,initial-scale=1">
<link rel="shortcut icon" href="<?php echo $base_url;?>assets/images/logo/favicon.ico">
<link href="<?php echo $base_url;?>assets/bootstrap/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="<?php echo $base_url;?>assets/css/dataTables.bootstrap4.min.css"/>
<link rel="stylesheet" href="<?php echo $base_url;?>assets/fontawesome/css/all.min.css"> 
<link href="<?php echo $base_url;?>assets/css/dashboard.css" rel="stylesheet">
<script src="<?php echo $base_url;?>assets/js/jquery.min.js"></script>
</head>
<body> 
<?php include_once("includes/header.php");?>
<section id="main">
<div class="container-fluid">
 <div class="row">
   <?php include_once("includes/aside.php");?>
   <div class="content">
    <div class="col-md-12">
     <div class="breadcrumbs row">
      <ul class="breadcrumb">
        <li><i class="ace-icon fa fa-tachometer"></i>&nbsp;Dashboard</li>
        <li><i class="fa fa-comment"></i> &nbsp;Bulk SMS</li>
      </ul>
    </div>    
    <div class="row" style="background: #f5f5f5;padding: 7px; margin-top:-20px;border: 1px solid #ddd;">
     <div class="col-md-3 text-center" style="background: #fff;padding: 10px;border: 1px solid #ddd;font-weight: bold;">
     BALANCE:
     <span style="color: #014770;font-weight: 600;">
     <?php
     $gateway    = new AfricasTalkingGateway($username, $apikey);
     try{
      $data = $gateway->getUserData();
      echo "Ksh ".number_format(substr($data->balance,4),2);
    }
    catch ( AfricasTalkingGatewayException $e ){
      echo "";
    }?>  
    </span>   
    </div>
    </div>
     <div class="panel panel-default">
       <div class="panel-header dvtitle">
        How to top up Kuza Work Africa bulk SMS balance
       </div>
       <div class="panel-body">
        <p>
         - Open Mpesa menu<br>
         - Select Lipa na Mpesa<br>
         - Select Pay Bill option<br>
         - Enter business number: <strong>525900</strong><br>
         - Enter Account Number: <strong>kuzawork.api</strong><br>
         - Enter Amount: (<strong>The amount you wish to top up with eg. 500</strong>)<br>
         - Enter your Mpesa PIN and complete the transaction.<br>
         - Reload this page after you receive the MPESA confirmation message to see the updated balance.
         </p>
       </div>
     </div>

   </div>
 </div>
</div>
</div>
</section>
<script src="<?php echo $base_url;?>assets/bootstrap/bootstrap.min.js"></script>
<script src="<?php echo $base_url;?>assets/js/dashboard.js"></script>
<script src="<?php echo $base_url;?>assets/js/jquery.dataTables.min.js"></script>
<script src="<?php echo $base_url;?>assets/js/dataTables.bootstrap4.min.js"></script>
<script>
$(function(){
 $("#sms").attr("class","active");
 });
</script>
</body>
</html>