<?php
ob_start();
session_start();
include_once("../config/index.php");
include_once("includes/auth.php");
include_once("includes/bar-graph.php");
include_once("includes/bar-graph2.php");
include_once("includes/bar-graph3.php");
include_once("includes/bar-graph4.php");
?>
<!DOCTYPE html>
<html lang="en-US">
<head>
<meta charset="UTF-8">
<title>Home | Kuza Fine Africa</title>
<meta name="viewport" content="width=device-width,initial-scale=1">
<link rel="shortcut icon" href="<?php echo $base_url;?>assets/images/logo/favicon.ico">
<link href="<?php echo $base_url;?>assets/bootstrap/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="<?php echo $base_url;?>assets/fontawesome/css/all.min.css">
<link href="<?php echo $base_url;?>assets/css/dashboard.css" rel="stylesheet">
<script src="<?php echo $base_url;?>assets/js/jquery.min.js"></script>
<script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>
<style>
.graphical{
  margin-left: -6px;
  width: 100.5%;
}
.graphical .panel-heading{
  padding: 8px;
}
.graphical .panel-heading h4{
  margin-top: 0px;
  margin-bottom: 0px;
  color: #090f2d;
  font-weight: 500;
}
.graphical .panel-body{
  margin-right: 10px;
}
</style>
</head>
<body>
<?php include_once("includes/header.php");?>
<section id="main">
<div class="container-fluid">
 <div class="row">
  <?php include_once("includes/aside.php");?>
  <div class="content">
   <div class="col-md-12 dashboard">
    <div class="breadcrumbs row">
     <ul class="breadcrumb">
      <li><i class="fas fa-tachometer-alt"></i>&nbsp;Dashboard</li>
      <li><i class="fa fa-home"></i> &nbsp;Home</li>
      <li>&nbsp; Period: <span>All Time</span></li>
     </ul>
    </div>

    <div class="row wrapper">
      <button class="btn item" data-dismiss="modal" data-toggle="modal" data-target="#filtermodal"><i class="far fa-calendar-alt"></i> Filter by Date</button>
    </div>

   <div class="row">
   <div class="col-md-12" style="padding-left: 0!important;">
    <div class="col-md-3">
    <div class="col-md-12 inner">
    <div class="row">
     <div class="col-md-7">
      <h1><?php echo number_format(mysqli_num_rows(mysqli_query($con,"SELECT * FROM customers")));?></h1>
     </div>
     <div class="col-md-5">
      <i class="fas fa-users"></i>
     </div>
    </div>
    <div class="row">
     <h4>Borrowers</h4>
    </div>
    </div>
    </div>

    <div class="col-md-3">
    <div class="col-md-12 inner">
    <div class="row">
     <div class="col-md-7">
      <h1>Ksh <?php echo number_format(mysqli_fetch_assoc(mysqli_query($con,"SELECT SUM(savings) AS amt FROM customers"))["amt"]);?></h1>
     </div>
     <div class="col-md-5">
      <i class="fas fa-wallet"></i>
     </div>
    </div>
    <div class="row">
     <h4>Total LGF</h4>
    </div>
    </div>
    </div>

    <div class="col-md-3">
    <div class="col-md-12 inner">
    <div class="row">
     <div class="col-md-7">
      <h1>Ksh <?php echo number_format(mysqli_fetch_assoc(mysqli_query($con,"SELECT SUM(reg_fee) AS fee FROM customers"))["fee"]);?></h1>
     </div>
     <div class="col-md-5">
      <i class="fas fa-file-invoice"></i>
     </div>
    </div>
    <div class="row">
     <h4>Total Fees Collection</h4>
    </div>
    </div>
    </div>

    <div class="col-md-3">
     <div class="col-md-12 inner">
     <div class="row">
      <div class="col-md-7">
      <h1>Ksh <?php echo number_format(mysqli_fetch_assoc(mysqli_query($con,"SELECT SUM(amount) AS amt FROM loan_applications WHERE status='4'"))["amt"]);?></h1>
      </div>
      <div class="col-md-5">
       <i class="fas fa-file-invoice"></i>
      </div>
     </div>
     <div class="row">
      <h4>Total Amount Borrowed</h4>
     </div>
     </div>
    </div>

    <div class="col-md-3">
     <div class="col-md-12 inner">
     <div class="row">
      <div class="col-md-7">
      <h1>Ksh <?php echo number_format(mysqli_fetch_assoc(mysqli_query($con,"SELECT SUM(disbursed_amount) AS amt FROM loan_applications WHERE status='4'"))["amt"]);?></h1>
      </div>
      <div class="col-md-5">
       <i class="fas fa-file-invoice"></i>
      </div>
     </div>
     <div class="row">
      <h4>Total Actual Disbursed</h4>
     </div>
     </div>
    </div>

    <div class="col-md-3">
     <div class="col-md-12 inner">
     <div class="row">
      <div class="col-md-7">
      <?php
       $disb = mysqli_fetch_assoc(mysqli_query($con,"SELECT SUM(disburse_fee) AS amt FROM loan_applications WHERE status='4'"))["amt"];
       $loanfee = mysqli_fetch_assoc(mysqli_query($con,"SELECT SUM(loan_fee) AS amt FROM loan_applications WHERE status='4'"))["amt"];
      ?>
      <h1>Ksh <?php echo number_format($disb+$loanfee);?></h1>
      </div>
      <div class="col-md-5">
       <i class="fas fa-file-invoice"></i>
      </div>
     </div>
     <div class="row">
      <h4>Total Pocessing Fee</h4>
     </div>
     </div>
    </div>

    <div class="col-md-3">
     <div class="col-md-12 inner">
     <div class="row">
      <div class="col-md-7">
      <h1>Ksh <?php echo number_format(mysqli_fetch_assoc(mysqli_query($con,"SELECT SUM(amt_repaid) AS amt FROM loan_applications WHERE status='4'"))["amt"]);?></h1>
      </div>
      <div class="col-md-5">
       <i class="fas fa-file-invoice"></i>
      </div>
     </div>
     <div class="row">
      <h4>Total Paid Amount</h4>
     </div>
     </div>
    </div>

    <div class="col-md-3">
     <div class="col-md-12 inner">
     <div class="row">
      <div class="col-md-7">
       <?php 
        $interest = 0;
        $chkloans = mysqli_query($con,"SELECT * FROM loan_applications WHERE status='4'");
        while($row = mysqli_fetch_assoc($chkloans)){
         if($row["amt_repaid"] > ($row["amount_repayable"]-$row["amount"])){
          $interest += $row["amount_repayable"]-$row["amount"];
         }
         else{
          $interest += $row["amt_repaid"];
         }
        }
       ?>
      <h1>Ksh <?php echo number_format($interest);?></h1>
      </div>
      <div class="col-md-5">
       <i class="fas fa-file-invoice"></i>
      </div>
     </div>
     <div class="row">
      <h4>Total Interest Collections</h4>
     </div>
     </div>
    </div>

    <div class="col-md-3">
    <div class="col-md-12 inner">
    <div class="row">
     <div class="col-md-7">
      <?php
       $repayable = mysqli_fetch_assoc(mysqli_query($con,"SELECT SUM(amount_repayable) AS amt FROM loan_applications WHERE defaulted='4'"))["amt"];
       $repaid = mysqli_fetch_assoc(mysqli_query($con,"SELECT SUM(amt_repaid) AS amt FROM loan_applications WHERE defaulted='4'"))["amt"];
      ?>
      <h1>Ksh <?php echo number_format($repayable-$repaid);?></h1>
     </div>
     <div class="col-md-5">
      <i class="fas fa-times"></i>
     </div>
    </div>
    <div class="row">
     <h4>Total Defaulted Amount</h4>
    </div>
    </div>
    </div>

    <div class="col-md-3">
     <div class="col-md-12 inner">
     <div class="row">
      <div class="col-md-7">
      <h1>Ksh <?php echo number_format(mysqli_fetch_assoc(mysqli_query($con,"SELECT SUM(penalty) AS amt FROM loan_applications WHERE status='4'"))["amt"]);?></h1>
      </div>
      <div class="col-md-5">
       <i class="fas fa-file-invoice"></i>
      </div>
     </div>
     <div class="row">
      <h4>Total Penalty</h4>
     </div>
     </div>
    </div>
    
     <div class="col-md-3">
     <div class="col-md-12 inner">
     <div class="row">
      <div class="col-md-7">
      <h1>Ksh <?php echo number_format(mysqli_fetch_assoc(mysqli_query($con,"SELECT balance FROM mpesab2c_balance WHERE id='1'"))["balance"]);?></h1>
      </div>
      <div class="col-md-5">
       <i class="fas fa-file-invoice"></i>
      </div>
     </div>
     <div class="row">
      <h4>B2C Balance</h4>
     </div>
     </div>
    </div>
    
     <div class="col-md-3">
     <div class="col-md-12 inner">
     <div class="row">
      <div class="col-md-7">
      <h1>Ksh <?php echo number_format(mysqli_fetch_assoc(mysqli_query($con,"SELECT SUM(amount) as pos FROM loan_repayments WHERE paymode='POS-CASH' AND loanId!='107'"))["pos"]);?></h1>
      </div>
      <div class="col-md-5">
       <i class="fas fa-file-invoice"></i>
      </div>
     </div>
     <div class="row">
      <h4>Total POS Collections</h4>
     </div>
     </div>
    </div>

   </div>
   </div>
   
  <div class="panel panel-default graphical">
   <div class="panel-body">
    <script type="text/javascript">
     google.charts.load('current', {'packages':['bar']});
     google.charts.setOnLoadCallback(drawChart);
     function drawChart() {
     var data = google.visualization.arrayToDataTable([
     ['Month','Amount Disbursed','Amount Collected'],
     <?php
      foreach ($graph as $value) {
        echo "['".$value["month"]."',".$value["disburse"].",".$value["collections"]."],";
       }
      ?>]);     
       var options = {
        chart: {
            title: 'Disbursement vs Collections Summary',
            subtitle: '',
        },
        bars: 'vertical',
        vAxis: {format: 'decimal',
                title:'Numbers/Amount'
        },
        hAxis: {format: 'decimal',
               title:'Months of the Year <?php echo $year;?>'
        },
        height: 300,
        colors: ['#0000fe', '#f8c301']
        };
        var chart = new google.charts.Bar(document.getElementById('bar-graph'));
        chart.draw(data, google.charts.Bar.convertOptions(options));
      }
     </script>
     <div id="bar-graph"></div>
    </div>
   </div>
   
   <div class="panel panel-default graphical">
   <div class="panel-body">
    <script type="text/javascript">
     google.charts.load('current', {'packages':['bar']});
     google.charts.setOnLoadCallback(drawChart);
     function drawChart() {
     var data2 = google.visualization.arrayToDataTable([
     ['Day','Amount Disbursed','Amount Collected'],
     <?php
      foreach ($graph2 as $value) {
        echo "['".$value["day"]."',".$value["disburse"].",".$value["collections"]."],";
       }
      ?>]);     
       var options2 = {
        chart: {
            title: 'Daily Disbursements vs Collections',
            subtitle: '',
        },
        bars: 'vertical',
        vAxis: {format: 'decimal',
                title:'Numbers/Amount'
        },
        hAxis: {format: 'decimal',
               title:'Days of the Month'
        },
        height: 300,
        colors: ['#f90305', '#1a1e2d']
        };
        var chart2 = new google.charts.Bar(document.getElementById('bar-graph2'));
        chart2.draw(data2, google.charts.Bar.convertOptions(options2));
      }
     </script>
    
     <div id="bar-graph2"></div>
    </div>
   </div>
   
    <div class="panel panel-default graphical">
   <div class="panel-body">
    <script type="text/javascript">
     google.charts.load('current', {'packages':['bar']});
     google.charts.setOnLoadCallback(drawChart);
     function drawChart() {
     var data3 = google.visualization.arrayToDataTable([
     ['Day','Amount Collected'],
     <?php
      foreach ($graph3 as $value) {
        echo "['".$value["day"]."',".$value["collections"]."],";
       }
      ?>]);     
       var options2 = {
        chart: {
            title: 'POS Daily Collections',
            subtitle: '',
        },
        bars: 'vertical',
        vAxis: {format: 'decimal',
                title:'Numbers/Amount'
        },
        hAxis: {format: 'decimal',
               title:'Days of the Month'
        },
        height: 300,
        colors: ['#98BF32', '#1a1e2d']
        };
        var chart2 = new google.charts.Bar(document.getElementById('bar-graph3'));
        chart2.draw(data3, google.charts.Bar.convertOptions(options2));
      }
     </script>
    
     <div id="bar-graph3"></div>
    </div>
   </div>
   
   
    <div class="panel panel-default graphical">
       <div class="panel-body">
        <script type="text/javascript">
         google.charts.load('current', {'packages':['bar']});
         google.charts.setOnLoadCallback(drawChart);
         function drawChart() {
         var data4 = google.visualization.arrayToDataTable([
         ['Day','Interest','Expense'],
         <?php
          foreach ($graph4 as $value) {
            echo "['".$value["day"]."',".$value["interest"].",".$value["expense"]."],";
           }
          ?>]);     
           var options4 = {
            chart: {
                title: 'Daily Interest vs Expense',
                subtitle: '',
            },
            bars: 'vertical',
            vAxis: {format: 'decimal',
                    title:'Numbers/Amount'
            },
            hAxis: {format: 'decimal',
                   title:'Days of the Month'
            },
            height: 300,
            colors: ['#f90305', '#1a1e2d']
            };
            var chart2 = new google.charts.Bar(document.getElementById('bar-graph4'));
            chart2.draw(data2, google.charts.Bar.convertOptions(options4));
          }
         </script>
        
         <div id="bar-graph4"></div>
        </div>
       </div>
   
  </div>

  <div id="filtermodal" class="modal fade" role="dialog">
   <div class="modal-dialog">
    <div class="modal-content">
     <h3><i class="far fa-calendar-alt"></i> Customized Duration Report<span class="close pull-right" data-dismiss="modal"><i class="fas fa-times"></i></span></h3>
     <form role="form" id="filterform">
      <div class="col-md-6">
       <div class="form-group">
        <label>Start Date <span>*</span></label>
        <input type="date" class="form-control" id="date1" required>
       </div>
      </div>
      <div class="col-md-6">
       <div class="form-group">
        <label>End Date <span>*</span></label>
        <input type="date" class="form-control" id="date2" required>
       </div>
      </div>
      <div class="form-group">
       <button class="btn btn-block" type="submit"><i class="fa fa-save"></i> Show Report</button>
      </div>
      <div class="form-group">
       <div id="filterstatus"></div>
      </div>
     </form>
    </div>
   </div>
  </div>
  
 </div>
</div>
</div>
</section>
<script src="<?php echo $base_url;?>assets/bootstrap/bootstrap.min.js"></script>
<script src="<?php echo $base_url;?>assets/js/dashboard.js"></script>
<script>
 $(function(){
  $("#hm").attr("class","active");
  $('[data-toggle="tooltip"]').tooltip();

  //Custom duration report
  $("#filterform").submit(function(e){
   e.preventDefault();
   var date1 = $("#date1").val();
   var date2 = $("#date2").val();
   $("#filterform .btn").attr("disabled","disabled");
   $("#filterstatus").html("<p class='alert alert-success' style='padding:10px;'><i class='fa fa-spinner fa-pulse'></i> Please wait....</p>");
   $.ajax({
    type: "POST",
    url: $("#portal_url").html()+"reports/dashboard",
    data: {
      date1:date1,
      date2:date2
    },
    cache: false
   }).done(function(data){
    $("#filterform .btn").removeAttr("disabled");
    $("#filterstatus").html("");
    $(".dashboard").html(data);
    $('#filtermodal').modal('toggle');
    $('#tb_aging').DataTable({"aaSorting": []});
   });
  });
});
</script>
</body>
</html>
