<?php
ob_start();
session_start();
include_once("../config/index.php");
include_once("includes/auth.php");
$now = date('Y-m-d H:i:s');
$uid = $user["id"];
?>
<!DOCTYPE html>
<html lang="en-US">
<head>
<meta charset="UTF-8">
<title>Loan Defaulters | Microfinance</title>
<meta name="viewport" content="width=device-width,initial-scale=1">
<link rel="shortcut icon" href="<?php echo $base_url;?>assets/images/logo/favicon.ico">
<link href="<?php echo $base_url;?>assets/bootstrap/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="<?php echo $base_url;?>assets/css/dataTables.bootstrap4.min.css"/>
<link rel="stylesheet" href="<?php echo $base_url;?>assets/fontawesome/css/all.min.css"> 
<link href="<?php echo $base_url;?>assets/css/dashboard.css" rel="stylesheet">
<script src="<?php echo $base_url;?>assets/js/jquery.min.js"></script>
</head>
<body> 
<?php include_once("includes/header.php");?>
<section id="main">
<div class="container-fluid">
 <div class="row">
   <?php include_once("includes/aside.php");?>
   <div class="content">
    <div class="col-md-12">
     <div class="breadcrumbs row">
      <ul class="breadcrumb">
       <li><i class="fas fa-tachometer-alt"></i>&nbsp;Dashboard</li>
       <li><i class="fas fa-hand-holding-usd"></i> &nbsp;&nbsp;Loan Defaulters</li>
      </ul>
    </div>

     <div class="panel panel-default">
       <div class="panel-header dvtitle">Loans Defaulters</div>
       <div class="panel-body">
        <div class="table-responsive row">
        <table id="tb_defaults" class="table table-striped table-bordered" cellspacing="0" width="100%">
         <thead>
           <tr><th>Loan No.</th><th>Customer</th><th>Cust No</th><th>Loan Amount</th><th>Penalty</th><th>Repayable Amount</th><th>Amount Paid</th><th>Loan Date</th><th>Due Date</th><th style="min-width: 100px;">Action</th></tr>
          </thead>
           <tbody>
             <?php
             $chkdefaulters = mysqli_query($con,"SELECT * FROM loan_applications WHERE collector='$uid' ORDER BY id DESC");
             while($row = mysqli_fetch_assoc($chkdefaulters)){
             $custid = $row["custId"];
             $cust = mysqli_fetch_assoc(mysqli_query($con,"SELECT * FROM customers WHERE id='$custid'")); ?>
             <tr>
              <td><?php echo $row["loanNo"];?></td>
              <td><?php echo $cust["first_name"]." ".$cust["last_name"];?></td>
              <td><?php echo $cust["custNo"];?></td>
              <td>KES <?php echo number_format($row["amount"]);?></td>
              <td>KES <?php echo number_format($row["penalty"]);?></td>
              <td>KES <?php echo number_format($row["amount_repayable"]);?></td>
              <td>KES <?php echo number_format($row["amt_repaid"]);?></td>
              <td><?php echo date("d/m/Y",strtotime($row["disbursed_at"]));?></td>
              <td><?php echo date("d/m/Y",strtotime($row["due_date"]));?></td>
              <td>
              <a href="<?php echo $portal_url."followup/".$row["id"];?>"><button class="btn btn-xs btn-success" data-toggle="tooltip" data-placement="bottom" title="Update collection follow up"><i class="fas fa-external-link-square-alt"></i></button></a>
              </td>  
             </tr>
             <?php }
            ?>
         </tbody>
       </table>
      </div>
    </div>
   </div>  

  </div>
 </div>
</div>
</div>
</section>
<script src="<?php echo $base_url;?>assets/bootstrap/bootstrap.min.js"></script>
<script src="<?php echo $base_url;?>assets/js/dashboard.js"></script>
<script src="<?php echo $base_url;?>assets/js/jquery.dataTables.min.js"></script>
<script src="<?php echo $base_url;?>assets/js/dataTables.bootstrap4.min.js"></script>
<script>
$(function(){
 $("#default").attr("class","active");
 $('#tb_defaults').DataTable({"aaSorting":[]});
 });
</script>
</body>
</html>