<?php
ob_start();
session_start();
include_once("../config/index.php");
include_once("includes/auth.php");
$now = date('Y-m-d H:i:s');
$uid = $cust["id"];
?>
<!DOCTYPE html>
<html lang="en-US">
<head>
<meta charset="UTF-8">
<title>My Loan Applications | Microfinance</title>
<meta name="viewport" content="width=device-width,initial-scale=1">
<link rel="shortcut icon" href="<?php echo $base_url;?>assets/images/logo/favicon.ico">
<link href="<?php echo $base_url;?>assets/bootstrap/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="<?php echo $base_url;?>assets/css/dataTables.bootstrap4.min.css"/>
<link rel="stylesheet" href="<?php echo $base_url;?>assets/fontawesome/css/all.min.css"> 
<link href="<?php echo $base_url;?>assets/css/dashboard.css" rel="stylesheet">
<script src="<?php echo $base_url;?>assets/js/jquery.min.js"></script>
<style>
.modal-dialog{
  max-width: 800px !important;
}
.modal-dialog .col-md-4{
  padding: 2px;
}
form{
  padding-left: 5px;
  padding-right: 10px;
}
#loanfrm p{
  padding-left: 5px;
}
.custinfo,.bsinfo{
  border-bottom: 1px dashed #ddd;
  padding: 0;
  color: #c1c100;
}
.bsinfo{
  margin-top: 20px;
}
#loanmodal td{
  padding: 0!important;
  max-width: 200px;
  border-right: 1px solid #ddd;
}
#loanmodal td input{
  border: none;
  box-shadow: none;
  width: 100%;
}
</style>
</head>
<body> 
<?php include_once("includes/header.php");?>
<section id="main">
<div class="container-fluid">
 <div class="row">
   <?php include_once("includes/aside.php");?>
   <div class="content">
    <div class="col-md-12">
     <div class="breadcrumbs row">
      <ul class="breadcrumb">
       <li><i class="fas fa-tachometer-alt"></i>&nbsp;Dashboard</li>
       <li><i class="fas fa-hand-holding-usd"></i> &nbsp;&nbsp;Loans</li>
      </ul>
    </div>

    <div class="row wrapper">
      <button class="btn item item1" data-dismiss="modal" data-toggle="modal" data-target="#loanmodal"><i class="fa fa-plus"></i> Apply for a Loan</button>
      <span class="item item2" data-dismiss="modal" data-toggle="modal" data-target="#loanmodal" style="display: none;"></span>
    </div>

     <div class="panel panel-default">
       <div class="panel-header dvtitle">My Loan Applications</div>
       <div class="panel-body">
        <div class="table-responsive row">
        <table id="tb_loans" class="table table-striped table-bordered" cellspacing="0" width="100%">
         <thead>
           <tr><th>Loan No.</th><th>Loan Product</th><th>Sequence</th><th>Amount</th><th>Repayable</th><th>Status</th><th style="min-width: 100px;">Action</th></tr>
          </thead>
           <tbody>
             <?php
             $chkloans = mysqli_query($con,"SELECT * FROM loan_applications WHERE custId='$uid' ORDER BY id DESC");
             while($row = mysqli_fetch_assoc($chkloans)){ ?>
             <tr>
              <td><a href="<?php echo $portal_url;?>loan/<?php echo $row["loanNo"];?>"><?php echo $row["loanNo"];?></a></td>
              <td>
               <?php
                $prodid = $row["prodId"];
                $prod = mysqli_fetch_assoc(mysqli_query($con,"SELECT * FROM loan_products WHERE id='$prodid'"));
                echo $prod["name"];
               ?>
              </td>
              <td>
               <?php
                $seqid = $row["seqId"];
                $seq = mysqli_fetch_assoc(mysqli_query($con,"SELECT * FROM loan_sequence WHERE id='$seqid'"));
                echo $seq["name"];
               ?>
              </td>
              <td>KES <?php echo number_format($row["amount"]);?></td>
              <td>KES <?php echo number_format($row["amount_repayable"]);?></td>
              <td>
               <?php
               if($row["status"] == 1){ ?>
                <span class="btn btn-xs btn-warning">Pending</span>
               <?php }
               if($row["status"] == 2){ ?>
                <span class="btn btn-xs btn-info">Approved</span>
               <?php }
               if($row["status"] == 3){ ?>
                <span class="btn btn-xs btn-danger">Rejected</span>
               <?php }
               if($row["status"] == 4){ ?>
                <span class="btn btn-xs btn-success">Disbursed</span>
               <?php }
               ?>
              </td>
              <td>
              <a href="<?php echo $portal_url;?>loan/<?php echo $row["loanNo"];?>"><button class="btn btn-xs btn-success" data-toggle="tooltip" data-placement="bottom" title="View loan details"><i class="fas fa-search-plus"></i></button></a>
              </td>  
             </tr>
             <?php }
            ?>
         </tbody>
       </table>
      </div>
    </div>
   </div>
  

<div id="loanmodal" class="modal fade" role="dialog">
 <div class="modal-dialog">
  <div class="modal-content">
   <h3><i class="fas fa-users"></i> Loan Application Form<span class="close pull-right" data-dismiss="modal"><i class="fas fa-times"></i></span></h3>
   <form role="form" id="loanfrm">
   <p>Fill in loan details. All fields marked with <span style="color: #ff0000">*</span> are mandatory.</p> 
    <div class="col-md-12 custinfo">
     <h4>Loan Particulars</h4>
    </div>
    <div class="col-md-4">
     <div class="form-group">
      <label>Loan product <span>*</span></label>
      <input type="hidden" id="id" value="">
      <select class="form-control" id="prodid">
      <?php
       $chkproducts = mysqli_query($con,"SELECT * FROM loan_products");
       while($row = mysqli_fetch_assoc($chkproducts)){ ?>
        <option value="<?php echo $row["id"];?>"><?php echo $row["name"];?></option>
      <?php } ?>
      </select>
     </div>
    </div>
    <div class="col-md-4">
     <div class="form-group">
      <label>Repayment Sequence <span>*</span></label>
      <select class="form-control" id="seqid">
      <?php
       $chksequence = mysqli_query($con,"SELECT * FROM loan_sequence");
       while($row = mysqli_fetch_assoc($chksequence)){ ?>
        <option value="<?php echo $row["id"];?>"><?php echo $row["name"];?></option>
      <?php } ?>
      </select>
     </div>
    </div>
    <div class="col-md-4">
     <div class="form-group">
      <label>Loan Amount <span>*</span></label>
      <input type="number" class="form-control" id="amount" required>
     </div>
    </div>
    <div class="col-md-4">
     <div class="form-group">
      <label>Mpesa Number <span>*</span></label>
      <input type="text" class="form-control" id="phone" required>
     </div>
    </div>
    <div class="col-md-6">
     <div class="form-group">
      <label>Purpose of Loan <span>*</span></label>
      <input type="text" class="form-control" id="purpose" required>
     </div>
    </div>
    

    <div class="col-md-12 bsinfo">
     <h4>Loan Referees</h4>
    </div>
    <div class="table-responsive">
    <table class="table table-bordered" style="min-width: 700px !important;">
     <thead>
     <tr><th>Name</th><th>Address</th><th>Phone 1</th><th>Phone 2</th><th>Relationship</th></tr>
     </thead>
     <tbody>
     <tr>
      <td><input type="text" id="ref1name"></td>
      <td><input type="text" id="ref1address"></td>
      <td><input type="text" id="ref1phone1"></td>
      <td><input type="text" id="ref1phone2"></td>
      <td><input type="text" id="ref1rel"></td>
     </tr>
     <tr>
      <td><input type="text" id="ref2name"></td>
      <td><input type="text" id="ref2address"></td>
      <td><input type="text" id="ref2phone1"></td>
      <td><input type="text" id="ref2phone2"></td>
      <td><input type="text" id="ref2rel"></td>
     </tr>
     </tbody>
    </table>
    </div>
    

    <div class="col-md-12 bsinfo">
     <h4>Loan Guarantors</h4>
    </div>
    <div class="table-responsive">
    <table class="table table-bordered" style="min-width: 800px !important;">
     <thead>
     <tr><th>Name</th><th>Relationship</th><th>Phone 1</th><th>Phone 2</th><th>Occupation</th><th>Residence</th><th>Landmark</th></tr>
     </thead>
     <tbody>
     <tr>
      <td><input type="text" id="guar1"></td>
      <td><input type="text" id="guar1rel"></td>
      <td><input type="text" id="guar1phone1"></td>
      <td><input type="text" id="guar1phone2"></td>
      <td><input type="text" id="guar1occup"></td>
      <td><input type="text" id="guar1resid"></td>
      <td><input type="text" id="guar1landmark"></td>
     </tr>
     <tr>
      <td><input type="text" id="guar2"></td>
      <td><input type="text" id="guar2rel"></td>
      <td><input type="text" id="guar2phone1"></td>
      <td><input type="text" id="guar2phone2"></td>
      <td><input type="text" id="guar2occup"></td>
      <td><input type="text" id="guar2resid"></td>
      <td><input type="text" id="guar2landmark"></td>
     </tr>
     </tbody>
    </table>
    </div>
    

    <div class="col-md-12 bsinfo">
     <h4>Loan Collaterals</h4>
    </div>
    <div class="table-responsive">
    <table class="table table-bordered">
     <thead>
     <tr><th>Item Description</th><th>Serial No.</th><th>Estimate value</th></tr>
     </thead>
     <tbody>
     <tr>
      <td><input type="text" id="item1"></td>
      <td><input type="text" id="item1serial"></td>
      <td><input type="text" id="item1value"></td>
     </tr>
     <tr>
      <td><input type="text" id="item2"></td>
      <td><input type="text" id="item2serial"></td>
      <td><input type="text" id="item2value"></td>
     </tr>
     <tr>
      <td><input type="text" id="item3"></td>
      <td><input type="text" id="item3serial"></td>
      <td><input type="text" id="item3value"></td>
     </tr>
     <tr>
      <td><input type="text" id="item4"></td>
      <td><input type="text" id="item4serial"></td>
      <td><input type="text" id="item4value"></td>
     </tr>
     <tr>
      <td><input type="text" id="item5"></td>
      <td><input type="text" id="item5serial"></td>
      <td><input type="text" id="item5value"></td>
     </tr>
     </tbody>
    </table>
    </div>
    <div class="form-group" style="border-top: 1px solid #ddd;padding-top: 5px;">
      <button class="btn btn-block" type="submit"> <i class="fa fa-save"></i> Submit Application</button>
    </div>
    <div class="form-group">
     <div id="status"></div>
    </div>
   </form>
  </div>
 </div>
</div>

  </div>
 </div>
</div>
</div>
</section>
<script src="<?php echo $base_url;?>assets/bootstrap/bootstrap.min.js"></script>
<script src="<?php echo $base_url;?>assets/js/dashboard.js"></script>
<script src="<?php echo $base_url;?>assets/js/jquery.dataTables.min.js"></script>
<script src="<?php echo $base_url;?>assets/js/dataTables.bootstrap4.min.js"></script>
<script>
$(function(){
 $("#loan").attr("class","active");
 $('#tb_loans').DataTable({"aaSorting":[]});

 $("#loanfrm").submit(function(e){
  e.preventDefault();
  var id = $("#id").val();
  var custid = $("#custid").val();
  var prodid = $("#prodid").val();
  var seqid = $("#seqid").val();
  var amount = $("#amount").val();
  var phone = $("#phone").val();
  var purpose = $("#purpose").val();
  var ref1name = $("#ref1name").val();
  var ref1address = $("#ref1address").val();
  var ref1phone1 = $("#ref1phone1").val();
  var ref1phone2 = $("#ref1phone2").val();
  var ref1rel = $("#ref1rel").val();
  var ref2name = $("#ref2name").val();
  var ref2address = $("#ref2address").val();
  var ref2phone1 = $("#ref2phone1").val();
  var ref2phone2 = $("#ref2phone2").val();
  var ref2rel = $("#ref2rel").val();
  var guar1 = $("#guar1").val();
  var guar1rel = $("#guar1rel").val();
  var guar1phone1 = $("#guar1phone1").val();
  var guar1phone2 = $("#guar1phone2").val();
  var guar1occup = $("#guar1occup").val();
  var guar1resid = $("#guar1resid").val();
  var guar1landmark = $("#guar1landmark").val();
  var guar2 = $("#guar2").val();
  var guar2rel = $("#guar2rel").val();
  var guar2phone1 = $("#guar2phone1").val();
  var guar2phone2 = $("#guar2phone2").val();
  var guar2occup = $("#guar2occup").val();
  var guar2resid = $("#guar2resid").val();
  var guar2landmark = $("#guar2landmark").val();
  var item1 = $("#item1").val();
  var item1serial = $("#item1serial").val();
  var item1value = $("#item1value").val();
  var item2 = $("#item2").val();
  var item2serial = $("#item2serial").val();
  var item2value = $("#item2value").val();
  var item3 = $("#item3").val();
  var item3serial = $("#item3serial").val();
  var item3value = $("#item3value").val();
  var item4 = $("#item4").val();
  var item4serial = $("#item4serial").val();
  var item4value = $("#item4value").val();
  var item5 = $("#item5").val();
  var item5serial = $("#item5serial").val();
  var item5value = $("#item5value").val();
  $("#status").html("<p class='text-success bg-success'><i class='fa fa-spinner fa-pulse'></i> Submitting the loan details...</p>"); 
  $.ajax({
    method: "POST",
    url: $("#portal_url").html()+"app/loans",
    data: {
      id:id,
      custid:custid,
      prodid:prodid,
      seqid:seqid,
      amount:amount,
      phone:phone,
      purpose:purpose,
      ref1name:ref1name,
      ref1address:ref1address,
      ref1phone1:ref1phone1,
      ref1phone2:ref1phone2,
      ref1rel:ref1rel,
      ref2name:ref2name,
      ref2address:ref2address,
      ref2phone1:ref2phone1,
      ref2phone2:ref2phone2,
      ref2rel:ref2rel,
      guar1:guar1,
      guar1rel:guar1rel,
      guar1phone1:guar1phone1,
      guar1phone2:guar1phone2,
      guar1occup:guar1occup,
      guar1resid:guar1resid,
      guar1landmark:guar1landmark,
      guar2:guar2,
      guar2rel:guar2rel,
      guar2phone1:guar2phone1,
      guar2phone2:guar2phone2,
      guar2occup:guar2occup,
      guar2resid:guar2resid,
      guar2landmark:guar2landmark,
      item1:item1,
      item1serial:item1serial,
      item1value:item1value,
      item2:item2,
      item2serial:item2serial,
      item2value:item2value,
      item3:item3,
      item3serial:item3serial,
      item3value:item3value,
      item4:item4,
      item4serial:item4serial,
      item4value:item4value,
      item5:item5,
      item5serial:item5serial,
      item5value:item5value
    },
    cache:false
  }).done(function(data){
   if(data.status == 200){
    $("#status").html("<p class='alert alert-success'><i class='fa fa-check'></i> Application submited successfully.</p>").delay(5000);
     window.location.replace($("#portal_url").html()+"loans");
   }
   if(data.status == 300){
    $("#status").html("<p class='alert alert-danger'><i class='fa fa-exclamation-circle'></i> An error occured, please try again later.</p>");
   }
   if(data.status == 401){
    $("#status").html("<p class='alert alert-danger'><i class='fa fa-exclamation-circle'></i> You have an existing loan that is not fully paid. Please complete repayment and reapply.</p>");
   }
  });
 });
});
</script>
</body>
</html>