<?php
ob_start();
session_start();
include_once("../config/index.php");
include_once("includes/auth.php");
?>
<!DOCTYPE html>
<html lang="en-US">
<head>
<meta charset="UTF-8">
<title>Settings | Microfinance</title>
<meta name="viewport" content="width=device-width,initial-scale=1">
<link rel="shortcut icon" href="<?php echo $base_url;?>assets/images/logo/favicon.ico">
<link href="<?php echo $base_url;?>assets/bootstrap/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="<?php echo $base_url;?>assets/fontawesome/css/all.min.css"> 
<link href="<?php echo $base_url;?>assets/css/dashboard.css" rel="stylesheet">
</head>
<body>
<?php include_once("includes/header.php");?>
<section id="main">
<div class="container-fluid">
 <div class="row">
 <?php include_once("includes/aside.php");?>
   <div class="content">
    <div class="col-md-12">
     <div class="breadcrumbs row">
      <ul class="breadcrumb">
        <li><i class="fas fa-tachometer-alt"></i>&nbsp;Dashboard</li>
        <li><i class="fa fa-cogs"></i> Settings</li>
      </ul>
     </div>

     <div class="panel panel-default">
      <div class="panel-heading dvtitle">Edit your password</div>
       <form role="form" id="pwdform">
        <div class="panel-body">
          <p style="border-bottom: 1px solid #ddd">All fields marked with (<span style="color:#ff0000">*</span>) are required</p>
          <div class="col-md-4">
           <div class="row">
           <div class="form-group">
            <label>Current Password <span>*</span></label>
              <input type="password" class="form-control" id="opass" minlength="6" maxlength="20" required>
            </div>
           </div>
          </div>
          <div class="col-md-4">
           <div class="row">
           <div class="form-group">
            <label>Create a new password <span>*</span></label>
              <input type="password" class="form-control" id="pass" minlength="6" maxlength="20" required>
            </div>
           </div>
          </div>
          <div class="col-md-4">
           <div class="row">
           <div class="form-group">
            <label>Confirm password <span>*</span></label>
              <input type="password" class="form-control" id="cpass" minlength="6" maxlength="20" required>
           </div>
          </div>
          </div>
          <div class="col-md-12">
           <div id="pwdstatus"></div>
         </div>
         </div>
         <div class="panel-footer">
         <button class="btn sbtbtn" type="submit"><i class="fa fa-save"></i> Save Password</button>
         <input type="reset" id="clear" style="display: none;">
         </div>
       </form>
       </div>

  </div>
 </div>
</div>
</div>
</section>
<script src="<?php echo $base_url;?>assets/js/jquery.min.js"></script>
<script src="<?php echo $base_url;?>assets/bootstrap/bootstrap.min.js"></script>
<script src="<?php echo $base_url;?>assets/js/dashboard.js"></script>
<script src="<?php echo $base_url;?>assets/js/jquery.dataTables.min.js"></script>
<script src="<?php echo $base_url;?>assets/js/jquery.dataTables.bootstrap.min.js"></script>
<script>
 $(function(){
  $("#sett").attr("class","active");

  $(".webmnu li").click(function(){
    $(".panel").hide();
    $(".webmnu li").removeAttr("class");
    $(this).attr("class","active");
    $("#"+$(this).attr("data-id")).show();
  });

  $("#pwdform").submit(function(e){
   e.preventDefault();
   var opass = $("#opass").val();
   var pass = $("#pass").val();
   var cpass = $("#cpass").val();
   if(pass == cpass){
    $("#pwdstatus").html("<p class='alert alert-success'><i class='fas fa-spinner fa-pulse'></i> Updating the changes...</p>");
    $.ajax({
      method: "POST",
      url: $("#portal_url").html()+"app/passwords",
      data: {opass:opass,pass:pass},
      cache:false
    }).done(function(data){
      if(data.status == 200){
       $("#clear").click();
       $("#pwdstatus").html("<p class='alert alert-success'><i class='fas fa-check'></i> Password updated successfully</p>");
      }
      if(data.message == "WRONGOP"){
       $("#pwdstatus").html("<p class='alert alert-danger'><i class='fas fa-exclamation-circle'></i> You entered the wrong old password. please retry with correct one.</p>");
      }
      if(data.message == "ERROR"){
       $("#pwdstatus").html("<p class='alert alert-danger'><i class='fas fa-exclamation-circle'></i> An error occurred. Try again later</p>");
      }
    });
   }
   else{
    $("#pwdstatus").html("<p class='alert alert-danger'><i class='fas fa-exclamation-circle'></i> The two passwords do not match</p>");
   }
  });

 });
</script>
</body>
</html>
