<?php
ob_start();
session_start();
include_once("../config/index.php");
include_once("includes/auth.php");
$now = date('Y-m-d H:i:s');
?>
<!DOCTYPE html>
<html lang="en-US">
<head>
<meta charset="UTF-8">
<title>Bill Payments | Kuza Fine Africa</title>
<meta name="viewport" content="width=device-width,initial-scale=1">
<link rel="shortcut icon" href="<?php echo $base_url;?>assets/images/logo/favicon.ico">
<link href="<?php echo $base_url;?>assets/bootstrap/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="<?php echo $base_url;?>assets/css/dataTables.bootstrap4.min.css"/>
<link rel="stylesheet" href="<?php echo $base_url;?>assets/css/buttons.bootstrap4.min.css"/>
<link rel="stylesheet" href="<?php echo $base_url;?>assets/fontawesome/css/all.min.css"> 
<link href="<?php echo $base_url;?>assets/css/dashboard.css" rel="stylesheet">
<script src="<?php echo $base_url;?>assets/js/jquery.min.js"></script>
<style>
.modal-dialog{
  max-width: 450px;
}
form{
  padding-left: 5px;
  padding-right: 10px;
}
</style>
</head>
<body> 
<?php include_once("includes/header.php");?>
<section id="main">
<div class="container-fluid">
 <div class="row">
  <?php include_once("includes/aside.php");?>
  <div class="content">
   <div class="col-md-12">
    <div class="breadcrumbs row">
     <ul class="breadcrumb">
      <li><i class="fas fa-tachometer-alt"></i>&nbsp;Dashboard</li>
      <li><i class="fas fa-cart-arrow-down"></i> &nbsp;&nbsp;Bill Payments B2C</li>
     </ul>
    </div>

    <div class="row wrapper">
        <?php 
        $ttquery=mysqli_query($con,"SELECT SUM(amount) AS total_today FROM billpayments WHERE DATE(createdon) = CURRENT_DATE");
         $assoc=mysqli_fetch_assoc($ttquery);
         $tttoday=$assoc["total_today"];
         if($tttoday<100000){
        ?>
      <button class="btn item item1" data-dismiss="modal" data-toggle="modal" data-target="#purchmodal"><i class="fa fa-plus"></i> New Bill Payment B2C</button>
      <p>Today, You have transacted a Total of Ksh. <?php echo $tttoday ?></p>
      <?php } ?>
      <span class="item item2" data-dismiss="modal" data-toggle="modal" data-target="#purchmodal" style="display: none;"></span>&nbsp;&nbsp;&nbsp;
      <button style="display:none" class="btn item" data-dismiss="modal" data-toggle="modal" data-target="#filtermodal"><i class="far fa-calendar-alt"></i> Filter by Date</button>
    </div>

     <div class="panel panel-default dashboard">
      <div class="panel-header dvtitle">Bill Payments</div>
      <div class="panel-body">
       <div class="table-responsive row">
        <table id="tb_purchs" class="table table-striped table-bordered" cellspacing="0" width="100%">
         <thead>
          <tr><th>Description</th><th>Phone Number</th><th>Amount</th><th>Date</th><th style="min-width: 100px;">Action</th></tr>
         </thead>
         <tbody>
         <?php
          $chkpurchs = mysqli_query($con,"SELECT * FROM billpayments WHERE branchId='$branchid' ORDER BY id DESC");
          while($row = mysqli_fetch_assoc($chkpurchs)){
             
          ?>
          <tr>
           <td><?php echo $row["description"];?></td>
           <td><?php echo $row["mpesano"];?></td>
           <td>Ksh. <?php echo number_format($row["amount"]);?></td>
           <td><?php echo date("d M Y",strtotime($row["billpaymentdate"]));?></td>
           <td>
            <button class="btn btn-xs btn-danger delpurch" id="<?php echo $row["id"];?>" data-toggle="tooltip" data-placement="bottom" title="Delete billpayment"><i class="fa fa-trash"></i></button>
           </td>
          </tr>
          <?php } ?>
         </tbody>
        </table>
       </div>
      </div>
     </div>

     <div id="purchmodal" class="modal fade" role="dialog">
      <div class="modal-dialog">
       <div class="modal-content">
        <h3><i class="fas fa-cart-arrow-down"></i> New Bill Payment<span class="close pull-right" data-dismiss="modal"><i class="fas fa-times"></i></span></h3>
        <form role="form" id="billpaymentfrm">

        <div class="form-group">
         <label>Description <span>*</span></label>
         <input type="hidden" id="id" value="" name="id">
         <input type="text" class="form-control" id="description" name="description" required>
        </div>
         <div class="form-group">
         <label>Mpesa Number <span>*</span></label>
         <input type="number" class="form-control" id="mpesano" name="mpesano" min="10" maxlength="12" required>
        </div>
        <div class="form-group">
         <label>Amount <span>*</span></label>
         <input type="number" class="form-control" id="amount" name="amount" required>
        </div>
        <div class="form-group">
         <label>Date of Bill Payment <span>*</span></label>
         <input type="date" class="form-control" id="billpaymentdate" name="billpaymentdate" required>
        </div>
        <div class="form-group" style="border-top: 1px solid #ddd;padding-top: 5px;">
         <button class="btn btn-block" type="submit"> <i class="fa fa-save"></i> Save Bill Payment</button>
        </div>
        <div class="form-group">
         <div id="status"></div>
        </div>
       </form>
      </div>
     </div>
    </div>
    
    <div id="filtermodal" class="modal fade" role="dialog">
   <div class="modal-dialog">
    <div class="modal-content">
     <h3><i class="far fa-calendar-alt"></i> Customized Duration Report<span class="close pull-right" data-dismiss="modal"><i class="fas fa-times"></i></span></h3>
     <form role="form" id="filterform">
      <div class="col-md-6">
       <div class="form-group">
        <label>Start Date <span>*</span></label>
        <input type="date" class="form-control" id="date1" required>
       </div>
      </div>
      <div class="col-md-6">
       <div class="form-group">
        <label>End Date <span>*</span></label>
        <input type="date" class="form-control" id="date2" required>
       </div>
      </div>
      <div class="form-group">
       <button class="btn btn-block" type="submit"><i class="fa fa-save"></i> Show Report</button>
      </div>
      <div class="form-group">
       <div id="filterstatus"></div>
      </div>
     </form>
    </div>
   </div>
  </div>

  </div>
 </div>
</div>
</div>
</section>
<script src="<?php echo $base_url;?>assets/bootstrap/bootstrap.min.js"></script>
<script src="<?php echo $base_url;?>assets/js/dashboard.js"></script>
<script src="<?php echo $base_url;?>assets/js/jquery.dataTables.min.js"></script>
<script src="<?php echo $base_url;?>assets/js/dataTables.bootstrap4.min.js"></script>
<script>
$(function(){
 $("#bp").attr("class","active");
 $('#tb_purchs').DataTable({"aaSorting":[]});

 $("body").on("click",".edtpurch",function(){
  $("#id").val($(this).attr("data-id"));
  $("#billpaymentdate").val($(this).attr("data-billpaymentdate"));
  $("#description").val($(this).attr("data-description"));
  $("#amount").val($(this).attr("data-amount"));
  $("#status").html("");
  $(".item1").click();
 });

 $("#billpaymentfrm").submit(function(e){
  e.preventDefault();
  var id = $("#id").val();
  var billpaymentdate = $("#billpaymentdate").val();
  var description = $("#description").val();
  var amount = $("#amount").val();
  var mpesano = $("#mpesano").val();
  
  $("#status").html("<p class='text-success bg-success'><i class='fa fa-spinner fa-pulse'></i> Saving the billpayment...</p>"); 
  $.ajax({
    method: "POST",
    url: $("#portal_url").html()+"app/billpayments",
    data: {
      id:id,
      billpaymentdate:billpaymentdate,
      description:description,
      amount:amount,
      mpesano:mpesano
    },
    cache:false
  }).done(function(data){
   if(data.status == 200){
    $("#status").html("<p class='alert alert-success'><i class='fa fa-check'></i> billpayment saved successfully.</p>").delay(5000);
     window.location.replace($("#portal_url").html()+"billpayments");
   }
   if(data.status == 300){
    $("#status").html("<p class='alert alert-danger'><i class='fa fa-exclamation-circle'></i> An error occured, please try again later.</p>");
   }
  });
 });

 //Deleting a billpayment
 $(".delpurch").click(function(){
  var delpurch = $(this).attr("id");
  var d = confirm('Are you sure you want to delete this billpayment?');
  if(d == false){
   return false;
  }
  else{
    $.ajax({
      method:"post",
      url: $("#portal_url").html()+"app/billpayments",
      data:{
        delpurch:delpurch
      },
      cache:false
    }).done(function(data){
      if(data.status == "200"){
       window.location.replace($("#portal_url").html()+"billpayments");
      }
    });
    }
   });
   
   //Custom duration report
  $("#filterform").submit(function(e){
   e.preventDefault();
   var date1 = $("#date1").val();
   var date2 = $("#date2").val();
   $("#filterform .btn").attr("disabled","disabled");
   $("#filterstatus").html("<p class='alert alert-success' style='padding:10px;'><i class='fa fa-spinner fa-pulse'></i> Please wait....</p>");
   $.ajax({
    type: "POST",
    url: $("#portal_url").html()+"reports/billpayments",
    data: {
      date1:date1,
      date2:date2
    },
    cache: false
   }).done(function(data){
    $("#filterform .btn").removeAttr("disabled");
    $("#filterstatus").html("");
    $(".dashboard").html(data);
    $('#filtermodal').modal('toggle');
    $('#tb_purchs').DataTable({"aaSorting": []});
   });
  });
 });
</script>
</body>
</html>