<?php
ob_start();
session_start();
include_once("../config/index.php");
include_once("includes/auth.php");
$now = date('Y-m-d H:i:s');
$branchid = $user["branchId"];
?>
<!DOCTYPE html>
<html lang="en-US">
<head>
<meta charset="UTF-8">
<title>Chap Chap Loan Applications | Kuza Work Africa</title>
<meta name="viewport" content="width=device-width,initial-scale=1">
<link rel="shortcut icon" href="<?php echo $base_url;?>assets/images/logo/favicon.ico">
<link href="<?php echo $base_url;?>assets/bootstrap/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="<?php echo $base_url;?>assets/css/dataTables.bootstrap4.min.css"/>
<link rel="stylesheet" href="<?php echo $base_url;?>assets/fontawesome/css/all.min.css"> 
<link href="<?php echo $base_url;?>assets/css/dashboard.css" rel="stylesheet">
<script src="<?php echo $base_url;?>assets/js/jquery.min.js"></script>
</head>
<body> 
<?php include_once("includes/header.php");?>
<section id="main">
<div class="container-fluid">
 <div class="row">
   <?php include_once("includes/aside.php");?>
   <div class="content">
    <div class="col-md-12">
     <div class="breadcrumbs row">
      <ul class="breadcrumb">
       <li><i class="fas fa-tachometer-alt"></i>&nbsp;Dashboard</li>
       <li><i class="fas fa-hand-holding-usd"></i> &nbsp;&nbsp;Chap Chap Loan Applications</li>
      </ul>
    </div>
    <span class="item item2" data-dismiss="modal" data-toggle="modal" data-target="#chapchaploanmodal" style="display: none;"></span>

     <div class="panel panel-default">
       <div class="panel-header dvtitle">Loan Applications</div>
       <div class="panel-body">
        <div class="table-responsive row">
        <table id="tb_chapchaploans" class="table table-striped table-bordered" cellspacing="0" width="100%">
         <thead>
           <tr><th>Loan No.</th><th>Customer</th><th>Loan Product</th><th>Loan Amount</th><th>Disbursed Amount</th><th>Disbursement Date</th><th>Status</th><th style="min-width: 100px;">Action</th></tr>
          </thead>
           <tbody>
             <?php
             $chkchapchaploans = mysqli_query($con,"SELECT chapchaploan_applications.* FROM chapchaploan_applications,users WHERE chapchaploan_applications.userId=users.id AND users.branchId='$branchid' AND status!='1' AND status!='4' ORDER BY chapchaploan_applications.id DESC");
             while($row = mysqli_fetch_assoc($chkchapchaploans)){  
              $custid = $row["custId"];
              $userid = $row["userId"];
              $recomid = $row["recommended_by"];
              $apprid = $row["approved_by"];
              $disbid = $row["disbursed_by"];
              $cust = mysqli_fetch_assoc(mysqli_query($con,"SELECT * FROM customers WHERE id='$custid'"));
              $custname=$cust["first_name"]." ".$cust["last_name"];
              $offadm = mysqli_fetch_assoc(mysqli_query($con,"SELECT * FROM users WHERE id='$userid'"));
              $recom = mysqli_fetch_assoc(mysqli_query($con,"SELECT * FROM users WHERE id='$recomid'"));
              $appr = mysqli_fetch_assoc(mysqli_query($con,"SELECT * FROM users WHERE id='$apprid'"));
              $disb = mysqli_fetch_assoc(mysqli_query($con,"SELECT * FROM users WHERE id='$disbid'"));
              $offadm = $offadm["first_name"]." ".$offadm["last_name"];
              $recom = $recom["first_name"]." ".$recom["last_name"];
              $approver = $appr["first_name"]." ".$appr["last_name"];
              $disburser = $disb["first_name"]." ".$disb["last_name"];
              if($cust["branchId"] == $branchid){ ?>
             <tr>
              <td><?php echo $row["chapchaploanNo"];?></td>
              <td>
               <?php
                $customer = $cust["first_name"]." ".$cust["last_name"]." (".$cust["custNo"].")";
                echo $customer;
               ?>
              </td>
              <td>
               <?php
                $prodid = $row["prodId"];
                $prod = mysqli_fetch_assoc(mysqli_query($con,"SELECT * FROM loan_products WHERE id='$prodid'"));
                echo $prod["name"];
               ?>
              </td>
              <td>KES <?php echo number_format($row["amount"]);?></td>
              <td>KES <?php echo number_format($row["disbursed_amount"]);?></td>
              <td>
               <?php
                if($row["status"] == 3){
                 echo date("d/m/Y H:i",strtotime($row["disbursed_at"]));
                }
               ?>
              </td>
              <td>
               <?php
               if($row["status"] == 0){ ?>
                <span class="btn btn-xs btn-warning">Pending</span>
               <?php }
               if($row["status"] == 2){ ?>
                <span class="btn btn-xs btn-info">Approved</span>
               <?php }
               if($row["status"] == 3){ ?>
                <span class="btn btn-xs btn-danger">Rejected</span>
               <?php }
               if($row["status"] == 4){ ?>
                <span class="btn btn-xs btn-success">Disbursed</span>
               <?php }
               ?>
              </td>
              <td>
              <button class="btn btn-xs btn-primary details" data-toggle="tooltip" data-placement="bottom" title="View chapchaploan details" data-cust="<?php echo $customer;?>" data-prod="<?php echo $prod["name"];?>" data-amount="<?php echo number_format($row["amount"]);?>" data-offadm="<?php echo $offadm;?>" data-recom="<?php echo $recom;?>" data-approver="<?php echo $approver;?>" data-disburser="<?php echo $disburser;?>"><i class="fas fa-list"></i></button>
              <?php if($row["status"] == 2){ ?>
               <button class="btn btn-xs disburse" style="background: #ff0000;color:#fff;" id="<?php echo $row["id"];?>" data-custname="<?php echo $custname ?>" data-phone="<?php echo $row["mpesaNo"];?>" data-toggle="tooltip" data-placement="bottom" title="Send money to the chapchaploan applicant"><i class="fas fa-comment-dollar"></i> Disburse Money</button>
               <button class="btn btn-xs btn-success markasdisbursed" id="<?php echo $row["id"];?>" data-phone="<?php echo $row["mpesaNo"];?>" data-toggle="tooltip" data-placement="bottom" title=""><i class="fas fa-comment-dollar"></i> Mark as Disbursed</button>
              <?php } ?>
              </td>  
             </tr>
             <?php } }
            ?>
         </tbody>
       </table>
      </div>
    </div>
   </div>  

   <div id="chapchaploanmodal" class="modal fade" role="dialog">
    <div class="modal-dialog">
     <div class="modal-content">
      <h3><i class="fas fa-hand-holding-usd"></i> Loan Details<span class="close pull-right" data-dismiss="modal"><i class="fas fa-times"></i></span></h3>
      <div class="table-responsive">
       <table class="table table-bordered table-striped">
        <tbody>
         <tr><td>Customer:</td><td class="lncust"></td></tr>
         <tr><td>Loan Product:</td><td class="lnprod"></td></tr>
         <tr><td>Loan Amount:</td><td class="lnamt"></td></tr>
         <tr><td>Created by:</td><td class="lnadm"></td></tr>
         <tr><td>Recommended by:</td><td class="lnrltnoff"></td></tr>
         <tr><td>Approved by:</td><td class="lnrltnmng"></td></tr>
         <tr><td>Disbursed by:</td><td class="lnoff"></td></tr>
        </tbody>
       </table>
      </div>
     </div>
    </div>
   </div>

  </div>
 </div>
</div>
</div>
</section>
<script src="<?php echo $base_url;?>assets/bootstrap/bootstrap.min.js"></script>
<script src="<?php echo $base_url;?>assets/js/dashboard.js"></script>
<script src="<?php echo $base_url;?>assets/js/jquery.dataTables.min.js"></script>
<script src="<?php echo $base_url;?>assets/js/dataTables.bootstrap4.min.js"></script>
<script>
$(function(){
 $("#chapchaploan").attr("class","active");
 $('#tb_chapchaploans').DataTable({"aaSorting":[]});

 $("body").on("click",".details",function(){
  $(".lncust").html($(this).attr("data-cust"));
  $(".lnprod").html($(this).attr("data-prod"));
  $(".lnamt").html($(this).attr("data-amount"));
  $(".lnadm").html($(this).attr("data-offadm"));
  $(".lnrltnoff").html($(this).attr("data-recom"));
  $(".lnrltnmng").html($(this).attr("data-approver"));
  $(".lnoff").html($(this).attr("data-disburser"));
  $(".item2").click();
 });


 //Loan disbursement
 $("body").on("click",".disburse",function(){
  var disburse = $(this).attr("id");
  var d = confirm('The money will be sent to the chapchaploan applicant Name: '+$(this).attr("data-custname")+' M-Pesa number: '+$(this).attr("data-phone")+'. Click "OK" to confirm money disbursement.');
  if(d == false){
   return false;
  }
  else{
    $.ajax({
      method:"post",
      url: $("#portal_url").html()+"app/chapchaploans",
      data:{
        disburse:disburse
      },
      cache:false
    }).done(function(data){
      if(data.status == "200"){
       alert("The money has been sent to the chapchaploan applicant.");
       window.location.replace($("#portal_url").html()+"chapchaploans");
      }
      if(data.status == "301"){
       alert("The M-Pesa bulk payment account has insufficient amount.");
      }
    });
    }
   });
   
   //mark as disbursed
 $("body").on("click",".markasdisbursed",function(){
  var disbursed = $(this).attr("id");
  var d = confirm('Do you want to mark as disbursed? ');
  if(d == false){
   return false;
  }
  else{
    $.ajax({
      method:"post",
      url: $("#portal_url").html()+"app/chapchaploans",
      data:{
        disbursed:disbursed
      },
      cache:false
    }).done(function(data){
      if(data.status == "200"){
       alert("marked as disbursed successfully.");
       window.location.replace($("#portal_url").html()+"chapchaploans");
      }
      if(data.status == "300"){
       alert("error.");
      }
    });
    }
   });
 });
</script>
</body>
</html>