<?php
ob_start();
session_start();
include_once("../config/index.php");
include_once("includes/auth.php");
$now = date('Y-m-d H:i:s');
$branchid = $user["branchId"];
?>
<!DOCTYPE html>
<html lang="en-US">
<head>
<meta charset="UTF-8">
<title>Defaulted Loans | Microfinance</title>
<meta name="viewport" content="width=device-width,initial-scale=1">
<link rel="shortcut icon" href="<?php echo $base_url;?>assets/images/logo/favicon.ico">
<link href="<?php echo $base_url;?>assets/bootstrap/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="<?php echo $base_url;?>assets/css/dataTables.bootstrap4.min.css"/>
<link rel="stylesheet" href="<?php echo $base_url;?>assets/fontawesome/css/all.min.css"> 
<link href="<?php echo $base_url;?>assets/css/dashboard.css" rel="stylesheet">
<script src="<?php echo $base_url;?>assets/js/jquery.min.js"></script>
</head>
<body> 
<?php include_once("includes/header.php");?>
<section id="main">
<div class="container-fluid">
 <div class="row">
   <?php include_once("includes/aside.php");?>
   <div class="content">
    <div class="col-md-12">
     <div class="breadcrumbs row">
      <ul class="breadcrumb">
       <li><i class="fas fa-tachometer-alt"></i>&nbsp;Dashboard</li>
       <li><i class="fas fa-hand-holding-usd"></i> &nbsp;&nbsp;Defaulted Loans</li>
      </ul>
    </div>
    <span class="item item2" data-dismiss="modal" data-toggle="modal" data-target="#loanmodal" style="display: none;"></span>

     <div class="panel panel-default">
       <div class="panel-header dvtitle">Defaulted Loans</div>
       <div class="panel-body">
        <div class="table-responsive row">
        <table id="tb_defaults" class="table table-striped table-bordered" cellspacing="0" width="100%">
         <thead>
           <tr><th>Loan No.</th><th>Amount</th><th>Due Date</th><th>Collection officer</th><th style="min-width: 100px;">Action</th></tr>
          </thead>
           <tbody>
             <?php
             $chkdefaults = mysqli_query($con,"SELECT * FROM loan_applications WHERE defaulted='1' ORDER BY id DESC");
             while($row = mysqli_fetch_assoc($chkdefaults)){  
              if($cust["branchId"] == $branchid){ ?>
             <tr>
              <td><?php echo $row["loanNo"];?></td>
              <td>KES <?php echo number_format($row["amount"]);?></td>
              <td><?php echo date("d/m/Y",strtotime($row["due_date"]));?></td>
              <td>
               <?php
                $colid = $row["collector"];
                $col = mysqli_fetch_assoc(mysqli_query($con,"SELECT * FROM users WHERE id='$colid'"));
                echo $col["first_name"]." ".$col["last_name"];
               ?>
              </td>
              <td>
              <?php if($row["amount_repayable"] > $row[" amt_repaid "]){?>
              <button class="btn btn-xs btn-primary collector" data-toggle="tooltip" data-placement="bottom" title="Assign or change a collection officer" data-id="<?php echo $row["id"];?>" data-collector="<?php echo $row["collector"];?>"><i class="fas fa-list"></i></button>
              <?php } 
               if($row["collector"] != 0){ ?>
              <a href="<?php echo $portal_url."collection/".$row["id"];?>"><button class="btn btn-xs btn-info" data-toggle="tooltip" data-placement="bottom" title="View loan collection details"><i class="fas fa-list"></i></button></a>
              <?php } ?>
              </td>  
             </tr>
             <?php } }
            ?>
         </tbody>
       </table>
      </div>
    </div>
   </div>  

   <div id="loanmodal" class="modal fade" role="dialog">
    <div class="modal-dialog">
     <div class="modal-content">
      <h3><i class="fas fa-hand-holding-usd"></i> Assign a collection officer<span class="close pull-right" data-dismiss="modal"><i class="fas fa-times"></i></span></h3>
      <form role="form" id="collectorfrm">
       <div class="form-group">
       <label>Collection officer <span>*</span></label>
       <input type="hidden" id="id" value="">
       <select class="form-control" id="colid">
       <?php
        $chkcollectors = mysqli_query($con,"SELECT * FROM users");
        while($row = mysqli_fetch_assoc($chkcollectors)){ ?>
        <option value="<?php echo $row["id"];?>"><?php echo $row["first_name"]." ".$row["last_name"];?></option>
       <?php } ?>
       </select>
      </div>
      <div class="form-group" style="border-top: 1px solid #ddd;padding-top: 5px;">
       <button class="btn btn-block" type="submit"> <i class="fa fa-save"></i> Assign Collection Officer</button>
      </div>
      <div class="form-group">
       <div id="status"></div>
      </div>
     </form>
    </div>
   </div>
  </div>
  </div>
 </div>
</div>
</div>
</section>
<script src="<?php echo $base_url;?>assets/bootstrap/bootstrap.min.js"></script>
<script src="<?php echo $base_url;?>assets/js/dashboard.js"></script>
<script src="<?php echo $base_url;?>assets/js/jquery.dataTables.min.js"></script>
<script src="<?php echo $base_url;?>assets/js/dataTables.bootstrap4.min.js"></script>
<script>
$(function(){
 $("#default").attr("class","active");
 $('#tb_defaults').DataTable({"aaSorting":[]});

 $("body").on("click",".details",function(){
  $(".id").html($(this).attr("data-id"));
  $(".colid").html($(this).attr("data-collector"));
  $(".item2").click();
 });

 $("#collectorfrm").submit(function(e){
  e.preventDefault();
  var id = $("#id").val();
  var colid = $("#colid").val();
  $("#status").html("<p class='text-success bg-success'><i class='fa fa-spinner fa-pulse'></i> Assigning the collection officer...</p>"); 
  $.ajax({
    method: "POST",
    url: $("#portal_url").html()+"app/collector",
    data: {
      id:id,
      colid:colid,
    },
    cache:false
  }).done(function(data){
   if(data.status == 200){
    $("#status").html("<p class='alert alert-success'><i class='fa fa-check'></i> Collection officer assigned successfully.</p>").delay(5000);
     window.location.replace($("#portal_url").html()+"defaulted");
   }
   if(data.status == 403){
    $("#status").html("<p class='alert alert-danger'><i class='fa fa-exclamation-circle'></i> You are not allowed to perform this role.</p>");
   }
   if(data.status == 300){
    $("#status").html("<p class='alert alert-danger'><i class='fa fa-exclamation-circle'></i> An error occured, please try again later.</p>");
   }
  });
 });

 });
</script>
</body>
</html>