<?php
ob_start();
session_start();
include_once("../config/index.php");
include_once("includes/auth.php");
$now = date('Y-m-d H:i:s');
?>
<!DOCTYPE html>
<html lang="en-US">
<head>
<meta charset="UTF-8">
<title>Disbursed | Kuza Fine Africa</title>
<meta name="viewport" content="width=device-width,initial-scale=1">
<link rel="shortcut icon" href="<?php echo $base_url;?>assets/images/logo/favicon.ico">
<link href="<?php echo $base_url;?>assets/bootstrap/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="<?php echo $base_url;?>assets/css/dataTables.bootstrap4.min.css"/>
<link rel="stylesheet" href="<?php echo $base_url;?>assets/fontawesome/css/all.min.css"> 
<link href="<?php echo $base_url;?>assets/css/dashboard.css" rel="stylesheet">
<script src="<?php echo $base_url;?>assets/js/jquery.min.js"></script>
<style>
.modal-dialog{
  width: 500px!important;
}
</style>
</head>
<body> 
<?php include_once("includes/header.php");?>
<section id="main">
<div class="container-fluid">
 <div class="row">
   <?php include_once("includes/aside.php");?>
   <div class="content">
    <div class="col-md-12">
     <div class="breadcrumbs row">
      <ul class="breadcrumb">
       <li><i class="fas fa-tachometer-alt"></i>&nbsp;Dashboard</li>
       <li><i class="fas fa-file-invoice"></i> &nbsp;&nbsp;Disbursed</li>
      </ul>
    </div>

     <div class="panel panel-default">
       <div class="panel-header dvtitle">Disbursed</div>
       <div class="panel-body">
        <div class="table-responsive row">
        <table id="tb_repymt" class="table table-striped table-bordered" cellspacing="0" width="100%">
         <thead>
           <tr><th>Recipient Name</th><th>Phone</th><th>Amount</th><th>Txn Code</th><th>Disbursement Date</th></tr>
          </thead>
           <tbody>
             <?php
             $chkrepayments = mysqli_query($con,"SELECT * FROM mpesab2c ORDER BY id DESC");
             while($row = mysqli_fetch_assoc($chkrepayments)){  ?>
             <tr>
              <td><?php echo $row["name"];?></td>
              <td><?php echo $row["phone"];?></td>
              <td>Ksh. <?php echo $row["amount"];?></td>
              <td><?php echo $row["txncode"];?></td>
              <td><?php echo date("d/m/Y H:i", strtotime($row["transtime"]));?></td>
             </tr>
            <?php } ?>
         </tbody>
       </table>
      </div>
    </div>
   </div>
  

  </div>
 </div>
</div>
</div>
</section>
<script src="<?php echo $base_url;?>assets/bootstrap/bootstrap.min.js"></script>
<script src="<?php echo $base_url;?>assets/js/dashboard.js"></script>
<script src="<?php echo $base_url;?>assets/js/jquery.dataTables.min.js"></script>
<script src="<?php echo $base_url;?>assets/js/dataTables.bootstrap4.min.js"></script>
<script>
$(function(){
 $("#dis").attr("class","active");
 $('#tb_repymt').DataTable({"aaSorting":[]});

 $("#repaymtfrm").submit(function(e){
  e.preventDefault();
  var loanno = $("#loanno").val();
  var mpesacode = $("#mpesacode").val();
  
  $("#status").html("<p class='text-success bg-success'><i class='fa fa-spinner fa-pulse'></i> Saving the customer details...</p>"); 
  $.ajax({
    method: "POST",
    url: $("#portal_url").html()+"app/loan-repayments",
    data: {
      loanno:loanno,
      mpesacode:mpesacode
    },
    cache:false
  }).done(function(data){
   if(data.status == 200){
    $("#status").html("<p class='alert alert-success'><i class='fa fa-check'></i> Payment updated successfully.</p>").delay(5000);
     window.location.replace($("#portal_url").html()+"loan-repayments");
   }
   if(data.status == 401){
    $("#status").html("<p class='alert alert-danger'><i class='fa fa-exclamation-circle'></i> Invalid mpesa code. Please check and confirm.</p>");
   }
   if(data.status == 402){
    $("#status").html("<p class='alert alert-danger'><i class='fa fa-exclamation-circle'></i> M-Pesa code already used for another repayment.</p>");
   }
   if(data.status == 403){
    $("#status").html("<p class='alert alert-danger'><i class='fa fa-exclamation-circle'></i> Invalid loanNo. Please check and confirm.</p>");
   }
   if(data.status == 300){
    $("#status").html("<p class='alert alert-danger'><i class='fa fa-exclamation-circle'></i> An error occured, please try again later.</p>");
   }
  });
 });
 });
</script>
</body>
</html>