<?php
ob_start();
session_start();
include_once("../config/index.php");
include_once("includes/auth.php");
$now = date('Y-m-d H:i:s');
?>
<!DOCTYPE html>
<html lang="en-US">
<head>
<meta charset="UTF-8">
<title>Loan Repayments | Kuza Work Africa</title>
<meta name="viewport" content="width=device-width,initial-scale=1">
<link rel="shortcut icon" href="<?php echo $base_url;?>assets/images/logo/favicon.ico">
<link href="<?php echo $base_url;?>assets/bootstrap/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="<?php echo $base_url;?>assets/css/dataTables.bootstrap4.min.css"/>
<link rel="stylesheet" href="<?php echo $base_url;?>assets/fontawesome/css/all.min.css"> 
<link href="<?php echo $base_url;?>assets/css/dashboard.css" rel="stylesheet">
<script src="<?php echo $base_url;?>assets/js/jquery.min.js"></script>
<style>
.modal-dialog{
  width: 500px!important;
}
</style>
</head>
<body> 
<?php include_once("includes/header.php");?>
<section id="main">
<div class="container-fluid">
 <div class="row">
   <?php include_once("includes/aside.php");?>
   <div class="content">
    <div class="col-md-12">
     <div class="breadcrumbs row">
      <ul class="breadcrumb">
       <li><i class="fas fa-tachometer-alt"></i>&nbsp;Dashboard</li>
       <li><i class="fas fa-file-invoice"></i> &nbsp;&nbsp;Loan Repayments</li>
      </ul>
    </div>

    <div class="row wrapper">
      <button class="btn item item1" data-dismiss="modal" data-toggle="modal" data-target="#paymtmodal"><i class="fa fa-plus"></i> Manual Repayment Update</button>
      <button class="btn item item1" data-dismiss="modal" data-toggle="modal" data-target="#paymtrmodal"><i class="fa fa-plus"></i> Manual Receipt Update</button>
      <button class="btn item item1" data-dismiss="modal" data-toggle="modal" data-target="#undoposmodal"><i class="fa fa-plus"></i> Undo POS Payment</button>
    </div>

     <div class="panel panel-default">
       <div class="panel-header dvtitle">Loan Repayments</div>
       <div class="panel-body">
        <div class="table-responsive row">
        <table id="tb_repymt" class="table table-striped table-bordered" cellspacing="0" width="100%">
         <thead>
           <tr><th>Loan No.</th><th>Customer</th><th>Amount</th><th>Payment Mode</th><th>Txn Code</th><th>Payment Date</th><th>Reason</th></tr>
          </thead>
           <tbody>
             <?php
             $chkrepayments = mysqli_query($con,"SELECT loan_repayments.* FROM loan_repayments,loan_applications,users WHERE loan_repayments.loanId=loan_applications.id AND loan_applications.userId=users.id AND users.branchId='$branchid' ORDER BY loan_repayments.id DESC LIMIT 1000");
             while($row = mysqli_fetch_assoc($chkrepayments)){  ?>
             <tr>
              <td>
               <?php
                $loanid = $row["loanId"];
                $loan = mysqli_fetch_assoc(mysqli_query($con,"SELECT * FROM loan_applications WHERE id='$loanid'"));
                echo $loan["loanNo"];
               ?>
              </td>
              <td>
               <?php
                $custid = $loan["custId"];
                $cust = mysqli_fetch_assoc(mysqli_query($con,"SELECT * FROM customers WHERE id='$custid'"));
                echo $cust["first_name"]." ".$cust["middle_name"]." ".$cust["last_name"];
               ?>
              </td>
              <td><?php echo $row["amount"];?></td>
              <td><?php echo $row["paymode"];?></td>
              <td><?php echo $row["txncode"];?></td>
              <td><?php echo date("d/m/Y H:i", strtotime($row["created_at"]));?></td>
              <td><?php echo $row["reason"];?></td>
             </tr>
            <?php } ?>
         </tbody>
       </table>
      </div>
    </div>
   </div>
  

<div id="paymtmodal" class="modal fade" role="dialog">
 <div class="modal-dialog">
  <div class="modal-content">
   <h3><i class="fas fa-file-invoice"></i> Update Loan Repayment<span class="close pull-right" data-dismiss="modal"><i class="fas fa-times"></i></span></h3>
   <form role="form" id="repaymtfrm">
    <div class="col-md-6">
     <div class="form-group">
      <label>Loan Number <span>*</span></label>
      <input type="text" class="form-control" id="loanno" minlength="5" maxlength="5" required>
     </div>
    </div>
    <div class="col-md-6">
     <div class="form-group">
      <label>M-Pesa Code <span>*</span></label>
      <input type="text" class="form-control" id="mpesacode" minlength="10" maxlength="10" required>
     </div>
    </div>
    <div class="form-group" style="border-top: 1px solid #ddd;padding-top: 5px;">
      <button class="btn btn-block" type="submit"> <i class="fa fa-save"></i> Update Repayment</button>
    </div>
    <div class="form-group">
     <div id="status"></div>
    </div>
   </form>
  </div>
 </div>
</div>

<!--receippt modal-->
<div id="paymtrmodal" class="modal fade" role="dialog">
 <div class="modal-dialog">
  <div class="modal-content">
   <h3><i class="fas fa-file-invoice"></i> Update Loan Repayment<span class="close pull-right" data-dismiss="modal"><i class="fas fa-times"></i></span></h3>
   <form role="form" id="repaymtrfrm">
    <div class="col-md-6">
     <div class="form-group">
      <label>Loan Number <span>*</span></label>
      <input type="text" class="form-control" id="loanno1" minlength="5" maxlength="5" required>
     </div>
    </div>
    <div class="col-md-6">
     <div class="form-group">
      <label>Receipt Number <span>*</span></label>
      <input type="text" class="form-control" id="receiptno" minlength="1" maxlength="50" required>
     </div>
    </div>
    <div class="col-md-6">
     <div class="form-group">
      <label>Amount <span>*</span></label>
      <input type="text" class="form-control" id="amount" minlength="1" maxlength="10" required>
     </div>
    </div>
    <div class="col-md-6">
     <div class="form-group">
      <label>Date of payment <span>*</span></label>
      <input type="date" class="form-control" id="datepaid" required>
     </div>
    </div>
    <div class="form-group" style="border-top: 1px solid #ddd;padding-top: 5px;">
      <button class="btn btn-block" type="submit"> <i class="fa fa-save"></i> Update Repayment</button>
    </div>
    <div class="form-group">
     <div id="status1"></div>
    </div>
   </form>
  </div>
 </div>
</div>

<!--undo pos modal-->
<div id="undoposmodal" class="modal fade" role="dialog">
 <div class="modal-dialog">
  <div class="modal-content">
   <h3><i class="fas fa-file-invoice"></i> Undo POS Payment<span class="close pull-right" data-dismiss="modal"><i class="fas fa-times"></i></span></h3>
   <form role="form" id="undoposfrm">
    <div class="col-md-6">
     <div class="form-group">
      <label>Loan Number <span>*</span></label>
      <input type="text" class="form-control" id="loanno2" minlength="5" maxlength="5" required>
     </div>
    </div>
    <div class="col-md-6">
     <div class="form-group">
      <label>Txn Code <span>*</span></label>
      <input type="text" class="form-control" id="receiptno2" minlength="1" maxlength="50" required>
     </div>
    </div>
    <div class="col-md-6">
     <div class="form-group">
      <label>Amount <span>*</span></label>
      <input type="text" class="form-control" id="amount2" minlength="1" maxlength="10" required>
     </div>
    </div>
    <div class="col-md-6">
     <div class="form-group">
      <label>Date of payment <span>*</span></label>
      <input type="date" class="form-control" id="datepaid2" required>
     </div>
    </div>
    <div class="col-md-6">
     <div class="form-group">
      <label>Reason <span>*</span></label>
      <input type="text" class="form-control" id="reason2" required>
     </div>
    </div>
    <div class="form-group" style="border-top: 1px solid #ddd;padding-top: 5px;">
      <button class="btn btn-block" type="submit"> <i class="fa fa-save"></i> Undo Repayment</button>
    </div>
    <div class="form-group">
     <div id="status2"></div>
    </div>
   </form>
  </div>
 </div>
</div>

  </div>
 </div>
</div>
</div>
</section>
<script src="<?php echo $base_url;?>assets/bootstrap/bootstrap.min.js"></script>
<script src="<?php echo $base_url;?>assets/js/dashboard.js"></script>
<script src="<?php echo $base_url;?>assets/js/jquery.dataTables.min.js"></script>
<script src="<?php echo $base_url;?>assets/js/dataTables.bootstrap4.min.js"></script>
<script>
$(function(){
 $("#repymt").attr("class","active");
 $('#tb_repymt').DataTable({"aaSorting":[]});

 $("#repaymtfrm").submit(function(e){
  e.preventDefault();
  var loanno = $("#loanno").val();
  var mpesacode = $("#mpesacode").val();
  
  $("#status").html("<p class='text-success bg-success'><i class='fa fa-spinner fa-pulse'></i> Saving the customer details...</p>"); 
  $.ajax({
    method: "POST",
    url: $("#portal_url").html()+"app/loan-repayments",
    data: {
      loanno:loanno,
      mpesacode:mpesacode
    },
    cache:false
  }).done(function(data){
   if(data.status == 200){
    $("#status").html("<p class='alert alert-success'><i class='fa fa-check'></i> Payment updated successfully.</p>").delay(5000);
     window.location.replace($("#portal_url").html()+"loan-repayments");
   }
   if(data.status == 401){
    $("#status").html("<p class='alert alert-danger'><i class='fa fa-exclamation-circle'></i> Invalid mpesa code. Please check and confirm.</p>");
   }
   if(data.status == 402){
    $("#status").html("<p class='alert alert-danger'><i class='fa fa-exclamation-circle'></i> M-Pesa code already used for another repayment.</p>");
   }
   if(data.status == 403){
    $("#status").html("<p class='alert alert-danger'><i class='fa fa-exclamation-circle'></i> Invalid loanNo. Please check and confirm.</p>");
   }
   if(data.status == 300){
    $("#status").html("<p class='alert alert-danger'><i class='fa fa-exclamation-circle'></i> An error occured, please try again later.</p>");
   }
  });
 });
 
  $("#repaymtrfrm").submit(function(e){
  e.preventDefault();
  var loanno1 = $("#loanno1").val();
  var receiptno = $("#receiptno").val();
  var amount = $("#amount").val();
  var datepaid = $("#datepaid").val();
  
  $("#status1").html("<p class='text-success bg-success'><i class='fa fa-spinner fa-pulse'></i> Saving the customer details...</p>"); 
  $.ajax({
    method: "POST",
    url: $("#portal_url").html()+"app/loan-repayments",
    data: {
      loanno1:loanno1,
      receiptno:receiptno,
      amount:amount,
      datepaid:datepaid
      
    },
    cache:false
  }).done(function(data){
   if(data.status == 200){
    $("#status1").html("<p class='alert alert-success'><i class='fa fa-check'></i> Payment updated successfully.</p>").delay(5000);
     window.location.replace($("#portal_url").html()+"loan-repayments");
   }
   if(data.status == 401){
    $("#status1").html("<p class='alert alert-danger'><i class='fa fa-exclamation-circle'></i> Invalid receipt number. Please check and confirm.</p>");
   }
   if(data.status == 402){
    $("#status1").html("<p class='alert alert-danger'><i class='fa fa-exclamation-circle'></i> receipt already used for another repayment.</p>");
   }
   if(data.status == 403){
    $("#status1").html("<p class='alert alert-danger'><i class='fa fa-exclamation-circle'></i> Invalid loanNo. Please check and confirm.</p>");
   }
   if(data.status == 300){
    $("#status1").html("<p class='alert alert-danger'><i class='fa fa-exclamation-circle'></i> An error occured, please try again later.</p>");
   }
  });
 });
 
 $("#undoposfrm").submit(function(e){
  e.preventDefault();
  var loanno2 = $("#loanno2").val();
  var receiptno2 = $("#receiptno2").val();
  var amount2 = $("#amount2").val();
  var datepaid2 = $("#datepaid2").val();
  var reason2 = $("#reason2").val();
  
  $("#status2").html("<p class='text-success bg-success'><i class='fa fa-spinner fa-pulse'></i> sending request...</p>"); 
  $.ajax({
    method: "POST",
    url: $("#portal_url").html()+"app/loan-repayments",
    data: {
      loanno2:loanno2,
      receiptno2:receiptno2,
      amount2:amount2,
      datepaid2:datepaid2,
      reason2:reason2
      
    },
    cache:false
  }).done(function(data){
   if(data.status == 200){
    $("#status2").html("<p class='alert alert-success'><i class='fa fa-check'></i> Payment updated successfully.</p>").delay(5000);
     window.location.replace($("#portal_url").html()+"loan-repayments");
   }
   if(data.status == 401){
    $("#status2").html("<p class='alert alert-danger'><i class='fa fa-exclamation-circle'></i> Invalid receipt number. Please check and confirm.</p>");
   }
   if(data.status == 402){
    $("#status2").html("<p class='alert alert-danger'><i class='fa fa-exclamation-circle'></i> receipt already used for another repayment.</p>");
   }
   if(data.status == 403){
    $("#status2").html("<p class='alert alert-danger'><i class='fa fa-exclamation-circle'></i> Invalid loanNo. Please check and confirm.</p>");
   }
   if(data.status == 300){
    $("#status2").html("<p class='alert alert-danger'><i class='fa fa-exclamation-circle'></i> An error occured, please try again later.</p>");
   }
  });
 });
 });
</script>
</body>
</html>