<?php
include_once("config/index.php");
?>
<!DOCTYPE html>
<html lang="en-US">
<head>
<meta charset="UTF-8">
<title>Forgot Password | Microfinance</title>
<meta name="viewport" content="width=device-width,initial-scale=1">
<link rel="shortcut icon" href="<?php echo $base_url;?>assets/images/logo/favicon.ico">
<link rel="stylesheet" href="<?php echo $base_url;?>assets/bootstrap/bootstrap.min.css">
<link rel="stylesheet" href="<?php echo $base_url;?>assets/fontawesome/css/all.min.css">
<link rel="stylesheet" href="<?php echo $base_url;?>assets/css/dashboard.css">
<style>
  body{
    background: #eee;
  }
</style>
</head>
<body>
<p id="base_url" style="display: none;"><?php echo $base_url;?></p>
<div class="container">
 <div class="col-md-4 col-md-offset-4" id="loginwrapper">
  <img src="<?php echo $base_url;?>assets/images/logo/logo.png">
  <form role="form" id="resetfrm">
   <h2>Password Recovery</h2>
   <div class="form-group">
    <input type="email" class="form-control" id="email" placeholder="Your Email" required>
    <div id="email_error"></div>
   </div>
   <div class="form-group">
    <button type="submit" class="btn btn-block">Reset my Password</button>
   </div>
   <div class="form-group">
    <hr>
    <span class="or">or</span>
   </div>
   <div class="form-group lnkbtn">
    <a href="<?php echo $base_url;?>">
     <button class="btn btn-block" type="button"><i class="fa fa-angle-double-left"></i> Back to Login</button>
    </a>
   </div>
   <div class="form-group">
    <div id="status"></div>
   </div>
  </form>
 </div>
</div>
<script src="<?php echo $base_url;?>assets/js/jquery.min.js"></script>
<script src="<?php echo $base_url;?>assets/bootstrap/bootstrap.min.js"></script>
<script>
$(function() {
/*==========Forgot Password=============*/
$("#resetfrm").submit(function(e){
 e.preventDefault();
 var email = $("#email").val();
 if(/^\w+([\.-]?\w+)*@\w+([\.-]?\w+)*(\.\w{2,10})+$/.test(email)){
  $("#status").html("<p class='alert alert-success'><i class='fa fa-spinner fa-pulse'></i> Sending you a reset link...</p>");
  $.ajax({
     method: "POST",
     url : $("#base_url").html()+"app/resetlnk",
     data: {email:email}
     }).done(function (data){
     if(data.status == 200){
       $("#status").html("<p class='alert alert-success'><i class='fa fa-check'></i> A reset link has been sent to you via email. Kindly check to continue</p>");
     }
     else if(data.message == "ERROR"){
      $("#status").html("<p class='alert alert-danger'><i class='fa fa-exclamation-circle'></i> An error occured, please try again</p>");
     }
     else if(data.message == "NON_EXISTENT"){
      $("#status").html("<p class='alert alert-danger'><i class='fa fa-exclamation-circle'></i> No user with that email exist. Please confirm & try again.</p>");
     }
     else if(data.message == "BLOCKED"){
      $("#status").html("<p class='alert alert-danger'><i class='fa fa-exclamation-circle'></i> Your account was deactivated. Please contact the admin for more details.</p>");
     }
     else{
       $("#status").html("<p class='alert alert-danger'><i class='fa fa-exclamation-circle'></i> An error occured, please try again</p>").fadeIn("slow");
     }
    });
  }
  else{
    $("#status").html("<p class='alert alert-danger'><i class='fa fa-exclamation-circle'></i> Use a valid email address.</p>");
   }
 });
});
</script>
</body>
</html>
