<?php
include("../config/index.php");

header("Content-Type: application/json");

// Get the incoming JSON payload
$request = file_get_contents('php://input');
$array = json_decode($request, true);

// Current timestamp
$now = date("Y-m-d H:i:s");

// --- Extract main fields ---
$status = $array["Result"]["ResultCode"];
$mpesacode = $array["Result"]["TransactionID"];
$resultParams = $array["Result"]["ResultParameters"]["ResultParameter"];

// Initialize variables
$amount = 0;
$transtime = '';
$receiverName = '';
$billRefNumber = '';

// --- Extract key/value pairs properly ---
foreach ($resultParams as $param) {
    switch ($param["Key"]) {
        case "Amount":
            $amount = $param["Value"];
            break;
        case "TransCompletedTime":
            $transRaw = $param["Value"]; // e.g. 20251009143951
            $transtime = DateTime::createFromFormat('YmdHis', $transRaw)->format('Y-m-d H:i:s');
            break;
        case "ReceiverPartyPublicName":
            $receiverName = trim($param["Value"]);
            break;
    }
}

// --- Extract reference data (like BillReferenceNumber) ---
if (isset($array["Result"]["ReferenceData"]["ReferenceItem"])) {
    foreach ($array["Result"]["ReferenceData"]["ReferenceItem"] as $refItem) {
        if ($refItem["Key"] === "BillReferenceNumber") {
            $billRefNumber = trim($refItem["Value"]);
        }
    }
}

// Optional: parse phone from BillReferenceNumber or receiver name if needed
$phone = $billRefNumber; // e.g. 0713083924
$name = $receiverName;

// --- Prevent duplicate transactions ---
$check = mysqli_query($con, "SELECT * FROM mpesab2c WHERE txncode='$mpesacode'");
if (mysqli_num_rows($check) < 1) {
    $stmt = $con->prepare("INSERT INTO mpesab2c (payload, txncode, transtime, amount, phone, name, created_at) VALUES (?, ?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("sssssss", $request, $mpesacode, $transtime, $amount, $phone, $name, $now);
    $stmt->execute();
    $stmt->close();
}

echo json_encode(["status" => "success", "txncode" => $mpesacode]);
?>
