<?php
ob_start();
session_start();
include_once("../config/index.php");
include_once("includes/auth.php");
$now = date('Y-m-d H:i:s');
$branchid = $user["branchId"];
?>
<!DOCTYPE html>
<html lang="en-US">
<head>
<meta charset="UTF-8">
<title>Chap Chap Loan Applications | Kuza Work Africa</title>
<meta name="viewport" content="width=device-width,initial-scale=1">
<link rel="shortcut icon" href="<?php echo $base_url;?>assets/images/logo/favicon.ico">
<link href="<?php echo $base_url;?>assets/bootstrap/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="<?php echo $base_url;?>assets/css/dataTables.bootstrap4.min.css"/>
<link rel="stylesheet" href="<?php echo $base_url;?>assets/fontawesome/css/all.min.css"> 
<link href="<?php echo $base_url;?>assets/css/dashboard.css" rel="stylesheet">
<script src="<?php echo $base_url;?>assets/js/jquery.min.js"></script>
<style>
.modal-dialog{
  max-width: 800px !important;
}
.modal-dialog .col-md-6{
  padding: 2px;
}
form{
  padding-left: 5px;
  padding-right: 10px;
}
#chapchaploanfrm p{
  padding-left: 5px;
}
.custinfo,.bsinfo{
  border-bottom: 1px dashed #ddd;
  padding: 0;
  color: #c1c100;
}
.bsinfo{
  margin-top: 20px;
}
#chapchaploanmodal td{
  padding: 0!important;
  max-width: 200px;
  border-right: 1px solid #ddd;
}
#chapchaploanmodal td input{
  border: none;
  box-shadow: none;
  width: 100%;
}
</style>
</head>
<body> 
<?php include_once("includes/header.php");?>
<section id="main">
<div class="container-fluid">
 <div class="row">
   <?php include_once("includes/aside.php");?>
   <div class="content">
    <div class="col-md-12">
     <div class="breadcrumbs row">
      <ul class="breadcrumb">
       <li><i class="fas fa-tachometer-alt"></i>&nbsp;Dashboard</li>
       <li><i class="fas fa-hand-holding-usd"></i> &nbsp;&nbsp;Chap Chap Loan Applications</li>
      </ul>
    </div>

    <div class="row wrapper">
      <button class="btn item item1" data-dismiss="modal" data-toggle="modal" data-target="#chapchaploanmodal"><i class="fa fa-plus"></i> New chapchaploan application</button>
      <span class="item item2" data-dismiss="modal" data-toggle="modal" data-target="#chapchaploanmodal" style="display: none;"></span>
    </div>

     <div class="panel panel-default">
       <div class="panel-header dvtitle">Chap Chap Loan Applications</div>
       <div class="panel-body">
        <div class="table-responsive row">
        <table id="tb_chapchaploans" class="table table-striped table-bordered" cellspacing="0" width="100%">
         <thead>
           <tr><th>Loan No.</th><th>Customer</th><th>Loan Product</th><th>Sequence</th><th>Amount</th><th>Repayable</th><th>Date</th><th>Status</th><th style="min-width: 100px;">Action</th></tr>
          </thead>
           <tbody>
             <?php
            $chkchapchaploans = mysqli_query($con,"SELECT chapchaploan_applications.* FROM chapchaploan_applications,users WHERE chapchaploan_applications.userId=users.id AND users.branchId='$branchid' ORDER BY chapchaploan_applications.id DESC");
             while($row = mysqli_fetch_assoc($chkchapchaploans)){
              echo $custid = $row["custId"];
              $cust = mysqli_fetch_assoc(mysqli_query($con,"SELECT * FROM customers WHERE id='$custid'"));
              $chapchaploanid = $row["id"];
             if($cust["branchId"] == $branchid){
             ?>
             <tr>
              <td><?php echo $row["chapchaploanNo"];?></td>
              <td>
               <?php
                echo $cust["first_name"]." ".$cust["last_name"]." (".$cust["custNo"].")";
               ?>
              </td>
              <td>
               <?php
                $prodid = $row["prodId"];
                $prod = mysqli_fetch_assoc(mysqli_query($con,"SELECT * FROM loan_products WHERE id='$prodid'"));
                echo $prod["name"];
               ?>
              </td>
              <td>
               <?php
                $seqid = $row["seqId"];
                $seq = mysqli_fetch_assoc(mysqli_query($con,"SELECT * FROM loan_sequence WHERE id='$seqid'"));
                echo $seq["name"];
               ?>
              </td>
              <td>KES <?php echo number_format($row["amount"]);?></td>
              <td>KES <?php echo number_format($row["amount_repayable"]);?></td>
              <td><?php echo date("d M Y",strtotime($row["created_at"]));?></td>
              <td>
               <?php
               if($row["userId"] == 0){ ?>
                <span class="btn btn-xs btn-info">New</span>
               <?php }
               else{ 
               if($row["status"] == 0){ ?>
                <span class="btn btn-xs btn-warning">Pending</span>
               <?php }
               if($row["status"] == 2){ ?>
                <span class="btn btn-xs btn-info">Approved</span>
               <?php }
               if($row["status"] == 3){ ?>
                <span class="btn btn-xs btn-danger">Rejected</span>
               <?php }
               if($row["status"] == 4){ ?>
                <span class="btn btn-xs btn-success">Disbursed</span>
               <?php } 
                }
               ?>
              </td>
              <td>
              <a style="display:none" href="<?php echo $portal_url;?>chapchaploan/<?php echo $row["chapchaploanNo"];?>"><button class="btn btn-xs btn-success" data-toggle="tooltip" data-placement="bottom" title="View chapchaploan details"><i class="fas fa-search-plus"></i></button></a>
              <?php if($row["recommended_by"] == 0){ ?>
               <button class="btn btn-xs btn-primary edtchapchaploan" data-toggle="tooltip" data-placement="bottom" title="Edit chapchaploan application" data-id="<?php echo $row["id"];?>" data-custid="<?php echo $row["custId"];?>" data-prodid="<?php echo $row["prodId"];?>" data-seqid="<?php echo $row["seqId"];?>" data-amount="<?php echo $row["amount"];?>" data-phone="<?php echo $row["mpesaNo"];?>" data-purpose="<?php echo $row["chapchaploan_purpose"];?>"><i class="fas fa-pencil-alt"></i></button>
               <button class="btn btn-xs btn-danger delchapchaploan" id="<?php echo $row["id"];?>" data-toggle="tooltip" data-placement="bottom" title="Delete chapchaploan application"><i class="fa fa-trash"></i></button>
              <?php } ?>
              </td>  
             </tr>
             <?php } }
            ?>
         </tbody>
       </table>
      </div>
    </div>
   </div>
  

<div id="chapchaploanmodal" class="modal fade" role="dialog">
 <div class="modal-dialog">
  <div class="modal-content">
   <h3><i class="fas fa-users"></i> Chap Chap Loan Application Form<span class="close pull-right" data-dismiss="modal"><i class="fas fa-times"></i></span></h3>
   <form role="form" id="chapchaploanfrm">
   <p>Fill in chapchaploan details. All fields marked with <span style="color: #ff0000">*</span> are mandatory.</p> 
    <div class="col-md-12 custinfo">
     <h4>Chap Chap Loan Particulars</h4>
    </div>
    <div class="col-md-6">
     <div class="form-group">
      <label>Customer <span>*</span></label>
      <input type="hidden" id="id" value="">
      <select class="form-control" id="custid" onchange="custPhone()">
      <?php
       $chkcustomers = mysqli_query($con,"SELECT * FROM customers WHERE status='1' AND id NOT IN(SELECT custId FROM chapchaploan_applications WHERE amount_repayable>amt_repaid AND status!='3') ORDER BY first_name ASC");
       while($row = mysqli_fetch_assoc($chkcustomers)){ ?>
        <option value="<?php echo $row["id"];?>" data-mpesano="<?php echo $row["phone"];?>"><?php echo $row["first_name"]." ".$row["middle_name"]." ".$row["last_name"]."(".$row["custNo"].")";?></option>
      <?php } ?>
      </select>
     </div>
    </div>
    <div class="col-md-6">
     <div class="form-group">
      <label>Chap Chap Loan product <span>*</span></label>
      <select class="form-control" id="prodid" onchange="chapchaploanProduct()">
      <?php
       $chkproducts = mysqli_query($con,"SELECT * FROM loan_products WHERE id='11' ORDER BY name ASC");
       while($row = mysqli_fetch_assoc($chkproducts)){ ?>
        <option value="<?php echo $row["id"];?>" data-maxvalue="<?php echo $row["maxamount"];?>"><?php echo $row["name"];?></option>
      <?php } ?>
      </select>
     </div>
    </div>
    <div class="col-md-6">
     <div class="form-group">
      <label>Chap Chap Loan Sequence <span>*</span></label>
      <select class="form-control" id="seqid">
      <?php
       $chksequence = mysqli_query($con,"SELECT * FROM loan_sequence");
       while($row = mysqli_fetch_assoc($chksequence)){ ?>
        <option value="<?php echo $row["id"];?>"><?php echo $row["name"];?></option>
      <?php } ?>
      </select>
     </div>
    </div>
    <div class="col-md-6">
     <div class="form-group">
      <label>Chap Chap Loan Amount <span>*</span></label>
      <input type="number" class="form-control" id="amount" min="500" required>
     </div>
    </div>
    <div class="col-md-6">
     <div class="form-group">
      <label>Mpesa Number <span>*</span></label>
      <input type="text" class="form-control" id="phone" required>
     </div>
    </div>
    <div class="col-md-6">
     <div class="form-group">
      <label>Purpose of Chap Chap Loan <span>*</span></label>
      <input type="text" class="form-control" id="purpose" required>
     </div>
    </div>

    <div class="form-group" style="border-top: 1px solid #ddd;padding-top: 5px;">
      <button class="btn btn-block" type="submit"> <i class="fa fa-save"></i> Submit Application</button>
    </div>
    <div class="form-group">
     <div id="status"></div>
    </div>
   </form>
  </div>
 </div>
</div>

  </div>
 </div>
</div>
</div>
</section>
<script src="<?php echo $base_url;?>assets/bootstrap/bootstrap.min.js"></script>
<script src="<?php echo $base_url;?>assets/js/dashboard.js"></script>
<script src="<?php echo $base_url;?>assets/js/jquery.dataTables.min.js"></script>
<script src="<?php echo $base_url;?>assets/js/dataTables.bootstrap4.min.js"></script>
<script>
$("#prodid").change(function () {
     var maxvalue=$(this).find(':selected').data('maxvalue');
     $("#amount").attr("max",maxvalue);
});
$("#custid").change(function () {
     var mpesano=$(this).find(':selected').data('mpesano');
     $("#phone").val(mpesano);
});
$(function(){
 $("#chapchaploan").attr("class","active");
 $('#tb_chapchaploans').DataTable({"aaSorting":[]});

 $("body").on("click",".edtchapchaploan",function(){
  $("#id").val($(this).attr("data-id"));
  $("#custid").val($(this).attr("data-custid"));
  $("#prodid").val($(this).attr("data-prodid"));
  $("#seqid").val($(this).attr("data-seqid"));
  $("#amount").val($(this).attr("data-amount"));
  $("#phone").val($(this).attr("data-phone"));
  $("#purpose").val($(this).attr("data-purpose"));
  $("#status").html("");
  $(".item2").click();
 });

 $("#chapchaploanfrm").submit(function(e){
  e.preventDefault();
  var id = $("#id").val();
  var custid = $("#custid").val();
  var prodid = $("#prodid").val();
  var seqid = $("#seqid").val();
  var amount = $("#amount").val();
  var phone = $("#phone").val();
  var purpose = $("#purpose").val();
  $("#status").html("<p class='text-success bg-success'><i class='fa fa-spinner fa-pulse'></i> Saving the chapchaploan details...</p>"); 
  $.ajax({
    method: "POST",
    url: "app/chapchaploans",
    data: {
      id:id,
      custid:custid,
      prodid:prodid,
      seqid:seqid,
      amount:amount,
      phone:phone,
      purpose:purpose
    },
    cache:false
  }).done(function(data){
   if(data.status == 200){
    $("#status").html("<p class='alert alert-success'><i class='fa fa-check'></i> chapchaploan saved successfully.</p>").delay(5000);
     window.location.replace($("#portal_url").html()+"chapchaploans");
   }
   if(data.status == 403){
    $("#status").html("<p class='alert alert-danger'><i class='fa fa-exclamation-circle'></i> You are not allowed to register chapchaploans.</p>");
   }
   if(data.status == 300){
    $("#status").html("<p class='alert alert-danger'><i class='fa fa-exclamation-circle'></i> An error occured, please try again later.</p>");
   }
   if(data.status == 401){
    $("#status").html("<p class='alert alert-danger'><i class='fa fa-exclamation-circle'></i> The customer has an existing chapchaploan that is not fully paid.</p>");
   }
  });
 });

 //Deleting a chapchaploan
 $(".delchapchaploan").click(function(){
  var delchapchaploan = $(this).attr("id");
  var d = confirm('Are you sure you want to delete this chapchaploan application?');
  if(d == false){
   return false;
  }
  else{
    $.ajax({
      method:"post",
      url: $("#portal_url").html()+"app/chapchaploans",
      data:{
        delchapchaploan:delchapchaploan
      },
      cache:false
    }).done(function(data){
      if(data.status == "200"){
       window.location.replace($("#portal_url").html()+"chapchaploans");
      }
    });
    }
   });
 });
</script>
</body>
<?php mysqli_close($con) ?>
</html>