<?php
ob_start();
session_start();
include_once("../config/index.php");
include_once("includes/auth.php");
$now = date('Y-m-d H:i:s');
$branchid = $user["branchId"];
?>
<!DOCTYPE html>
<html lang="en-US">
<head>
<meta charset="UTF-8">
<title>Customers | Kuza Work Africa</title>
<meta name="viewport" content="width=device-width,initial-scale=1">
<link rel="shortcut icon" href="<?php echo $base_url;?>assets/images/logo/favicon.ico">
<link href="<?php echo $base_url;?>assets/bootstrap/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="<?php echo $base_url;?>assets/css/dataTables.bootstrap4.min.css"/>
<link rel="stylesheet" href="<?php echo $base_url;?>assets/fontawesome/css/all.min.css"> 
<link href="<?php echo $base_url;?>assets/css/dashboard.css" rel="stylesheet">
<script src="<?php echo $base_url;?>assets/js/jquery.min.js"></script>
<style>
.modal-dialog{
  max-width: 800px !important;
}
.modal-dialog .col-md-4{
  padding: 2px;
}
form{
  padding-left: 5px;
  padding-right: 10px;
}
#customerfrm p{
  padding-left: 5px;
}
.custinfo,.bsinfo{
  border-bottom: 1px dashed #ddd;
  padding: 0;
  color: #c1c100;
}
.bsinfo{
  margin-top: 20px;
}
</style>
</head>
<body> 
<?php include_once("includes/header.php");?>
<section id="main">
<div class="container-fluid">
 <div class="row">
   <?php include_once("includes/aside.php");?>
   <div class="content">
    <div class="col-md-12">
     <div class="breadcrumbs row">
      <ul class="breadcrumb">
       <li><i class="fas fa-tachometer-alt"></i>&nbsp;Dashboard</li>
       <li><i class="fas fa-users"></i> &nbsp;&nbsp;Customers</li>
      </ul>
    </div>

    <div class="row wrapper">
      <button class="btn item item1" data-dismiss="modal" data-toggle="modal" data-target="#usermodal"><i class="fa fa-plus"></i> New Customer</button>
      <span class="item item2" data-dismiss="modal" data-toggle="modal" data-target="#usermodal" style="display: none;"></span>
    </div>

     <div class="panel panel-default">
       <div class="panel-header dvtitle">Customers</div>
       <div class="panel-body">
        <div class="table-responsive row">
        <table id="tb_users" class="table table-striped table-bordered" cellspacing="0" width="100%">
         <thead>
           <tr><th>Cust No.</th><th>Name</th><th>Phone</th><th>Email</th><th>Branch</th><th>Reg Fee</th><th>Reg Date</th><th>Mode</th><th>Approval Status</th><th style="min-width: 100px;">Action</th></tr>
          </thead>
           <tbody>
             <?php
             $chkcustomers = mysqli_query($con,"SELECT * FROM customers WHERE branchId='$branchid' ORDER BY id DESC");
             while($row = mysqli_fetch_assoc($chkcustomers)){
             $custid = $row["id"];
             $status=$row["status"];
             $loancount = mysqli_num_rows(mysqli_query($con,"SELECT * FROM loan_applications WHERE custId='$custid'")); ?>
             <tr>
              <td><?php echo $row["custNo"];?></td>
              <td><?php echo $row["first_name"]." ".$row["middle_name"]." ".$row["last_name"];?></td>
              <td><?php echo $row["phone"];?></td>
              <td><?php echo $row["email"];?></td>
              <td>
              <?php 
               $branchid = $row["branchId"];
               echo mysqli_fetch_assoc(mysqli_query($con,"SELECT * FROM branches WHERE id='$branchid'"))["name"];
              ?>
              </td>
              <td>Ksh <?php echo $row["reg_fee"];?></td>
              <td><?php echo date("d M Y",strtotime($row["created_at"]));?></td>
              <td><?php echo $row["other_lead"];?></td>
              <td>
                  <?php if($status=="1"){ ?>
                  <button class="btn btn-success btn-xs">approved</button>
                  <?php }else if($status=="0"){ ?>
                  <button class="btn btn-warning btn-xs">pending</button>
                  <?php }else if($status=="2"){ ?>
                  <button class="btn btn-danger btn-xs">rejected</button>
                  <?php } ?>
              </td>
              <td>
               <a href="<?php echo $portal_url;?>customer/<?php echo $row["custNo"];?>"><button class="btn btn-xs btn-success" data-toggle="tooltip" data-placement="bottom" title="View customer profile"><i class="fas fa-search-plus"></i></button></a>
               <button class="btn btn-xs btn-primary edtcust" data-toggle="tooltip" data-placement="bottom" title="Edit Customer" data-id="<?php echo $row["id"];?>" data-fname="<?php echo $row["first_name"];?>" data-mname="<?php echo $row["middle_name"];?>" data-lname="<?php echo $row["last_name"];?>" data-phone="<?php echo $row["phone"];?>" data-email="<?php echo $row["email"];?>" data-ro="<?php echo $row["roId"];?>" data-phone2="<?php echo $row["phone2"];?>" data-idno="<?php echo $row["idNo"];?>" data-dob="<?php echo $row["dob"];?>" data-gender="<?php echo $row["gender"];?>" data-nickname="<?php echo $row["nickname"];?>" data-maritalstatus="<?php echo $row["maritalstatus"];?>" data-dependants="<?php echo $row["dependants"];?>" data-residenceperiod="<?php echo $row["residence_period"];?>" data-town="<?php echo $row["town"];?>" data-estate="<?php echo $row["estate"];?>" data-houseno="<?php echo $row["house_no"];?>" data-ownership="<?php echo $row["residence_ownership"];?>" data-landmark="<?php echo $row["landmark"];?>" data-ruralcounty="<?php echo $row["rural_county"];?>" data-ruraltown="<?php echo $row["rural_town"];?>" data-ruralvillage="<?php echo $row["rural_village"];?>" data-rurallandmark="<?php echo $row["rural_landmark"];?>" data-spousename="<?php echo $row["spouse_name"];?>" data-spouseid="<?php echo $row["spouse_id"];?>" data-spousephone="<?php echo $row["spousephone"];?>" data-spouseoccupation="<?php echo $row["spouse_occupation"];?>" data-lead="<?php echo $row["lead"];?>" data-otherlead="<?php echo $row["other_lead"];?>" data-bsname="<?php echo $row["business_name"];?>" data-bsnature="<?php echo $row["business_nature"];?>" data-bsage="<?php echo $row["business_age"];?>" data-bstype="<?php echo $row["business_type"];?>" data-bsaddress="<?php echo $row["business_address"];?>" data-bstown="<?php echo $row["business_town"];?>" data-bslocation="<?php echo $row["business_location"];?>" data-bslandmark="<?php echo $row["business_landmark"];?>" data-bsstreet="<?php echo $row["business_street"];?>" data-bsbuilding="<?php echo $row["business_building"];?>" data-bsphone="<?php echo $row["business_phone"];?>" data-bslicence="<?php echo $row["business_licence"];?>" data-bspin="<?php echo $row["business_pin"];?>"><i class="fas fa-pencil-alt"></i></button>
               <?php if($loancount < 1){ ?>
               <button class="btn btn-xs btn-danger delcust" id="<?php echo $row["id"];?>" data-toggle="tooltip" data-placement="bottom" title="Delete Customer"><i class="fa fa-trash"></i></button>
              <?php } ?>
              </td>
             </tr>
             <?php }
            ?>
         </tbody>
       </table>
      </div>
    </div>
   </div>
  

<div id="usermodal" class="modal fade" role="dialog">
 <div class="modal-dialog modal-lg">
  <div class="modal-content">
   <h3><i class="fas fa-users"></i> Customer Form<span class="close pull-right" data-dismiss="modal"><i class="fas fa-times"></i></span></h3>
   <form role="form" id="customerfrm">
   <p>Fill in customer details. All fields marked with <span style="color: #ff0000">*</span> are mandatory.</p> 
    <div class="col-md-12 custinfo">
     <h4>Customer Details</h4>
    </div>
    <div class="col-md-4">
     <div class="form-group">
      <label>Relationship Officer <span>*</span></label>
      <select class="form-control" id="ro">
      <?php
       $chkros = mysqli_query($con,"SELECT * FROM users WHERE typeId='5' AND branchId='$branchid'");
       while($row = mysqli_fetch_assoc($chkros)){ ?>
        <option value="<?php echo $row["id"];?>"><?php echo $row["first_name"]." ".$row["last_name"];?></option>
      <?php } ?>
      </select>
     </div>
    </div>
    <div class="col-md-4">
     <div class="form-group">
      <label>First Name <span>*</span></label>
      <input type="hidden" id="id" value="">
      <input type="text" class="form-control" id="fname" required>
     </div>
    </div>
    <div class="col-md-4">
     <div class="form-group">
      <label>Middle Name <span>*</span></label>
      <input type="text" class="form-control" id="mname" required>
     </div>
    </div>
    <div class="col-md-4">
     <div class="form-group">
      <label>Last Name <span>*</span></label>
      <input type="text" class="form-control" id="lname" required>
     </div>
    </div>
    <div class="col-md-4">
     <div class="form-group">
      <label>Email <span>*</span></label>
      <input type="email" class="form-control" id="email">
     </div>
    </div>
    <div class="col-md-4">
     <div class="form-group">
      <label>Mobile Line 1 <span>*</span></label>
      <input type="tel" class="form-control" id="phone" required>
     </div>
    </div>
    <div class="col-md-4">
     <div class="form-group">
      <label>Mobile Line 2 </label>
      <input type="tel" class="form-control" id="phone2">
     </div>
    </div>
    <div class="col-md-4">
     <div class="form-group">
      <label>National ID No. <span>*</span></label>
      <input type="number" class="form-control" id="idNo" required>
     </div>
    </div>
    <div class="col-md-4">
     <div class="form-group">
      <label>Date of Birth <span>*</span></label>
      <input type="date" class="form-control" id="dob" max="<?php echo date('Y-m-d',strtotime('18 years ago')) ?>" required>
     </div>
    </div>
    <div class="col-md-4">
     <div class="form-group">
      <label>Gender <span>*</span></label>
      <select class="form-control" id="gender">
      <?php
       $chkgenders = mysqli_query($con,"SELECT * FROM gender");
       while($row = mysqli_fetch_assoc($chkgenders)){ ?>
        <option value="<?php echo $row["id"];?>"><?php echo $row["name"];?></option>
      <?php } ?>
      </select>
     </div>
    </div>
    <div class="col-md-4">
     <div class="form-group">
      <label>Common Name <span>*</span></label>
      <input type="text" class="form-control" id="nickname" required>
     </div>
    </div>
    <div class="col-md-4">
     <div class="form-group">
      <label>Marital Status <span>*</span></label>
      <select class="form-control" id="maritalstatus">
      <?php
       $chkstatus = mysqli_query($con,"SELECT * FROM marital_status");
       while($row = mysqli_fetch_assoc($chkstatus)){ ?>
        <option value="<?php echo $row["id"];?>"><?php echo $row["name"];?></option>
      <?php } ?>
      </select>
     </div>
    </div>
    <div class="col-md-4">
     <div class="form-group">
      <label>No of Dependants <span>*</span></label>
      <input type="number" class="form-control" id="dependants" required>
     </div>
    </div>
    <div class="col-md-4">
     <div class="form-group">
      <label>Residence Period [Mnths] <span>*</span></label>
      <input type="number" class="form-control" id="residenceperiod" required>
     </div>
    </div>
    <div class="col-md-4">
     <div class="form-group">
      <label>Residence Town <span>*</span></label>
      <input type="text" class="form-control" id="town" required>
     </div>
    </div>
    <div class="col-md-4">
     <div class="form-group">
      <label>Estate </label>
      <input type="text" class="form-control" id="estate">
     </div>
    </div>
    <div class="col-md-4">
     <div class="form-group">
      <label>House No. </label>
      <input type="text" class="form-control" id="houseno">
     </div>
    </div>
    <div class="col-md-4">
     <div class="form-group">
      <label>Residence Ownership <span>*</span></label>
      <select class="form-control" id="ownership">
       <option value="0">Rented</option>
       <option value="1">Owned</option>
      </select>
     </div>
    </div>
    <div class="col-md-4">
     <div class="form-group">
      <label>Landmark (Sch/Church) <span>*</span></label>
      <input type="text" class="form-control" id="landmark" required>
     </div>
    </div>
    <div class="col-md-4">
     <div class="form-group">
      <label>Rural Residence County <span>*</span></label>
      <input type="text" class="form-control" id="ruralcounty" required>
     </div>
    </div>
    <div class="col-md-4">
     <div class="form-group">
      <label>Rural Residence Town <span>*</span></label>
      <input type="text" class="form-control" id="ruraltown" required>
     </div>
    </div>
    <div class="col-md-4">
     <div class="form-group">
      <label>Rural Residence Village <span>*</span></label>
      <input type="text" class="form-control" id="ruralvillage" required>
     </div>
    </div>
    <div class="col-md-4">
     <div class="form-group">
      <label>Rural Residence Landmark </label>
      <input type="text" class="form-control" id="rurallandmark">
     </div>
    </div>
    <div class="col-md-4">
     <div class="form-group">
      <label>Name of Spouse </label>
      <input type="text" class="form-control" id="spousename">
     </div>
    </div>
    <div class="col-md-4">
     <div class="form-group">
      <label>Spouse ID No. </label>
      <input type="text" class="form-control" id="spouseid">
     </div>
    </div>
    <div class="col-md-4">
     <div class="form-group">
      <label>Spouse Phone No. </label>
      <input type="tel" class="form-control" id="spousephone">
     </div>
    </div>
    <div class="col-md-4">
     <div class="form-group">
      <label>Spouse Occupation </label>
      <input type="text" class="form-control" id="spouseoccupation">
     </div>
    </div>
    <div class="col-md-6">
     <div class="form-group">
      <label>Knowledge of Kuza Work Africa <span>*</span></label>
      <select class="form-control" id="lead">
      <?php
       $chkleads = mysqli_query($con,"SELECT * FROM market_leads");
       while($row = mysqli_fetch_assoc($chkleads)){ ?>
        <option value="<?php echo $row["id"];?>"><?php echo $row["name"];?></option>
      <?php } ?>
      </select>
     </div>
    </div>
    <div class="col-md-6">
     <div class="form-group">
      <label>Other (State) </label>
      <input type="text" class="form-control" id="otherlead">
     </div>
    </div>
    
    <div class="col-md-4">
     <div class="form-group">
         <div style="height:40px">
          <label>ID Front </label>
        </div>
      <input type="file" class="form-control" onchange="encodeDoc3toBase64(this)" accept=".pdf,.jpg,.png,.jpeg">
      <input type="hidden" id="iddocument">
     </div>
    </div>
    <div class="col-md-4">
     <div class="form-group">
         <div style="height:40px">
          <label>ID Back </label>
        </div>
      <input type="file" class="form-control" onchange="encodeDoc5toBase64(this)" accept=".pdf,.jpg,.png,.jpeg">
      <input type="hidden" id="idbackdocument">
     </div>
    </div>
    <div class="col-md-4">
     <div class="form-group">
         <div style="height:40px">
            <label>Recent Passport Photo </label>
         </div>
      <input type="file" class="form-control" onchange="encodeDoc4toBase64(this)" accept=".pdf,.jpg,.png,.jpeg">
      <input type="hidden" id="recentphoto">
     </div>
    </div>
    
    <div class="col-md-12 bsinfo">
     <h4>Business Information</h4>
    </div>
    <div class="col-md-4">
     <div class="form-group">
      <label>Business Name </label>
      <input type="text" class="form-control" id="businessname">
     </div>
    </div>
    <div class="col-md-4">
     <div class="form-group">
      <label>Nature of Business </label>
      <input type="text" class="form-control" id="businessnature">
     </div>
    </div>
    <div class="col-md-4">
     <div class="form-group">
      <label>Years of Operation </label>
      <input type="number" class="form-control" id="businessage">
     </div>
    </div>
    <div class="col-md-4">
     <div class="form-group">
      <label>Type of Business</label>
      <select class="form-control" id="businesstype">
       <option value="Sole">Sole</option>
       <option value="Partners">Partners</option>
       <option value="Corporation">Corporation</option>
      </select>
     </div>
    </div>
    <div class="col-md-4">
     <div class="form-group">
      <label>Postal Address </label>
      <input type="text" class="form-control" id="businessaddress">
     </div>
    </div>
    <div class="col-md-4">
     <div class="form-group">
      <label>Town </label>
      <input type="text" class="form-control" id="businesstown">
     </div>
    </div>
    <div class="col-md-4">
     <div class="form-group">
      <label>Location </label>
      <input type="text" class="form-control" id="businesslocation">
     </div>
    </div>
    <div class="col-md-4">
     <div class="form-group">
      <label>Landmark </label>
      <input type="text" class="form-control" id="businesslandmark">
     </div>
    </div>
    <div class="col-md-4">
     <div class="form-group">
      <label>Street </label>
      <input type="text" class="form-control" id="businessstreet">
     </div>
    </div>
    <div class="col-md-4">
     <div class="form-group">
      <label>Building </label>
      <input type="text" class="form-control" id="businessbuilding">
     </div>
    </div>
    <div class="col-md-4">
     <div class="form-group">
      <label>Mobile </label>
      <input type="text" class="form-control" id="businessphone">
     </div>
    </div>
    <div class="col-md-4">
     <div class="form-group">
      <label>Licence No. </label>
      <input type="text" class="form-control" id="businesslicence">
     </div>
    </div>
    <div class="col-md-4">
     <div class="form-group">
      <label>KRA Pin </label>
      <input type="text" class="form-control" id="businesspin">
     </div>
    </div>
    <div class="col-md-4">
     <div class="form-group">
      <label>Residence direction map </label>
      <input type="file" class="form-control" onchange="encodeDoc1toBase64(this)" accept=".pdf,.jpg,.png,.jpeg">
      <input type="hidden" id="residencemap">
     </div>
    </div>
    <div class="col-md-4">
     <div class="form-group">
      <label>Business direction map </label>
      <input type="file" class="form-control" onchange="encodeDoc2toBase64(this)" accept=".pdf,.jpg,.png,.jpeg">
      <input type="hidden" id="businessmap">
     </div>
    </div>
    <div class="form-group" style="border-top: 1px solid #ddd;padding-top: 5px;">
      <button class="btn btn-block" type="submit"> <i class="fa fa-save"></i> Save Customer</button>
    </div>
    <div class="form-group">
     <div id="status"></div>
    </div>
   </form>
  </div>
 </div>
</div>

  </div>
 </div>
</div>
</div>
</section>
<script src="<?php echo $base_url;?>assets/bootstrap/bootstrap.min.js"></script>
<script src="<?php echo $base_url;?>assets/js/dashboard.js"></script>
<script src="<?php echo $base_url;?>assets/js/jquery.dataTables.min.js"></script>
<script src="<?php echo $base_url;?>assets/js/dataTables.bootstrap4.min.js"></script>
<script>
$(function(){
 $("#cust").attr("class","active");
 $('#tb_users').DataTable({"aaSorting":[]});

 $("body").on("click",".edtcust",function(){
  $("#id").val($(this).attr("data-id"));
  $("#fname").val($(this).attr("data-fname"));
  $("#mname").val($(this).attr("data-mname"));
  $("#lname").val($(this).attr("data-lname"));
  $("#email").val($(this).attr("data-email"));
  $("#phone").val($(this).attr("data-phone"));
  $("#phone2").val($(this).attr("data-phone2"));
  $("#idNo").val($(this).attr("data-idno"));
  $("#dob").val($(this).attr("data-dob"));
  $("#gender").val($(this).attr("data-gender"));
  $("#nickname").val($(this).attr("data-nickname"));
  $("#maritalstatus").val($(this).attr("data-maritalstatus"));
  $("#dependants").val($(this).attr("data-dependants"));
  $("#ro").val($(this).attr("data-ro"));
  $("#residenceperiod").val($(this).attr("data-residenceperiod"));
  $("#town").val($(this).attr("data-town"));
  $("#estate").val($(this).attr("data-estate"));
  $("#houseno").val($(this).attr("data-houseno"));
  $("#ownership").val($(this).attr("data-ownership"));
  $("#landmark").val($(this).attr("data-landmark"));
  $("#ruralcounty").val($(this).attr("data-ruralcounty"));
  $("#ruraltown").val($(this).attr("data-ruraltown"));
  $("#ruralvillage").val($(this).attr("data-ruralvillage"));
  $("#rurallandmark").val($(this).attr("data-rurallandmark"));
  $("#spousename").val($(this).attr("data-spousename"));
  $("#spouseid").val($(this).attr("data-spouseid"));
  $("#spousephone").val($(this).attr("data-spousephone"));
  $("#spouseoccupation").val($(this).attr("data-spouseoccupation"));
  $("#lead").val($(this).attr("data-lead"));
  $("#otherlead").val($(this).attr("data-otherlead"));
  $("#businessname").val($(this).attr("data-bsname"));
  $("#businessnature").val($(this).attr("data-bsnature"));
  $("#businessage").val($(this).attr("data-bsage"));
  $("#businesstype").val($(this).attr("data-bstype"));
  $("#businessaddress").val($(this).attr("data-bsaddress"));
  $("#businesstown").val($(this).attr("data-bstown"));
  $("#businesslocation").val($(this).attr("data-bslocation"));
  $("#businesslandmark").val($(this).attr("data-bslandmark"));
  $("#businessstreet").val($(this).attr("data-bsstreet"));
  $("#businessbuilding").val($(this).attr("data-bsbuilding"));
  $("#businessphone").val($(this).attr("data-bsphone"));
  $("#businesslicence").val($(this).attr("data-bslicence"));
  $("#businesspin").val($(this).attr("data-bspin"));
  $("#status").html("");
  $(".item2").click();
 });

 $("#customerfrm").submit(function(e){
  e.preventDefault();
  var id = $("#id").val();
  var fname = $("#fname").val();
  var mname = $("#mname").val();
  var lname = $("#lname").val();
  var phone = $("#phone").val();
  var phone2 = $("#phone2").val();
  var email = $("#email").val();
  var idNo = $("#idNo").val();
  var dob = $("#dob").val();
  var gender = $("#gender").val();
  var nickname = $("#nickname").val();
  var maritalstatus = $("#maritalstatus").val();
  var dependants = $("#dependants").val();
  var ro = $("#ro").val();
  var residenceperiod = $("#residenceperiod").val();
  var town = $("#town").val();
  var estate = $("#estate").val();
  var houseno = $("#houseno").val();
  var ownership = $("#ownership").val();
  var landmark = $("#landmark").val();
  var ruralcounty = $("#ruralcounty").val();
  var ruraltown = $("#ruraltown").val();
  var ruralvillage = $("#ruralvillage").val();
  var rurallandmark = $("#rurallandmark").val();
  var spousename = $("#spousename").val();
  var spouseid = $("#spouseid").val();
  var spousephone = $("#spousephone").val();
  var spouseoccupation = $("#spouseoccupation").val();
  var lead = $("#lead").val();
  var otherlead = $("#otherlead").val();
  var businessname = $("#businessname").val();
  var businessnature = $("#businessnature").val();
  var businessage = $("#businessage").val();
  var businesstype = $("#businesstype").val();
  var businessaddress = $("#businessaddress").val();
  var businesstown = $("#businesstown").val();
  var businesslocation = $("#businesslocation").val();
  var businesslandmark = $("#businesslandmark").val();
  var businessstreet = $("#businessstreet").val();
  var businessbuilding = $("#businessbuilding").val();
  var businessphone = $("#businessphone").val();
  var businesslicence = $("#businesslicence").val();
  var businesspin = $("#businesspin").val();
  var businessmap = $("#businessmap").val();
  var residencemap = $("#residencemap").val();
  
  var iddocument = $("#iddocument").val();
   var idbackdocument = $("#idbackdocument").val();
  var recentphoto = $("#recentphoto").val();
  
  $("#status").html("<p class='text-success bg-success'><i class='fa fa-spinner fa-pulse'></i> Saving the customer details...</p>"); 
  $.ajax({
    method: "POST",
    url: $("#portal_url").html()+"app/customers",
    data: {
      id:id,
      fname:fname,
      mname:mname,
      lname:lname,
      phone:phone,
      phone2:phone2,
      email:email,
      idNo:idNo,
      dob:dob,
      gender:gender,
      nickname:nickname,
      maritalstatus:maritalstatus,
      dependants:dependants,
      ro:ro,
      residenceperiod:residenceperiod,
      town:town,
      estate:estate,
      houseno:houseno,
      ownership:ownership,
      landmark:landmark,
      ruralcounty:ruralcounty,
      ruraltown:ruraltown,
      ruralvillage:ruralvillage,
      rurallandmark:rurallandmark,
      spousename:spousename,
      spouseid:spouseid,
      spousephone:spousephone,
      spouseoccupation:spouseoccupation,
      lead:lead,
      otherlead:otherlead,
      businessname:businessname,
      businessnature:businessnature,
      businessage:businessage,
      businesstype:businesstype,
      businessaddress:businessaddress,
      businesstown:businesstown,
      businesslocation:businesslocation,
      businesslandmark:businesslandmark,
      businessstreet:businessstreet,
      businessbuilding:businessbuilding,
      businessphone:businessphone,
      businesslicence:businesslicence,
      businesspin:businesspin,
      residencemap:residencemap,
      businessmap:businessmap,
      idbackdocument:idbackdocument,
       iddocument:iddocument,
      recentphoto:recentphoto,
    },
    cache:false
  }).done(function(data){
   if(data.status == 200){
    $("#status").html("<p class='alert alert-success'><i class='fa fa-check'></i> Customer saved successfully.</p>").delay(5000);
     window.location.replace($("#portal_url").html()+"customers");
   }
   if(data.status == 403){
    $("#status").html("<p class='alert alert-danger'><i class='fa fa-exclamation-circle'></i> You are not allowed to register customers.</p>");
   }
   if(data.status == 300){
    $("#status").html("<p class='alert alert-danger'><i class='fa fa-exclamation-circle'></i> An error occured, please try again later.</p>");
   }
   if(data.status == 401){
    $("#status").html("<p class='alert alert-danger'><i class='fa fa-exclamation-circle'></i> A customer with this email address already exist. Use a different email.</p>");
   }
  });
 });

 //Deleting a customer
 $(".delcust").click(function(){
  var delcust = $(this).attr("id");
  var d = confirm('Are you sure you want to delete this customer?');
  if(d == false){
   return false;
  }
  else{
    $.ajax({
      method:"post",
      url: $("#portal_url").html()+"app/customers",
      data:{
        delcust:delcust
      },
      cache:false
    }).done(function(data){
      if(data.status == "200"){
       window.location.replace($("#portal_url").html()+"customers");
      }
    });
    }
   });
 });
</script>
<script>
function encodeDoc1toBase64(element) {
 var file = element.files[0];
 var reader = new FileReader();
 reader.onloadend = function() {
  $("#residencemap").val(reader.result);
 }
 reader.readAsDataURL(file);
}

function encodeDoc2toBase64(element) {
 var file = element.files[0];
 var reader = new FileReader();
 reader.onloadend = function() {
  $("#businessmap").val(reader.result);
 }
 reader.readAsDataURL(file);
}

function encodeDoc3toBase64(element) {
 var file = element.files[0];
 var reader = new FileReader();
 reader.onloadend = function() {
  $("#iddocument").val(reader.result);
 }
 reader.readAsDataURL(file);
}
function encodeDoc5toBase64(element) {
 var file = element.files[0];
 var reader = new FileReader();
 reader.onloadend = function() {
  $("#idbackdocument").val(reader.result);
 }
 reader.readAsDataURL(file);
}
function encodeDoc4toBase64(element) {
 var file = element.files[0];
 var reader = new FileReader();
 reader.onloadend = function() {
  $("#recentphoto").val(reader.result);
 }
 reader.readAsDataURL(file);
}
</script>
<?php mysqli_close($con)?>
</body>
</html>