<?php
ob_start();
session_start();
include_once("../config/index.php");
include_once("includes/auth.php");
$now = date('Y-m-d H:i:s');
?>
<!DOCTYPE html>
<html lang="en-US">
<head>
<meta charset="UTF-8">
<title>Follow up Fee | Kuza Fine Africa</title>
<meta name="viewport" content="width=device-width,initial-scale=1">
<link rel="shortcut icon" href="<?php echo $base_url;?>assets/images/logo/favicon.ico">
<link href="<?php echo $base_url;?>assets/bootstrap/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="<?php echo $base_url;?>assets/css/dataTables.bootstrap4.min.css"/>
<link rel="stylesheet" href="<?php echo $base_url;?>assets/css/buttons.bootstrap4.min.css"/>
<link rel="stylesheet" href="<?php echo $base_url;?>assets/fontawesome/css/all.min.css"> 
<link href="<?php echo $base_url;?>assets/css/dashboard.css" rel="stylesheet">
<script src="<?php echo $base_url;?>assets/js/jquery.min.js"></script>
<style>
.modal-dialog{
  max-width: 450px;
}
form{
  padding-left: 5px;
  padding-right: 10px;
}
</style>
</head>
<body> 
<?php include_once("includes/header.php");?>
<section id="main">
<div class="container-fluid">
 <div class="row">
  <?php include_once("includes/aside.php");?>
  <div class="content">
   <div class="col-md-12">
    <div class="breadcrumbs row">
     <ul class="breadcrumb">
      <li><i class="fas fa-tachometer-alt"></i>&nbsp;Dashboard</li>
      <li><i class="fas fa-cart-arrow-down"></i> &nbsp;&nbsp;Follow up Fee</li>
     </ul>
    </div>

    <div class="row wrapper">
      <button class="btn item item1" data-dismiss="modal" data-toggle="modal" data-target="#purchmodal"><i class="fa fa-plus"></i> New Follow up Fee</button>
      <span class="item item2" data-dismiss="modal" data-toggle="modal" data-target="#purchmodal" style="display: none;"></span>&nbsp;&nbsp;&nbsp;
      <button style="display:none" class="btn item" data-dismiss="modal" data-toggle="modal" data-target="#filtermodal"><i class="far fa-calendar-alt"></i> Filter by Date</button>
    </div>

     <div class="panel panel-default dashboard">
      <div class="panel-header dvtitle">Follow up Fee</div>
      <div class="panel-body">
       <div class="table-responsive row">
        <table id="tb_purchs" class="table table-striped table-bordered" cellspacing="0" width="100%">
         <thead>
          <tr><th>Customer</th><th>Amount</th><th>Date</th><th style="min-width: 100px;">Action</th></tr>
         </thead>
         <tbody>
         <?php
          $chkpurchs = mysqli_query($con,"SELECT * FROM followup ORDER BY id DESC");
          while($row = mysqli_fetch_assoc($chkpurchs)){
             $custid=$row["custid"];
             $assoc= mysqli_fetch_assoc(mysqli_query($con,"SELECT first_name, middle_name,last_name FROM customers WHERE id='$custid'"));
          ?>
          <tr>
           <td><?php echo $assoc["first_name"].''.$assoc["last_name"];?></td>
           <td>Ksh. <?php echo number_format($row["amount"]);?></td>
           <td><?php echo date("d M Y",strtotime($row["createdon"]));?></td>
           <td>
            <button style="display:none" class="btn btn-xs btn-primary edtpurch" data-toggle="tooltip" data-placement="bottom" title="Edit followup" data-id="<?php echo $row["id"];?>" data-amount="<?php echo $row["amount"];?>" data-customer="<?php echo $row['custid'];?>"><i class="fas fa-pencil-alt"></i></button>
            <button class="btn btn-xs btn-danger delpurch" id="<?php echo $row["id"];?>" data-toggle="tooltip" data-placement="bottom" title="Delete followup"><i class="fa fa-trash"></i></button>
           </td>
          </tr>
          <?php } ?>
         </tbody>
        </table>
       </div>
      </div>
     </div>

     <div id="purchmodal" class="modal fade" role="dialog">
      <div class="modal-dialog">
       <div class="modal-content">
        <h3><i class="fas fa-cart-arrow-down"></i> New Follow up Fee<span class="close pull-right" data-dismiss="modal"><i class="fas fa-times"></i></span></h3>
        <form role="form" id="followupfrm">

        <div class="form-group">
         <label>Customer <span>*</span></label>
         <input type="hidden" id="id" value="" name="id">
        <select class="form-control" id="custid">
            <?php
            $cust=mysqli_query($con,"SELECT * FROM customers ORDER BY first_name ASC");
            while($cs=mysqli_fetch_assoc($cust)){ ?>
               <option value='<?php echo $cs["id"] ?>'><?php echo $cs["first_name"]." ".$cs["last_name"]." savings ksh. ".$cs["savings"] ?> </option>
           <?php }
            ?>
        </select>
        </div>
        <div class="form-group">
         <label>Amount <span>*</span></label>
         <input type="number" class="form-control" id="amount" name="amount" required>
        </div>
        <div class="form-group" style="border-top: 1px solid #ddd;padding-top: 5px;">
         <button class="btn btn-block" type="submit"> <i class="fa fa-save"></i> Save Follow up Fee</button>
        </div>
        <div class="form-group">
         <div id="status"></div>
        </div>
       </form>
      </div>
     </div>
    </div>
    
    <div id="filtermodal" class="modal fade" role="dialog">
   <div class="modal-dialog">
    <div class="modal-content">
     <h3><i class="far fa-calendar-alt"></i> Customized Duration Report<span class="close pull-right" data-dismiss="modal"><i class="fas fa-times"></i></span></h3>
     <form role="form" id="filterform">
      <div class="col-md-6">
       <div class="form-group">
        <label>Start Date <span>*</span></label>
        <input type="date" class="form-control" id="date1" required>
       </div>
      </div>
      <div class="col-md-6">
       <div class="form-group">
        <label>End Date <span>*</span></label>
        <input type="date" class="form-control" id="date2" required>
       </div>
      </div>
      <div class="form-group">
       <button class="btn btn-block" type="submit"><i class="fa fa-save"></i> Show Report</button>
      </div>
      <div class="form-group">
       <div id="filterstatus"></div>
      </div>
     </form>
    </div>
   </div>
  </div>

  </div>
 </div>
</div>
</div>
</section>
<script src="<?php echo $base_url;?>assets/bootstrap/bootstrap.min.js"></script>
<script src="<?php echo $base_url;?>assets/js/dashboard.js"></script>
<script src="<?php echo $base_url;?>assets/js/jquery.dataTables.min.js"></script>
<script src="<?php echo $base_url;?>assets/js/dataTables.bootstrap4.min.js"></script>
<script>
$(function(){
 $("#flwup").attr("class","active");
 $('#tb_purchs').DataTable({"aaSorting":[]});

 $("body").on("click",".edtpurch",function(){
  $("#id").val($(this).attr("data-id"));
  $("#custid").val($(this).attr("data-customer"));
  $("#amount").val($(this).attr("data-amount"));
  $("#status").html("");
  $(".item1").click();
 });

 $("#followupfrm").submit(function(e){
  e.preventDefault();
  var id = $("#id").val();
  var custid = $("#custid").val();
  var amount = $("#amount").val();
  
  $("#status").html("<p class='text-success bg-success'><i class='fa fa-spinner fa-pulse'></i> Saving the followup...</p>"); 
  $.ajax({
    method: "POST",
    url: $("#portal_url").html()+"app/followup",
    data: {
      id:id,
      custid:custid,
      amount:amount
    },
    cache:false
  }).done(function(data){
   if(data.status == 200){
    $("#status").html("<p class='alert alert-success'><i class='fa fa-check'></i> followup saved successfully.</p>").delay(3000);
     window.location.replace($("#portal_url").html()+"followup");
   }
   if(data.status == 301){
    $("#status").html("<p class='alert alert-danger'><i class='fa fa-exclamation-circle'></i> customer has no sufficient savings.</p>");
   }
   if(data.status == 300){
    $("#status").html("<p class='alert alert-danger'><i class='fa fa-exclamation-circle'></i> An error occured, please try again later.</p>");
   }
  });
 });

 //Deleting a followup
 $(".delpurch").click(function(){
  var delpurch = $(this).attr("id");
  var d = confirm('Are you sure you want to delete this followup?');
  if(d == false){
   return false;
  }
  else{
    $.ajax({
      method:"post",
      url: $("#portal_url").html()+"app/followup",
      data:{
        delpurch:delpurch
      },
      cache:false
    }).done(function(data){
      if(data.status == "200"){
       window.location.replace($("#portal_url").html()+"followup");
      }
    });
    }
   });
   
   //Custom duration report
  $("#filterform").submit(function(e){
   e.preventDefault();
   var date1 = $("#date1").val();
   var date2 = $("#date2").val();
   $("#filterform .btn").attr("disabled","disabled");
   $("#filterstatus").html("<p class='alert alert-success' style='padding:10px;'><i class='fa fa-spinner fa-pulse'></i> Please wait....</p>");
   $.ajax({
    type: "POST",
    url: $("#portal_url").html()+"reports/followup",
    data: {
      date1:date1,
      date2:date2
    },
    cache: false
   }).done(function(data){
    $("#filterform .btn").removeAttr("disabled");
    $("#filterstatus").html("");
    $(".dashboard").html(data);
    $('#filtermodal').modal('toggle');
    $('#tb_purchs').DataTable({"aaSorting": []});
   });
  });
 });
</script>
</body>
</html>