<?php
ob_start();
session_start();
include_once("../config/index.php");
include_once("includes/auth.php");
$now = date('Y-m-d H:i:s');
?>
<!DOCTYPE html>
<html lang="en-US">
<head>
<meta charset="UTF-8">
<title> Chap Chap Loan Arrears | Kuza Work Africa</title>
<meta name="viewport" content="width=device-width,initial-scale=1">
<link rel="shortcut icon" href="<?php echo $base_url;?>assets/images/logo/favicon.ico">
<link href="<?php echo $base_url;?>assets/bootstrap/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="<?php echo $base_url;?>assets/css/dataTables.bootstrap4.min.css"/>
<link rel="stylesheet" href="<?php echo $base_url;?>assets/css/buttons.bootstrap4.min.css"/>
<link rel="stylesheet" href="<?php echo $base_url;?>assets/fontawesome/css/all.min.css"> 
<link href="<?php echo $base_url;?>assets/css/dashboard.css" rel="stylesheet">
<script src="<?php echo $base_url;?>assets/js/jquery.min.js"></script>
</head>
<body> 
<?php include_once("includes/header.php");?>
<section id="main">
<div class="container-fluid">
 <div class="row">
   <?php include_once("includes/aside.php");?>
   <div class="content">
    <div class="col-md-12">
     <div class="breadcrumbs row">
      <ul class="breadcrumb">
       <li><i class="fas fa-tachometer-alt"></i>&nbsp;Dashboard</li>
       <li><i class="fas fa-hand-holding-usd"></i> &nbsp;&nbsp;Chap Chap Loan Arrears</li>
      </ul>
    </div>

     <div class="panel panel-default">
       <div class="panel-header dvtitle">Loan Arrears</div>
       <div class="panel-body">
           
        <div class="table-responsive row">
        <table id="tb_default" class="table table-striped table-bordered" cellspacing="0" width="100%">
         <thead>
           <tr>
               <th>Loan No</th>
                <th>Customer Name</th>
                <th>Week</th>
                <th>Due Date</th>
                <th>Arrears</th>
                <th style="display:none"></th>
                <th style="display:none"></th>
            </tr>
          </thead>
           <tbody>
             <?php
            
            
            $sql = "SELECT chapchaploan_applications.* FROM chapchaploan_applications,users WHERE chapchaploan_applications.status='4' AND amount_repayable>amt_repaid AND chapchaploan_applications.userId=users.id AND users.branchId='$branchid' ORDER BY chapchaploan_applications.id DESC";
            $result = mysqli_query($con, $sql);
            $tdy = date('Y-m-d');
            
            while ($row = mysqli_fetch_assoc($result)) {
                $chapchaploan_id = $row['id'];
                $custId = $row['custId'];
                $amount_repayable = $row['amount_repayable'];
                $start_date = $row['disbursed_at'];
                $prodId = $row["prodId"];
                $duration = mysqli_fetch_assoc(mysqli_query($con, "SELECT duration FROM loan_products WHERE id='$prodId'"))["duration"];
            
                // Limit to a maximum of 9 weeks
                $total_weeks = ceil($duration / 7);
                $weekly_payment = ceil($amount_repayable / $total_weeks);
            
                // Track the most recent arrears week
                $latest_week = 0;
                $latest_due_date = '';
                $latest_arrears = 0;
            
                for ($week = 1; $week <= $total_weeks; $week++) {
                    // $due_date = date('Y-m-d', strtotime("$start_date +" . ($week * 7) . " days"));
                    // $due_date = date('Y-m-d', strtotime($due_date . ' +1 day'));
                    $due_date = date('Y-m-d', strtotime("$start_date + " . (($week - 1) * 7) . " days"));
                    $due_date = date('Y-m-d', strtotime($due_date . ' +1 day'));
            
                    if (strtotime($due_date) < strtotime($tdy)) {
                        // Check how much has been paid up to this due date
                         $payment_sql = "SELECT SUM(amount) as total_paid FROM chapchaploan_repayments WHERE chapchaploanId = '$chapchaploan_id' AND created_at <= '$due_date'";
                        $payment_sql = "SELECT SUM(amount) as total_paid FROM chapchaploan_repayments WHERE chapchaploanId = '$chapchaploan_id'";
                        $payment_result = mysqli_query($con, $payment_sql);
                        $total_paid = 0;
                        if (mysqli_num_rows($payment_result) > 0) {
                            $payment_row = mysqli_fetch_assoc($payment_result);
                            $total_paid = $payment_row['total_paid'];
                        }
            
                        $expected_payment = $weekly_payment * ($week-1);
                        $arrears = max(0, $expected_payment - $total_paid);
            
                        if ($arrears > 0) {
                            // Always overwrite — so only the latest arrears week is stored
                            $latest_week = $week-1;
                            $latest_due_date = $due_date;
                            $latest_arrears = $arrears;
                            $arr=$due_date;
                        }
                    }
                }
            
                // Output only the latest week with arrears if any
                if ($latest_arrears > 0) {
                    
                           $custid = $custId;
                            $cust = mysqli_fetch_assoc(mysqli_query($con,"SELECT * FROM customers WHERE id='$custid'"));
                            
                         ?>
                         <tr>
                          <td><?php echo $row["chapchaploanNo"];?></td>
                          <td>
                           <?php
                            
                            echo $cust["first_name"]." ".$cust["middle_name"]." ".$cust["last_name"];
                           ?>
                          </td>
                          <td>Week <?php echo $latest_week ?></td>
                          <td><?php echo $arr;?></td>
                          <td>Ksh. <?php echo $arrears;?></td>
                          <td style="display:none">
                          <button class="sendsms btn btn-sm btn-info" id='<?php echo $cust["phone"] ?>'>Send SMS</button> 
                          </td>
                          <td style="display:none"><input type="checkbox" class="sms-checkbox" value="<?php echo $cust["phone"] ?>"></td>
                         </tr>
                        <?php }} ?>
            
         </tbody>
       </table>
        <textarea style="display:none" class="form-control" id="customermessage"></textarea>
        <br>
        <button style="display:none" class="btn btn-warning btn-md" onclick="sendSelectedSMS()">Send SMS to Selected</button>
      </div>
    </div>
   </div>

  </div>
 </div>
</div>
</div>
</section>
<script src="<?php echo $base_url;?>assets/bootstrap/bootstrap.min.js"></script>
<script src="<?php echo $base_url;?>assets/js/dashboard.js"></script>
<script src="<?php echo $base_url;?>assets/js/jquery.dataTables.min.js"></script>
<script src="<?php echo $base_url;?>assets/js/dataTables.bootstrap4.min.js"></script>
<?php include_once("includes/buttons.php");?>

<script>
  function sendSelectedSMS() {
    const checkboxes = document.querySelectorAll('.sms-checkbox:checked');
    const selectedLoanNos = Array.from(checkboxes).map(cb => cb.value);
    var customermessage=$("#customermessage").val();
    
    if (selectedLoanNos.length === 0) {
      alert("Please select at least one row to send SMS.");
      return;
    }

    // Simulate sending SMS (here you'd call your API or backend logic)
    //alert("Sending SMS to Loan Numbers: " + selectedLoanNos.join(", "));

    // Optionally send this data to your server
    fetch('app/send-sms', {
      method: 'POST',
      headers: { 'Content-Type': 'application/json' },
      body: JSON.stringify({ phoneNumbers: selectedLoanNos,customermessage:customermessage })
    });
    alert("Message send request processed.");
  }
</script>

<script>
//send sms
 $(".sendsms").click(function(){
  var sendsms2 = $(this).attr("id");
  var d = confirm('Are you sure you want to send reminder sms?');
  if(d == false){
   return false;
  }
  else{
    $.ajax({
      method:"post",
      url: $("#portal_url").html()+"app/chapchaploan-products",
      data:{
        sendsms2:sendsms2
      },
      cache:false
    }).done(function(data){
      if(data.status == "200"){
       window.location.replace($("#portal_url").html()+"chapchaploan-arrears");
      }
    });
    }
   });
$(function(){
 $("#charr").attr("class","active");
 function dataTables(tb){
 var table = $('#'+tb+'').DataTable({
  lengthChange: false,
  "aaSorting": [],
  "buttons": [
  {"extend": 'copy', "text":'<i class="fas fa-copy"></i> Copy',"className": 'btn btn-success btn-sm'},
  {"extend": 'csv', "text":'<i class="fas fa-file-csv"></i> CSV',"className": 'btn btn-success btn-sm'},
  {"extend": 'excel', "text":'<i class="fas fa-file-excel"></i> Excel',"className": 'btn btn-success btn-sm' },
  {"extend": 'pdf', "text":'<i class="fas fa-file-pdf"></i> PDF',"className": 'btn btn-success btn-sm'},
  {"extend": 'print', "text":'<i class="fas fa-print"></i> Print',"className": 'btn btn-success btn-sm'}
  ]
 }); 
 table.buttons().container().appendTo( '#'+tb+'_wrapper .col-md-6:eq(0)' );
 }
 dataTables("tb_default");
 });
</script>
</body>
</html>