<?php
ob_start();
session_start();
include_once("../config/index.php");
include_once("includes/auth.php");
$now = date('Y-m-d H:i:s');
?>
<!DOCTYPE html>
<html lang="en-US">
<head>
<meta charset="UTF-8">
<title>Loan Arrears | Kuza Work Africa</title>
<meta name="viewport" content="width=device-width,initial-scale=1">
<link rel="shortcut icon" href="<?php echo $base_url;?>assets/images/logo/favicon.ico">
<link href="<?php echo $base_url;?>assets/bootstrap/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="<?php echo $base_url;?>assets/css/dataTables.bootstrap4.min.css"/>
<link rel="stylesheet" href="<?php echo $base_url;?>assets/css/buttons.bootstrap4.min.css"/>
<link rel="stylesheet" href="<?php echo $base_url;?>assets/fontawesome/css/all.min.css"> 
<link href="<?php echo $base_url;?>assets/css/dashboard.css" rel="stylesheet">
<script src="<?php echo $base_url;?>assets/js/jquery.min.js"></script>
</head>
<body> 
<?php include_once("includes/header.php");?>
<section id="main">
<div class="container-fluid">
 <div class="row">
   <?php include_once("includes/aside.php");?>
   <div class="content">
    <div class="col-md-12">
     <div class="breadcrumbs row">
      <ul class="breadcrumb">
       <li><i class="fas fa-tachometer-alt"></i>&nbsp;Dashboard</li>
       <li><i class="fas fa-hand-holding-usd"></i> &nbsp;&nbsp;Loan Arrears</li>
      </ul>
    </div>

     <div class="panel panel-default">
       <div class="panel-header dvtitle">Loan Arrears</div>
       <div class="panel-body">
           
        <div class="table-responsive row">
        <table id="tb_default" class="table table-striped table-bordered" cellspacing="0" width="100%">
         <thead>
           <tr>
               <th>Loan No</th>
                <th>Customer Name</th>
                <th>Phone</th>
                <th>Week</th>
                <th>Due Date</th>
                <th>Arrears</th>
                <th></th>
                <th></th>
            </tr>
          </thead>
           <tbody>
            <?php
$sql = "SELECT loan_applications.* 
        FROM loan_applications 
        JOIN users ON loan_applications.userId = users.id 
        WHERE loan_applications.status='4' 
          AND amount_repayable > amt_repaid 
          AND users.branchId='$branchid' 
        ORDER BY loan_applications.id DESC";
$result = mysqli_query($con, $sql);

$tdy = date('Y-m-d');
$tdy_end = $tdy . " 23:59:59"; // end of today
$total_arrears = 0;

while ($row = mysqli_fetch_assoc($result)) {
    $loan_id = $row['id'];
    $custId = $row['custId'];
    $amount_repayable = (float)$row['amount_repayable'];
    $start_date = $row['disbursed_at'];
    $prodId = $row["prodId"];

    // Get product duration
    $duration = mysqli_fetch_assoc(mysqli_query($con, 
        "SELECT duration FROM loan_products WHERE id='$prodId'"))["duration"];

    // Interval days (14 for bi-weekly, else 7)
    $interval_days = ($prodId == 10) ? 14 : 7;

    // Total installments
    $total_installments = ceil($duration / $interval_days);
    $installment_amount = ceil($amount_repayable / $total_installments);

    // Figure out how many installments should have been due BEFORE today
    $expected_installments = 0;
    $latest_due_date = '';
    for ($i = 1; $i <= $total_installments; $i++) {
        $due_date = date('Y-m-d', strtotime("$start_date + " . ($i * $interval_days) . " days"));
        if (strtotime($due_date) < strtotime($tdy)) {  // ✅ strictly less than today
            $expected_installments = $i;
            $latest_due_date = $due_date;
        } else {
            break;
        }
    }

    if ($expected_installments > 0) {
        $expected_due_amount = $installment_amount * $expected_installments;

        // Total paid up to end of today
        $pay_sql = "SELECT COALESCE(SUM(amount),0) AS total_paid 
                    FROM loan_repayments 
                    WHERE loanId = '$loan_id' AND created_at <= '$tdy_end'";
        $pay_res = mysqli_query($con, $pay_sql);
        $total_paid = 0.0;
        if ($pay_res && mysqli_num_rows($pay_res) > 0) {
            $total_paid = (float)mysqli_fetch_assoc($pay_res)['total_paid'];
        }

        // Arrears = expected due - total paid
        $arrears = max(0, round($expected_due_amount - $total_paid, 2));

        if ($arrears > 0) {
            $cust = mysqli_fetch_assoc(mysqli_query($con, 
                "SELECT * FROM customers WHERE id='$custId'"));

            $total_arrears += $arrears;
            ?>
            <tr>
                <td><?php echo $row["loanNo"];?></td>
                <td><?php echo $cust["first_name"]." ".$cust["middle_name"]." ".$cust["last_name"];?></td>
                <td><?php echo $cust["phone"] ?></td>
                <td>
                    <?php 
                    echo ($prodId == 10) 
                        ? "Bi-Week $expected_installments" 
                        : "Week $expected_installments"; 
                    ?>
                </td>
                <td><?php echo $latest_due_date;?></td>
                <td>Ksh. <?php echo number_format($arrears,2);?></td>
                <td>
                    <button class="sendsms btn btn-sm btn-info" id='<?php echo $cust["phone"] ?>'>Send SMS</button> 
                </td>
                <td><input type="checkbox" class="sms-checkbox" value="<?php echo $cust["phone"] ?>"></td>
            </tr>
            <?php 
        }
    }
}
?>


<!-- Table footer -->
<tfoot>
<tr>
    <th colspan="5" style="text-align:right">Total Arrears:</th>
    <th colspan="3">Ksh. <?php echo number_format($total_arrears, 2); ?></th>
</tr>
</tfoot>




            
         </tbody>
       </table>
        <textarea style="display:none" class="form-control" id="customermessage"></textarea>
        <br>
        <button class="btn btn-warning btn-md" onclick="sendSelectedSMS()">Send SMS to Selected</button>
      </div>
    </div>
   </div>

  </div>
 </div>
</div>
</div>
</section>
<script src="<?php echo $base_url;?>assets/bootstrap/bootstrap.min.js"></script>
<script src="<?php echo $base_url;?>assets/js/dashboard.js"></script>
<script src="<?php echo $base_url;?>assets/js/jquery.dataTables.min.js"></script>
<script src="<?php echo $base_url;?>assets/js/dataTables.bootstrap4.min.js"></script>
<?php include_once("includes/buttons.php");?>

<script>
  function sendSelectedSMS() {
    const checkboxes = document.querySelectorAll('.sms-checkbox:checked');
    const selectedLoanNos = Array.from(checkboxes).map(cb => cb.value);
    var customermessage=$("#customermessage").val();
    
    if (selectedLoanNos.length === 0) {
      alert("Please select at least one row to send SMS.");
      return;
    }

    // Simulate sending SMS (here you'd call your API or backend logic)
    //alert("Sending SMS to Loan Numbers: " + selectedLoanNos.join(", "));

    // Optionally send this data to your server
    fetch('app/send-sms', {
      method: 'POST',
      headers: { 'Content-Type': 'application/json' },
      body: JSON.stringify({ phoneNumbers: selectedLoanNos,customermessage:customermessage })
    });
    alert("Message send request processed.");
  }
</script>

<script>
//send sms
 $(".sendsms").click(function(){
  var sendsms2 = $(this).attr("id");
  var d = confirm('Are you sure you want to send reminder sms?');
  if(d == false){
   return false;
  }
  else{
    $.ajax({
      method:"post",
      url: $("#portal_url").html()+"app/loan-products",
      data:{
        sendsms2:sendsms2
      },
      cache:false
    }).done(function(data){
      if(data.status == "200"){
       window.location.replace($("#portal_url").html()+"loan-arrears");
      }
    });
    }
   });
$(function(){
 $("#arr").attr("class","active");
 function dataTables(tb){
 var table = $('#'+tb+'').DataTable({
  lengthChange: false,
  "aaSorting": [],
  "buttons": [
  {"extend": 'copy', "text":'<i class="fas fa-copy"></i> Copy',"className": 'btn btn-success btn-sm'},
  {"extend": 'csv', "text":'<i class="fas fa-file-csv"></i> CSV',"className": 'btn btn-success btn-sm'},
  {"extend": 'excel', "text":'<i class="fas fa-file-excel"></i> Excel',"className": 'btn btn-success btn-sm' },
  {"extend": 'pdf', "text":'<i class="fas fa-file-pdf"></i> PDF',"className": 'btn btn-success btn-sm'},
  {"extend": 'print', "text":'<i class="fas fa-print"></i> Print',"className": 'btn btn-success btn-sm'}
  ]
 }); 
 table.buttons().container().appendTo( '#'+tb+'_wrapper .col-md-6:eq(0)' );
 }
 dataTables("tb_default");
 });
</script>
</body>
</html>