<?php
ob_start();
session_start();
include_once("../config/index.php");
include_once("includes/auth.php");
$now = date('Y-m-d H:i:s');
?>
<!DOCTYPE html>
<html lang="en-US">
<head>
<meta charset="UTF-8">
<title>Loan Defaults | Kuza Work Africa</title>
<meta name="viewport" content="width=device-width,initial-scale=1">
<link rel="shortcut icon" href="<?php echo $base_url;?>assets/images/logo/favicon.ico">
<link href="<?php echo $base_url;?>assets/bootstrap/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="<?php echo $base_url;?>assets/css/dataTables.bootstrap4.min.css"/>
<link rel="stylesheet" href="<?php echo $base_url;?>assets/css/buttons.bootstrap4.min.css"/>
<link rel="stylesheet" href="<?php echo $base_url;?>assets/fontawesome/css/all.min.css"> 
<link href="<?php echo $base_url;?>assets/css/dashboard.css" rel="stylesheet">
<script src="<?php echo $base_url;?>assets/js/jquery.min.js"></script>
</head>
<body> 
<?php include_once("includes/header.php");?>
<section id="main">
<div class="container-fluid">
 <div class="row">
   <?php include_once("includes/aside.php");?>
   <div class="content">
    <div class="col-md-12">
     <div class="breadcrumbs row">
      <ul class="breadcrumb">
       <li><i class="fas fa-tachometer-alt"></i>&nbsp;Dashboard</li>
       <li><i class="fas fa-hand-holding-usd"></i> &nbsp;&nbsp;Loan Defaults</li>
      </ul>
    </div>

     <div class="panel panel-default">
       <div class="panel-header dvtitle">Loan Defaults</div>
       <div class="panel-body">
        <div class="table-responsive row">
        <table id="tb_default" class="table table-striped table-bordered" cellspacing="0" width="100%">
         <thead>
           <tr>
             <th>Loan No.</th>
             <th>Customer</th>
             <th>Due Date</th>
             <th>Balance</th>
             <th>Action</th>
           </tr>
         </thead>
         <tbody>
             <?php
            $today1=date("Y-m-d");
            $chkarrears = mysqli_query($con,"SELECT loan_applications.* FROM loan_applications,users 
                WHERE disbursed_by!='0' 
                AND amount_repayable > amt_repaid 
                AND loan_applications.userId=users.id 
                AND users.branchId='$branchid' 
                ORDER BY loan_applications.id DESC");

            while($row = mysqli_fetch_assoc($chkarrears)){
               $prodId=$row["prodId"];
               $loanid=$row["id"];
               $disbursed_at=date("Y-m-d",strtotime($row["disbursed_at"]));
               $amount_repayable=$row["amount_repayable"];
               $product=mysqli_fetch_assoc(mysqli_query($con,"SELECT * FROM loan_products WHERE id='$prodId'"));
               $duration=$product["duration"];
               $due_date = date("Y-m-d", strtotime($disbursed_at. ' +'.$duration.' days'));

               if($due_date < $today1){
             ?>
             <tr>
              <td><?php echo $row["loanNo"];?></td>
              <td>
               <?php
                $custid = $row["custId"];
                $cust = mysqli_fetch_assoc(mysqli_query($con,"SELECT * FROM customers WHERE id='$custid'"));
                echo $cust["first_name"]." ".$cust["middle_name"]." ".$cust["last_name"];
               ?>
              </td>
              <td><?php echo date("d M Y",strtotime($due_date));?></td>
              <td>Ksh. <?php echo $amount_repayable - $row["amt_repaid"]; ?></td>

              <td>
                <button 
                    class="btn btn-danger btn-sm mark-badloan" 
                    data-loanid="<?php echo $loanid; ?>">
                  Mark as Bad Loan
                </button>
              </td>
             </tr>
            <?php }} ?>
         </tbody>
       </table>
      </div>
    </div>
   </div>

  </div>
 </div>
</div>
</div>
</section>

<script src="<?php echo $base_url;?>assets/bootstrap/bootstrap.min.js"></script>
<script src="<?php echo $base_url;?>assets/js/dashboard.js"></script>
<script src="<?php echo $base_url;?>assets/js/jquery.dataTables.min.js"></script>
<script src="<?php echo $base_url;?>assets/js/dataTables.bootstrap4.min.js"></script>
<?php include_once("includes/buttons.php");?>

<script>
$(function(){
 $("#default").attr("class","active");

 var table = $('#tb_default').DataTable({
    lengthChange: false,
    "aaSorting": [],
    "buttons": [
      {"extend": 'copy', "text":'<i class="fas fa-copy"></i> Copy',"className": 'btn btn-success btn-sm'},
      {"extend": 'csv', "text":'<i class="fas fa-file-csv"></i> CSV',"className": 'btn btn-success btn-sm'},
      {"extend": 'excel', "text":'<i class="fas fa-file-excel"></i> Excel',"className": 'btn btn-success btn-sm'},
      {"extend": 'pdf', "text":'<i class="fas fa-file-pdf"></i> PDF',"className": 'btn btn-success btn-sm'},
      {"extend": 'print', "text":'<i class="fas fa-print"></i> Print',"className": 'btn btn-success btn-sm'}
    ]
 });
 table.buttons().container().appendTo('#tb_default_wrapper .col-md-6:eq(0)');

 // Mark Bad Loan Button
 $(document).on("click", ".mark-badloan", function() {
    var loanId = $(this).data("loanid");

    if(confirm("Do you want to mark this loan as a bad loan?")){
        $.ajax({
            url: "app/badloan",
            type: "POST",
            data: { loanId: loanId },
            success: function(response){
                alert(response);
                location.reload();
            },
            error: function(){
                alert("Error marking loan as bad loan.");
            }
        });
    }
 });
});
</script>
</body>
</html>
