<?php
ob_start();
session_start();
include_once("../config/index.php");
include_once("includes/auth.php");
$now = date('Y-m-d H:i:s');
$expld_url = explode("/", $_SERVER["REQUEST_URI"]);
$loanNo = end($expld_url);
if(is_numeric($loanNo)){
 $loan = mysqli_fetch_assoc(mysqli_query($con,"SELECT * FROM loan_applications WHERE loanNo='$loanNo'"));
 $loanid = $loan["id"];
 $custid = $loan["custId"];
 $prodid = $loan["prodId"];
 $seqid = $loan["seqId"];
 $cust = mysqli_fetch_assoc(mysqli_query($con,"SELECT * FROM customers WHERE id='$custid'"));
 $prod = mysqli_fetch_assoc(mysqli_query($con,"SELECT * FROM loan_products WHERE id='$prodid'"));
 $seq = mysqli_fetch_assoc(mysqli_query($con,"SELECT * FROM loan_sequence WHERE id='$seqid'"));
}
else{
  header("Location:".$portal_url."loans");
}
?>
<!DOCTYPE html>
<html lang="en-US">
<head>
<meta charset="UTF-8">
<title>Loan No: <?php echo $loanNo." by ".$cust["first_name"]." ".$cust["last_name"];?>  | Microfinance</title>
<meta name="viewport" content="width=device-width,initial-scale=1">
<link rel="shortcut icon" href="<?php echo $base_url;?>assets/images/logo/favicon.ico">
<link href="<?php echo $base_url;?>assets/bootstrap/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="<?php echo $base_url;?>assets/css/dataTables.bootstrap4.min.css"/>
<link rel="stylesheet" href="<?php echo $base_url;?>assets/fontawesome/css/all.min.css"> 
<link href="<?php echo $base_url;?>assets/css/dashboard.css" rel="stylesheet">
<script src="<?php echo $base_url;?>assets/js/jquery.min.js"></script>
</head>
<body> 
<?php include_once("includes/header.php");?>
<section id="main">
<div class="container-fluid">
 <div class="row">
  <?php include_once("includes/aside.php");?>
  <div class="content">
   <div class="col-md-12">
    <div class="breadcrumbs row">
     <ul class="breadcrumb">
      <li><i class="fas fa-tachometer-alt"></i>&nbsp;Dashboard</li>
      <li><i class="fas fa-hand-holding-usd"></i> &nbsp;&nbsp;Loans</li>
      <li>&nbsp;Loan No: <?php echo $loanNo;?></li>
     </ul>
    </div> 

    <div class="col-md-12 loandiv">
     <div class="row loaninfo">
      <div class="col-md-5">
       <div class="table-responsive">
        <table class="table">
         <tr><td>Loan Number:</td><td><span><?php echo $loan["loanNo"];?></span></td></tr>
         <tr><td>Customer:</td><td><span><a target="_blank" href="<?php echo $portal_url;?>customer/<?php echo $cust["custNo"];?>"><?php echo $cust["first_name"]." ".$cust["last_name"];?></a></span></td></tr>
         <tr><td>Loan Product:</td><td><span><?php echo $prod["name"];?></span></td></tr>
         <tr><td>Loan Sequence:</td><td><span><?php echo $seq["name"];?></span></td></tr>
         <tr><td>Loan Amount:</td><td><span>Ksh <?php echo number_format($loan["amount"],2);?></span></td></tr>
         <tr><td>Amt Payable:</td><td><span>Ksh <?php echo number_format($loan["amount_repayable"],2);?></span></td></tr>
         <tr><td>M-Pesa No.:</td><td><span><?php echo $loan["mpesaNo"];?></span></td></tr>
        </table>
       </div>
      </div>
      <div class="col-md-7 collats">
       <div class="table-responsive">
        <table class="table">
         <thead>
          <tr><th colspan="3">Loan Collaterals</th></tr>
         </thead>
         <tr><th>Item Description</th><th>Serial No.</th><th>Estimate Value</th></tr>
         <?php 
          $chkcollaterals = mysqli_query($con,"SELECT * FROM loan_collaterals WHERE loanId='$loanid' AND description!=''");
          while($row = mysqli_fetch_assoc($chkcollaterals)){ ?>
          <tr><td><span><?php echo $row["description"];?></span></td><td><span><?php echo $row["serialno"];?></span></td><td><span>Ksh <?php echo number_format($row["value"],2);?></span></td></tr>
         <?php } ?>
        </table>
       </div>
      </div>
     </div>


     <div class="row loaninfo">
      <div class="col-md-12 collats">
       <div class="table-responsive">
        <table class="table">
         <thead>
          <tr><th colspan="5">Loan Referees</th></tr>
         </thead>
         <tr><th>Name</th><th>Address</th><th>Phone 1</th><th>Phone 2</th><th>Relationship</th></tr>
         <?php 
          $chkrefs = mysqli_query($con,"SELECT * FROM loan_referees WHERE loanId='$loanid' AND name!=''");
          while($row = mysqli_fetch_assoc($chkrefs)){ ?>
          <tr><td><span><?php echo $row["name"];?></span></td><td><span><?php echo $row["address"];?></span></td><td><span><?php echo $row["phone"];?></span></td><td><span><?php echo $row["phone2"];?></span></td><td><span><?php echo $row["relationship"];?></span></td></tr>
         <?php } ?>
        </table>
       </div>
      </div>
     </div>


     <div class="row loaninfo">
      <div class="col-md-12 collats">
       <div class="table-responsive">
        <table class="table">
         <thead>
          <tr><th colspan="7">Loan Guarantors</th></tr>
         </thead>
         <tr><th>Name</th><th>Relationship</th><th>Phone 1</th><th>Phone 2</th><th>Occupation</th><th>Residence</th><th>Landmark</th></tr>
         <?php 
          $chkgurantors = mysqli_query($con,"SELECT * FROM loan_guarantors WHERE loanId='$loanid' AND name!=''");
          while($row = mysqli_fetch_assoc($chkgurantors)){ ?>
          <tr><td><span><?php echo $row["name"];?></span></td><td><span><?php echo $row["relationship"];?></span></td><td><span><?php echo $row["phone"];?></span></td><td><span><?php echo $row["phone2"];?></span></td><td><span><?php echo $row["occupation"];?></span></td><td><span><?php echo $row["residence"];?></span></td><td><span><?php echo $row["landmark"];?></span></td></tr>
         <?php } ?>
        </table>
       </div>
      </div>
     </div>

     <div class="row bfa">
      <div class="col-md-12 titlediv">
       <h3>Business Information Analysis</h3>
      </div>
      <div class="col-md-4">
       <div class="table-responsive">
        <table class="table">
         <tr><td>Income:</td><td><span>Ksh <?php echo number_format($loan["bfa_income"],2);?></span></td></tr>
         <tr><td>Total daily sales:</td><td><span>Ksh <?php echo number_format($loan["bfa_dailysales"],2);?></span></td></tr>
         <tr><td>Comm: monthly sales:</td><td><span>Ksh <?php echo number_format($loan["bfa_monthlysales"],2);?></span></td></tr>
         <tr><td>Less cost of sales:</td><td><span>Ksh <?php echo number_format($loan["bfa_costofsales"],2);?></span></td></tr>
        </table>
       </div>
      </div>
      <div class="col-md-4">
       <div class="table-responsive">
        <table class="table">
         <tr><td>Gross profit(A):</td><td><span>Ksh <?php echo number_format($loan["bfa_grossprofit"],2);?></span></td></tr>
         <tr><td>Income from other sources:</td><td><span>Ksh <?php echo number_format($loan["bfa_otherincome"],2);?></span></td></tr>
         <tr><td>Total cumm incomes (B):</td><td><span>Ksh <?php echo number_format($loan["bfa_cummincome"],2);?></span></td></tr>
         <tr><td>Expenditure patterns(C):</td><td><span>Ksh <?php echo number_format($loan["bfa_expenditure"],2);?></span></td></tr>
        </table>
       </div>
      </div>
      <div class="col-md-4">
       <div class="table-responsive">
        <table class="table">
         <tr><td>Total net income (B-C):</td><td><span>Ksh <?php echo number_format($loan["bfa_ttlnetincome"],2);?></span></td></tr>
         <tr><td>Less loan installment:</td><td><span>Ksh <?php echo number_format($loan["bfa_lessinstallments"],2);?></span></td></tr>
         <tr><td>Net income after loan installment:</td><td><span>Ksh <?php echo number_format($loan["bfa_netincome"],2);?></span></td></tr>
        </table>
       </div>
      </div>
     </div>
    </div>
   </div> 

   </div>
  </div>
 </div>
</div>
</section>
<script src="<?php echo $base_url;?>assets/bootstrap/bootstrap.min.js"></script>
<script src="<?php echo $base_url;?>assets/js/dashboard.js"></script>
<script src="<?php echo $base_url;?>assets/js/jquery.dataTables.min.js"></script>
<script src="<?php echo $base_url;?>assets/js/dataTables.bootstrap4.min.js"></script>
<script>
$(function(){
 $("#lnapp").attr("class","active");
 });
</script>
</body>
</html>