<?php
ob_start();
session_start();
include_once("../config/index.php");
include_once("includes/auth.php");

// current month default (YYYY-MM)
$sel_month = isset($_GET['month']) ? trim($_GET['month']) : date('Y-m');
if (!preg_match('/^\d{4}-\d{2}$/', $sel_month)) {
    $sel_month = date('Y-m');
}

// compute first and last day of month
$start_date = $sel_month . "-01";
$end_date = date("Y-m-t", strtotime($start_date)); // e.g. 2025-02-28

// full datetime bounds
$start_datetime = $start_date . " 00:00:00";
$end_datetime   = $end_date   . " 23:59:59";

// branch filter - reusing $branchid from session / includes like your other page
// Ensure $branchid exists; otherwise skip branch filter (defensive)
$branch_filter_sql = "";
if (isset($branchid) && is_numeric($branchid)) {
    $branch_filter_sql = "AND u.branchId = '".mysqli_real_escape_string($con, $branchid)."'";
}

// Fetch POS-CASH repayments for the month, joined to loan and customer info
$q = "
SELECT lr.id AS repay_id,
       lr.loanId AS loan_app_id,
       la.loanNo AS loanNo,
       lr.amount,
       lr.paymode,
       lr.txncode,
       lr.created_at,
       lr.updated_at,
       lr.reason,
       la.userId AS loan_userId,
       la.custId AS loan_custId,
       c.first_name, c.middle_name, c.last_name,
       u.branchId
FROM loan_repayments lr
LEFT JOIN loan_applications la ON lr.loanId = la.id
LEFT JOIN users u ON la.userId = u.id
LEFT JOIN customers c ON la.custId = c.id
WHERE lr.paymode = 'POS-CASH'
  AND lr.created_at BETWEEN '".mysqli_real_escape_string($con, $start_datetime)."' AND '".mysqli_real_escape_string($con, $end_datetime)."'
  $branch_filter_sql
ORDER BY lr.id DESC
";

$res = mysqli_query($con, $q) or die("Error fetching POS data: ".mysqli_error($con));

// compute total
$total_q = "
SELECT SUM(lr.amount) AS total_amount
FROM loan_repayments lr
LEFT JOIN loan_applications la ON lr.loanId = la.id
LEFT JOIN users u ON la.userId = u.id
WHERE lr.paymode = 'POS-CASH'
  AND lr.created_at BETWEEN '".mysqli_real_escape_string($con, $start_datetime)."' AND '".mysqli_real_escape_string($con, $end_datetime)."'
  $branch_filter_sql
";
$total_row = mysqli_fetch_assoc(mysqli_query($con, $total_q));
$total_amount = $total_row['total_amount'];
if ($total_amount === null) $total_amount = 0;

?>
<!DOCTYPE html>
<html lang="en-US">
<head>
<meta charset="UTF-8">
<title>POS Monthly Report | Kuza Work Africa</title>
<meta name="viewport" content="width=device-width,initial-scale=1">
<link rel="shortcut icon" href="<?php echo $base_url;?>assets/images/logo/favicon.ico">
<link href="<?php echo $base_url;?>assets/bootstrap/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="<?php echo $base_url;?>assets/css/dataTables.bootstrap4.min.css"/>
<link rel="stylesheet" href="<?php echo $base_url;?>assets/css/buttons.bootstrap4.min.css"/>
<link rel="stylesheet" href="<?php echo $base_url;?>assets/fontawesome/css/all.min.css"> 
<link href="<?php echo $base_url;?>assets/css/dashboard.css" rel="stylesheet">
<script src="<?php echo $base_url;?>assets/js/jquery.min.js"></script>
<style>
/* small additional styling */
.report-top {
  margin-bottom: 15px;
  display:flex;
  align-items:center;
  justify-content:space-between;
  gap:10px;
}
.report-controls { display:flex; gap:8px; align-items:center; }
.total-box { font-weight:700; font-size:1.1rem; }
</style>
</head>
<body> 
<?php include_once("includes/header.php");?>
<section id="main">
<div class="container-fluid">
 <div class="row">
   <?php include_once("includes/aside.php");?>
   <div class="content">
    <div class="col-md-12">
     <div class="breadcrumbs row">
      <ul class="breadcrumb">
       <li><i class="fas fa-tachometer-alt"></i>&nbsp;Dashboard</li>
       <li><i class="fas fa-cash-register"></i> &nbsp;&nbsp;POS Monthly Report</li>
      </ul>
    </div>

     <div class="panel panel-default">
       <div class="panel-header dvtitle">POS Monthly Report</div>
       <div class="panel-body">

        <div class="report-top">
          <div class="report-controls">
            <form id="monthFilterForm" method="get" action="">
              <label for="month">Select month:&nbsp;</label>
              <input type="month" id="month" name="month" value="<?php echo htmlspecialchars($sel_month); ?>">
              <button class="btn btn-primary btn-sm" type="submit"><i class="fas fa-filter"></i> Filter</button>
              <a href="<?php echo basename(__FILE__); ?>" class="btn btn-secondary btn-sm" style="margin-left:6px;"><i class="fas fa-redo"></i> Reset</a>
            </form>
          </div>

          <div class="total-box">
            Total (<?php echo date("F Y", strtotime($start_date)); ?>): Ksh. <?php echo number_format($total_amount, 2); ?>
          </div>
        </div>

        <div class="table-responsive row">
        <table id="tb_pos" class="table table-striped table-bordered" cellspacing="0" width="100%">
         <thead>
           <tr>
             <th>Loan No.</th>
             <th>Amount</th>
             <th>Paymode</th>
             <th>Txn Code</th>
             <th>Created At</th>
             <th>Customer</th>
           </tr>
         </thead>
         <tbody>
           <?php while($r = mysqli_fetch_assoc($res)) {
             $custname = trim($r['first_name'].' '.$r['middle_name'].' '.$r['last_name']);
             ?>
             <tr>
               <td><?php echo htmlspecialchars($r['loanNo']); ?></td>
               <td><?php echo htmlspecialchars(number_format((float)$r['amount'],2)); ?></td>
               <td><?php echo htmlspecialchars($r['paymode']); ?></td>
               <td><?php echo htmlspecialchars($r['txncode']); ?></td>
               <td><?php echo htmlspecialchars(date("d/m/Y H:i:s",strtotime($r['created_at']))); ?></td>
               <td><?php echo htmlspecialchars($custname); ?></td>
             </tr>
           <?php } ?>
         </tbody>
       </table>
      </div>
    </div>
   </div>

  </div>
 </div>
</div>
</div>
</section>

<script src="<?php echo $base_url;?>assets/bootstrap/bootstrap.min.js"></script>
<script src="<?php echo $base_url;?>assets/js/dashboard.js"></script>
<script src="<?php echo $base_url;?>assets/js/jquery.dataTables.min.js"></script>
<script src="<?php echo $base_url;?>assets/js/dataTables.bootstrap4.min.js"></script>
<?php include_once("includes/buttons.php");?>

<script>
$(function(){
  // highlight menu - change id if needed
  $("#pos-report").attr("class","active"); // ensure your aside has matching id if you want highlight

  var table = $('#tb_pos').DataTable({
    lengthChange: false,
    "aaSorting": [],
    "buttons": [
      {"extend": 'copy', "text":'<i class="fas fa-copy"></i> Copy',"className": 'btn btn-success btn-sm'},
      {"extend": 'csv', "text":'<i class="fas fa-file-csv"></i> CSV',"className": 'btn btn-success btn-sm'},
      {"extend": 'excel', "text":'<i class="fas fa-file-excel"></i> Excel',"className": 'btn btn-success btn-sm'},
      {"extend": 'pdf', "text":'<i class="fas fa-file-pdf"></i> PDF',"className": 'btn btn-success btn-sm'},
      {"extend": 'print', "text":'<i class="fas fa-print"></i> Print',"className": 'btn btn-success btn-sm'}
    ],
    "columnDefs": [
      { "orderable": false, "targets": [] } // make any columns not sortable if desired
    ]
  });
  table.buttons().container().appendTo('#tb_pos_wrapper .col-md-6:eq(0)');
});
</script>
</body>
</html>
