<?php
ob_start();
session_start();
include_once("../config/index.php");
include_once("includes/auth.php");
$now = date('Y-m-d H:i:s');
?>
<!DOCTYPE html>
<html lang="en-US">
<head>
<meta charset="UTF-8">
<title>Customers | Kuza Work Africa</title>
<meta name="viewport" content="width=device-width,initial-scale=1">
<link rel="shortcut icon" href="<?php echo $base_url;?>assets/images/logo/favicon.ico">
<link href="<?php echo $base_url;?>assets/bootstrap/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="<?php echo $base_url;?>assets/css/dataTables.bootstrap4.min.css"/>
<link rel="stylesheet" href="<?php echo $base_url;?>assets/css/buttons.bootstrap4.min.css"/>
<link rel="stylesheet" href="<?php echo $base_url;?>assets/fontawesome/css/all.min.css"> 
<link href="<?php echo $base_url;?>assets/css/dashboard.css" rel="stylesheet">
<script src="<?php echo $base_url;?>assets/js/jquery.min.js"></script>
</head>
<body> 
<?php include_once("includes/header.php");?>
<section id="main">
<div class="container-fluid">
 <div class="row">
  <?php include_once("includes/aside.php");?>
  <div class="content">
   <div class="col-md-12">
    <div class="breadcrumbs row">
     <ul class="breadcrumb">
      <li><i class="fas fa-tachometer-alt"></i>&nbsp;Dashboard</li>
      <li><i class="fas fa-chart-line"></i> &nbsp;&nbsp;Customers</li>
     </ul>
    </div>

    <div class="row wrapper">
      <button class="btn item" data-dismiss="modal" data-toggle="modal" data-target="#filtermodal"><i class="far fa-calendar-alt"></i> Filter by Date</button>
    </div>

    <div class="row report">
     <div class="col-md-12 summary">
     <p>Total Customers: <span><?php echo number_format(mysqli_fetch_assoc(mysqli_query($con,"SELECT COUNT(*) AS allcust FROM customers WHERE branchId='$branchid'"))["allcust"]);?></span></p>
     <p>Period: <span>All Time</span></p>
     </div>
     <div class="col-md-12">
      <div class="table-responsive">
     <table id="tb_disb" class="table table-striped table-bordered" cellspacing="0" width="100%">
      <thead>
                       <tr><th>Cust No.</th><th>Name</th><th>Phone</th><th>Email</th><th>Id No</th><th>Branch</th><th>Reg Fee</th><th>Reg Date</th><th style="min-width: 100px;">Action</th></tr>
                      </thead>
                       <tbody>
                         <?php
                         $chkcustomers = mysqli_query($con,"SELECT * FROM customers WHERE branchId='$branchid' ORDER BY id DESC");
                         while($row = mysqli_fetch_assoc($chkcustomers)){
                         $custid = $row["id"];
                         $custno = $row["custNo"];
                         $loancount = mysqli_num_rows(mysqli_query($con,"SELECT * FROM loan_applications WHERE custId='$custid'")); ?>
                         <tr>
                          <td><?php echo $row["custNo"];?></td>
                          <td><?php echo $row["first_name"]." ".$row["middle_name"]." ".$row["last_name"];?></td>
                          <td><?php echo $row["phone"];?></td>
                          <td><?php echo $row["email"];?></td>
                          <td><?php echo $row["idNo"] ?></td>
                          <td>
                          <?php 
                           $branchid = $row["branchId"];
                           echo mysqli_fetch_assoc(mysqli_query($con,"SELECT * FROM branches WHERE id='$branchid'"))["name"];
                          ?>
                          </td>
                          <td>Ksh <?php echo $row["reg_fee"];?></td>
                          <td><?php echo date("d M Y",strtotime($row["created_at"]));?></td>
                           <td>
                            <a target="_blank" href="<?php echo $portal_url;?>pdf/borrower-report?custNo=<?php echo $row["custNo"];?>"><button class="btn btn-xs btn-info" data-toggle="tooltip" data-placement="bottom" title="Print statement"><i class="fas fa-file-pdf"></i></button></a>   
                           <a href="<?php echo $portal_url;?>customer/<?php echo $row["custNo"];?>"><button class="btn btn-xs btn-success" data-toggle="tooltip" data-placement="bottom" title="View customer profile"><i class="fas fa-search-plus"></i></button></a>
                           <button class="btn btn-xs btn-primary edtcust" data-toggle="tooltip" data-placement="bottom" title="Edit Customer" data-id="<?php echo $row["id"];?>" data-turnover="<?php echo $row["turnover"];?>" data-placeofresidence="<?php echo $row["placeofresidence"];?>" data-nextofkindob="<?php echo $row["nextofkindob"];?>" data-nextofkincontact="<?php echo $row["nextofkincontact"];?>" data-nextofkinname="<?php echo $row["nextofkinname"];?>" data-fname="<?php echo $row["first_name"];?>" data-mname="<?php echo $row["middle_name"];?>" data-lname="<?php echo $row["last_name"];?>" data-phone="<?php echo $row["phone"];?>" data-email="<?php echo $row["email"];?>" data-ro="<?php echo $row["roId"];?>" data-phone2="<?php echo $row["phone2"];?>" data-idtype="<?php echo $row["idType"];?>" data-idno="<?php echo $row["idNo"];?>" data-dob="<?php echo $row["dob"];?>" data-gender="<?php echo $row["gender"];?>" data-nickname="<?php echo $row["nickname"];?>" data-maritalstatus="<?php echo $row["maritalstatus"];?>" data-dependants="<?php echo $row["dependants"];?>" data-residenceperiod="<?php echo $row["residence_period"];?>" data-town="<?php echo $row["town"];?>" data-estate="<?php echo $row["estate"];?>" data-houseno="<?php echo $row["house_no"];?>" data-ownership="<?php echo $row["residence_ownership"];?>" data-landmark="<?php echo $row["landmark"];?>" data-ruralcounty="<?php echo $row["rural_county"];?>" data-ruraltown="<?php echo $row["rural_town"];?>" data-ruralvillage="<?php echo $row["rural_village"];?>" data-rurallandmark="<?php echo $row["rural_landmark"];?>" data-spousename="<?php echo $row["spouse_name"];?>" data-spouseid="<?php echo $row["spouse_id"];?>" data-spousephone="<?php echo $row["spousephone"];?>" data-spouseoccupation="<?php echo $row["spouse_occupation"];?>" data-lead="<?php echo $row["lead"];?>" data-otherlead="<?php echo $row["other_lead"];?>" data-bsname="<?php echo $row["business_name"];?>" data-bsnature="<?php echo $row["business_nature"];?>" data-bsage="<?php echo $row["business_age"];?>" data-bstype="<?php echo $row["business_type"];?>" data-bsaddress="<?php echo $row["business_address"];?>" data-bstown="<?php echo $row["business_town"];?>" data-bslocation="<?php echo $row["business_location"];?>" data-bslandmark="<?php echo $row["business_landmark"];?>" data-bsstreet="<?php echo $row["business_street"];?>" data-bsbuilding="<?php echo $row["business_building"];?>" data-bsphone="<?php echo $row["business_phone"];?>" data-bslicence="<?php echo $row["business_licence"];?>" data-bspin="<?php echo $row["business_pin"];?>"><i class="fas fa-pencil-alt"></i></button>
                           <?php if($loancount < 1){ ?>
                           <button class="btn btn-xs btn-danger delcust" id="<?php echo $row["id"];?>" data-toggle="tooltip" data-placement="bottom" title="Delete Customer"><i class="fa fa-trash"></i></button>
                          <?php } ?>
                          </td>
                         </tr>
                         <?php }
                        ?>
                     </tbody>
     </table>
    </div>
     </div>
    </div>

     <div id="filtermodal" class="modal fade" role="dialog">
       <div class="modal-dialog">
       <div class="modal-content">
        <h3><i class="far fa-calendar-alt"></i> Customized Duration Report<span class="close pull-right" data-dismiss="modal"><i class="fas fa-times"></i></span></h3>
        <form role="form" id="filterform">
          <div class="col-md-6">
           <div class="form-group">
            <label>Start Date <span>*</span></label>
            <input type="date" class="form-control" id="date1" required>
           </div>
          </div>
          <div class="col-md-6">
           <div class="form-group">
            <label>End Date <span>*</span></label>
            <input type="date" class="form-control" id="date2" required>
           </div>
          </div>
          <div class="form-group">
           <button class="btn btn-block" type="submit"><i class="fa fa-save"></i> Show Report</button>
          </div>
          <div class="form-group">
           <div id="filterstatus"></div>
          </div>
         </form>
        </div>
       </div>
      </div>

   </div>
  </div>
 </div>
</div>
</div>
</section>
<script src="<?php echo $base_url;?>assets/bootstrap/bootstrap.min.js"></script>
<script src="<?php echo $base_url;?>assets/js/dashboard.js"></script>
<script src="<?php echo $base_url;?>assets/js/jquery.dataTables.min.js"></script>
<script src="<?php echo $base_url;?>assets/js/dataTables.bootstrap4.min.js"></script>
<?php include_once("includes/buttons.php");?>
<script>
$(function(){
 $("#rptcust").attr("class","active");
 function dataTables(tb){
 var table = $('#'+tb+'').DataTable({
  lengthChange: false,
  "aaSorting": [],
  "buttons": [
  {"extend": 'copy', "text":'<i class="fas fa-copy"></i> Copy',"className": 'btn btn-success btn-sm'},
  {"extend": 'csv', "text":'<i class="fas fa-file-csv"></i> CSV',"className": 'btn btn-success btn-sm'},
  {"extend": 'excel', "text":'<i class="fas fa-file-excel"></i> Excel',"className": 'btn btn-success btn-sm' },
  {"extend": 'pdf', "text":'<i class="fas fa-file-pdf"></i> PDF',"className": 'btn btn-success btn-sm'},
  {"extend": 'print', "text":'<i class="fas fa-print"></i> Print',"className": 'btn btn-success btn-sm'}
  ]
 }); 
 table.buttons().container().appendTo( '#'+tb+'_wrapper .col-md-6:eq(0)' );
 }
 dataTables("tb_disb");

  //Custom duration report
  $("#filterform").submit(function(e){
   e.preventDefault();
   var date1 = $("#date1").val();
   var date2 = $("#date2").val();
   $("#filterform .btn").attr("disabled","disabled");
   $("#filterstatus").html("<p class='alert alert-success' style='padding:10px;'><i class='fa fa-spinner fa-pulse'></i> Please wait....</p>");
   $.ajax({
    type: "POST",
    url: $("#portal_url").html()+"reports/customers",
    data: {
      date1:date1,
      date2:date2
    },
    cache: false
   }).done(function(data){
    $("#filterform .btn").removeAttr("disabled");
    $("#filterstatus").html("");
    $(".report").html(data);
    $('#filtermodal').modal('toggle');
    dataTables("tb_disb");
   });
  });
});
 </script>
</body>
</html>