<?php
ob_start();
session_start();
include_once("../config/index.php");
include_once("includes/auth.php");
$now = date('Y-m-d H:i:s');
$datetoday=date("Y-m-d");

?>
<!DOCTYPE html>
<html lang="en-US">
<head>
<meta charset="UTF-8">
<title>Income Report | Kuza Work Africa</title>
<meta name="viewport" content="width=device-width,initial-scale=1">
<link rel="shortcut icon" href="<?php echo $base_url;?>assets/images/logo/favicon.ico">
<link href="<?php echo $base_url;?>assets/bootstrap/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="<?php echo $base_url;?>assets/css/dataTables.bootstrap4.min.css"/>
<link rel="stylesheet" href="<?php echo $base_url;?>assets/css/buttons.bootstrap4.min.css"/>
<link rel="stylesheet" href="<?php echo $base_url;?>assets/fontawesome/css/all.min.css"> 
<link href="<?php echo $base_url;?>assets/css/dashboard.css" rel="stylesheet">
<script src="<?php echo $base_url;?>assets/js/jquery.min.js"></script>
</head>
<body> 
<?php include_once("includes/header.php");?>
<section id="main">
<div class="container-fluid">
 <div class="row">
  <?php include_once("includes/aside.php");?>
  <div class="content">
   <div class="col-md-12">
    <div class="breadcrumbs row">
     <ul class="breadcrumb">
      <li><i class="fas fa-tachometer-alt"></i>&nbsp;Dashboard</li>
      <li><i class="fas fa-chart-line"></i> &nbsp;&nbsp;Income Report</li>
     </ul>
    </div>

    <div class="row wrapper">
      <button class="btn item" data-dismiss="modal" data-toggle="modal" data-target="#filtermodal"><i class="far fa-calendar-alt"></i> Filter by Date</button>
    </div>

    <div class="row report">
     <div class="col-md-12 summary">
     <p style="display:none">Total Daily Expected: <span>Ksh <?php //echo number_format(mysqli_fetch_assoc(mysqli_query($con,"SELECT SUM(installement) AS amt FROM repayment_schedule WHERE repayment_date='$datetoday'"))["amt"]);?></span></p>
     <p>Period: <span>As of <?php echo date("d M Y") ?></span></p>
     </div>
     <div class="col-md-12">
      <div class="table-responsive">
     <table id="tb_coll" class="table table-striped table-bordered" cellspacing="0" width="100%">
         <thead>
             <th></th><th></th>
         </thead>
        <tbody>
       <tr><th>Interest on Loan</th><td>Ksh. <?php  $interest = 0;
        $chkloans = mysqli_query($con,"SELECT * FROM loan_applications,users WHERE status='4' AND loan_applications.userId=users.id AND users.branchId='$branchid'");
        while($row = mysqli_fetch_assoc($chkloans)){
         if($row["amt_repaid"] > ($row["amount_repayable"]-$row["amount"])){
          $interest += $row["amount_repayable"]-$row["amount"];
         }
         else{
          $interest += $row["amt_repaid"];
         }
        }
        echo $interest?></td></tr>
        
        <tr><th>Interest on Chap Chap Loan</th><td>Ksh. <?php  
        $interestch = 0;
        $chkloans = mysqli_query($con,"SELECT * FROM chapchaploan_applications,users WHERE status='4' AND chapchaploan_applications.userId=users.id AND users.branchId='$branchid'");
        while($row = mysqli_fetch_assoc($chkloans)){
         if($row["amt_repaid"] > ($row["amount_repayable"]-$row["amount"])){
          $interestch += $row["amount_repayable"]-$row["amount"];
         }
         else{
          $interestch += $row["amt_repaid"];
         }
        }
        echo $interestch?></td></tr>
       <tr><th>Excise Duty fee</th><td>Ksh. <?php  $totalloanfee=mysqli_fetch_assoc(mysqli_query($con,"SELECT SUM(loan_fee) AS totalloanfee FROM loan_applications,users WHERE status='4' AND loan_applications.userId=users.id AND users.branchId='$branchid'"))["totalloanfee"]; if($totalloanfee==NULL){echo $totalloanfee=0;}else{ echo $totalloanfee; } ?></td></tr>
        <tr><th>Processing Fee</th><td>Ksh. <?php  $totalpfee=mysqli_fetch_assoc(mysqli_query($con,"SELECT SUM(disburse_fee) AS totalpfee FROM loan_applications,users WHERE status='4' AND loan_applications.userId=users.id AND users.branchId='$branchid'"))["totalpfee"]; if($totalpfee==NULL){echo $totalpfee=0;}else{ echo $totalpfee; } ?></td></tr>
        <tr><th>Processing Fee Chap Chap</th><td>Ksh. <?php  $totalpfeech=mysqli_fetch_assoc(mysqli_query($con,"SELECT SUM(disburse_fee) AS totalpfee FROM chapchaploan_applications,users WHERE status='4' AND chapchaploan_applications.userId=users.id AND users.branchId='$branchid'"))["totalpfee"]; if($totalpfeech==NULL){echo $totalpfeech=0;}else{ echo $totalpfeech; } ?></td></tr>
       <tr><th>Registration Fees</th><td>Ksh. <?php  $totalregfee=mysqli_fetch_assoc(mysqli_query($con,"SELECT SUM(reg_fee) AS totalregfee FROM customers WHERE branchId='$branchid'"))["totalregfee"]; if($totalregfee==NULL){echo $totalregfee=0;}else{ echo $totalregfee; } ?></td></tr>
       <tr><th>Activation Fees</th><td>Ksh. <?php  $totalactfee=mysqli_fetch_assoc(mysqli_query($con,"SELECT SUM(amount) AS actfee FROM activationfee"))["actfee"]; if($totalactfee==NULL){echo $totalactfee=0;}else{ echo $totalactfee; } ?></td></tr>
       <tr><th>Follow up Fees</th><td>Ksh. <?php  $totalfollowfee=mysqli_fetch_assoc(mysqli_query($con,"SELECT SUM(amount) AS followupfee FROM followup"))["followupfee"]; if($totalfollowfee==NULL){echo $totalfollowfee=0;}else{ echo $totalfollowfee; } ?></td></tr>
       <tr><th>Penalties</th><td>Ksh. <?php  $totalpenalty=mysqli_fetch_assoc(mysqli_query($con,"SELECT SUM(amount) AS totalpenalty FROM penalties_paid WHERE custid='1'"))["totalpenalty"]; if($totalpenalty==NULL){echo $totalpenalty=0;}else{ echo $totalpenalty; } ?></td></tr>
       <tr><th>Topup Fee</th><td>Ksh. <?php  $totaltpfee=mysqli_fetch_assoc(mysqli_query($con,"SELECT SUM(amount) AS totalpenalty FROM topup_penalty,customers WHERE topup_penalty.custid=customers.id AND customers.branchId='$branchid'"))["totalpenalty"]; if($totaltpfee==NULL){echo $totaltpfee=0;}else{ echo $totaltpfee; } ?></td></tr>
       <tr><th>Other Incomes</th><td>Ksh. 0</td></tr>
       <tr><th>Expenses</th><td>Ksh. <?php echo $expenses=mysqli_fetch_assoc(mysqli_query($con,"SELECT SUM(amount) as expamount FROM expenses WHERE branchId='$branchid'"))['expamount'] ?></td></tr>
       <tr>
           <th>Roll over fee</th>
           <td>
              Ksh. <?php echo $rolloverfee=mysqli_fetch_assoc(mysqli_query($con,"SELECT COALESCE(SUM(r.amount), 0) AS rollover_income FROM rolloverfee r JOIN loan_applications l ON r.loanno = l.loanNo JOIN customers c ON r.custid = c.id WHERE l.amt_repaid >= l.amount_repayable AND l.status = '4' AND c.branchId = '$branchid'"))['rollover_income']; ?>
           </td>
       </tr>
       <tr><th colspan="2"></th></tr>
       <tr><th>Total Operating Income</th><td>Ksh. <?php echo number_format($interest+$interestch+$totalpfeech+$totalloanfee+$totalpfee+$totalregfee+$totalpenalty+$totalactfee+$totalfollowfee+$totaltpfee+$rolloverfee-$expenses,2) ?></td></tr>
      </tbody>
      
     </table>
    </div>
     </div>
    </div>

     <div id="filtermodal" class="modal fade" role="dialog">
       <div class="modal-dialog">
       <div class="modal-content">
        <h3><i class="far fa-calendar-alt"></i> Customized Duration Report<span class="close pull-right" data-dismiss="modal"><i class="fas fa-times"></i></span></h3>
        <form role="form" id="filterform">
          <div class="col-md-6">
           <div class="form-group">
            <label>Start Date <span>*</span></label>
            <input type="date" class="form-control" id="date1" required>
           </div>
          </div>
          <div class="col-md-6">
           <div class="form-group">
            <label>End Date <span>*</span></label>
            <input type="date" class="form-control" id="date2" required>
           </div>
          </div>
          <div class="form-group">
           <button class="btn btn-block" type="submit"><i class="fa fa-save"></i> Show Report</button>
          </div>
          <div class="form-group">
           <div id="filterstatus"></div>
          </div>
         </form>
        </div>
       </div>
      </div>

   </div>
  </div>
 </div>
</div>
</div>
</section>
<script src="<?php echo $base_url;?>assets/bootstrap/bootstrap.min.js"></script>
<script src="<?php echo $base_url;?>assets/js/dashboard.js"></script>
<script src="<?php echo $base_url;?>assets/js/jquery.dataTables.min.js"></script>
<script src="<?php echo $base_url;?>assets/js/dataTables.bootstrap4.min.js"></script>
<?php include_once("includes/buttons.php");?>
<script>
$(function(){
 $("#income").attr("class","active");
 function dataTables(tb){
 var table = $('#'+tb+'').DataTable({
  lengthChange: false,
  "aaSorting": [],
  "buttons": [
  {"extend": 'copy', "text":'<i class="fas fa-copy"></i> Copy',"className": 'btn btn-success btn-sm'},
  {"extend": 'csv', "text":'<i class="fas fa-file-csv"></i> CSV',"className": 'btn btn-success btn-sm'},
  {"extend": 'excel', "text":'<i class="fas fa-file-excel"></i> Excel',"className": 'btn btn-success btn-sm' },
  {"extend": 'pdf', "text":'<i class="fas fa-file-pdf"></i> PDF',"className": 'btn btn-success btn-sm'},
  {"extend": 'print', "text":'<i class="fas fa-print"></i> Print',"className": 'btn btn-success btn-sm'}
  ]
 }); 
 table.buttons().container().appendTo( '#'+tb+'_wrapper .col-md-6:eq(0)' );
 }
 dataTables("tb_coll");

});

//Custom duration report
  $("#filterform").submit(function(e){
   e.preventDefault();
   var date1 = $("#date1").val();
   var date2 = $("#date2").val();
   $("#filterform .btn").attr("disabled","disabled");
   $("#filterstatus").html("<p class='alert alert-success' style='padding:10px;'><i class='fa fa-spinner fa-pulse'></i> Please wait....</p>");
   $.ajax({
    type: "POST",
    url: $("#portal_url").html()+"reports/income",
    data: {
      date1:date1,
      date2:date2,
      prod:"0"
    },
    cache: false
   }).done(function(data){
    $("#filterform .btn").removeAttr("disabled");
    $("#filterstatus").html("");
    $(".report").html(data);
    $('#filtermodal').modal('toggle');
    dataTables("tb_coll");
   });
  });

 </script>
</body>
</html>