<?php
ob_start();
session_start();
ini_set('display_errors', 1); 
ini_set('display_startup_errors', 1); 
error_reporting(E_ALL);
include_once("../config/index.php");
include_once("includes/auth.php");
$now = date('Y-m-d H:i:s');
?>
<!DOCTYPE html>
<html lang="en-US">
<head>
<meta charset="UTF-8">
<title>Outstanding Loan Balance Anaysis | Kuza Fine Africa</title>
<meta name="viewport" content="width=device-width,initial-scale=1">
<link rel="shortcut icon" href="<?php echo $base_url;?>assets/images/logo/favicon.ico">
<link href="<?php echo $base_url;?>assets/bootstrap/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="<?php echo $base_url;?>assets/css/dataTables.bootstrap4.min.css"/>
<link rel="stylesheet" href="<?php echo $base_url;?>assets/css/buttons.bootstrap4.min.css"/>
<link rel="stylesheet" href="<?php echo $base_url;?>assets/fontawesome/css/all.min.css"> 
<link href="<?php echo $base_url;?>assets/css/dashboard.css" rel="stylesheet">
<script src="<?php echo $base_url;?>assets/js/jquery.min.js"></script>
</head>
<body> 
<?php include_once("includes/header.php");?>
<section id="main">
<div class="container-fluid">
 <div class="row">
  <?php include_once("includes/aside.php");?>
  <div class="content">
   <div class="col-md-12">
    <div class="breadcrumbs row">
     <ul class="breadcrumb">
      <li><i class="fas fa-tachometer-alt"></i>&nbsp;Dashboard</li>
      <li><i class="fas fa-chart-line"></i> &nbsp;&nbsp;OLB Analysis</li>
     </ul>
    </div>

    <div class="row wrapper">
      <button style="display:none" class="btn item" data-dismiss="modal" data-toggle="modal" data-target="#filtermodal"><i class="far fa-calendar-alt"></i> Filter by Date & Officer</button>
    </div>

    <div class="row report">
     <div class="col-md-12 summary">
     <p>Period: <span>All Time</span></p>
     </div>
     <div class="col-md-12">
      <div class="table-responsive">
     <table id="tb_olb" class="table table-striped table-bordered" cellspacing="0" style="width: 1500px;">
      <thead>
       <tr><th>Loan No.</th><th>Client Name</th><th>Phone No.</th><th>Principal Amount Borrowed</th><th>Interest Charged</th>
       <th>Total amount repayable</th><th style="display:none">Expected Installment</th><th>Amount Paid</th><th>Principal Paid</th><th>Interest Paid</th>
       <th>Principal Balance</th><th>Prepayments/Arrears</th><th>Portfolio in Arrears</th></tr>
      </thead>
      <tbody>
      <?php
       $chkloans = mysqli_query($con,"SELECT * FROM loan_applications WHERE status='4' AND amount_repayable > amt_repaid ORDER BY id DESC");
       $amountborrowed=0;
       $sumprincipalpaid=0;
       $sumprincipalbalance=0;
       $sumportfolio=0;
       while($row = mysqli_fetch_assoc($chkloans)){
        $loanid = $row["id"];
        $amountborrowed+=$row["amount"];
        $loanprodId=$row["prodId"];
        $seqId=$row["seqId"];
        $balance = $scheduled = 0;
        $loanage = floor((strtotime(date("Y-m-d H:i:s"))-strtotime($row["disbursed_at"]))/86400); ?>
        <tr>
         <td><?php echo $row["loanNo"];?></td>
         <td>
          <?php
           $custid = $row["custId"];
           $cust = mysqli_fetch_assoc(mysqli_query($con,"SELECT * FROM customers WHERE id='$custid'"));
           echo $cust["first_name"]." ".$cust["middle_name"]." ".$cust["last_name"];
           
          ?>
         </td>
         <td><?php echo $cust["phone"]; ?></td>
         <td>Ksh. <?php echo number_format($row["amount"]); ?></td>
         <td>Ksh. <?php echo number_format($row["amount_repayable"]-$row["amount"]); ?></td>
         <td>Ksh. <?php echo number_format($row["amount_repayable"]); ?></td>
         
          <td style="display:none">Ksh 
          <?php
        //   $thisweek=mysqli_query($con,"SELECT * FROM repayment_schedule WHERE loanId='$loanid' AND YEARWEEK(repayment_date)=YEARWEEK(NOW())");
        //   if(mysqli_num_rows($thisweek)>0){
        //   $tw=mysqli_fetch_assoc($thisweek);
        //       $installement=$tw["installement"];
        //       $status=$tw["status"];
        //       $amountrepaid=$tw["amountrepaid"];
        //       echo $installement;
               
            //   if($status=="1"){
            //       echo "-".$amountrepaid; 
            //   }else{
            //      echo $installement;  
            //   }
        //   }else{
        //       echo $installement =0;
        //   }
        //   $arrear = $amount_due-$row["amt_repaid"];
        //   echo number_format($arrear);
          ?>
         </td>
         <td>
             Ksh. 
             <?php $repaid=mysqli_fetch_assoc(mysqli_query($con,"SELECT SUM(amount) AS amountpaid FROM loan_repayments WHERE loanId='$loanid' AND YEARWEEK(created_at)=YEARWEEK(NOW())"))["amountpaid"];
             if($repaid!=""){
                 echo $repaid;
             }else{
                 echo $repaid=0;
             }
             ?>
         </td>
         <td>Ksh. 
            <?php
            $principalpaid=($row["amount"]/$row["amount_repayable"])*$repaid;
            $sumprincipalpaid+=$principalpaid;
            echo number_format($principalpaid,2);
            ?>
         </td>
         <td>Ksh. 
            <?php
            echo number_format($repaid-$principalpaid,2);
            ?>
         </td>
         <td>Ksh. 
             <?php echo number_format($row["amount"]-$row["amt_repaid"],2);
             $sumprincipalbalance+=$row["amount"]-$row["amt_repaid"];
             ?>
         </td>
         <td>Ksh. 
             <?php
             echo number_format($repaid-$installement,2);
             ?>
         </td>
         <td>Ksh. 
             <?php
             $portfolio=0;
             $pia=$repaid-$installement;
             if($pia<0){
               echo $portfolio=$row["amount"]-$row["amt_repaid"];  
             }else{
                echo $portfolio; 
             }
             $sumportfolio+=$portfolio;
             ?>
         </td>
         </tr>
        <?php } ?>
        <tr>
            <td></td>
            <td></td>
            <td></td>
            <td>Ksh. 
                <?php  echo number_format($amountborrowed) ?>
            </td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td>Ksh. <?php echo number_format($sumprincipalpaid,2) ?></td>
            <td></td>
            <td>Ksh. <?php echo number_format($sumprincipalbalance,2) ?></td>
            <td></td>
            <td>Ksh. <?php echo number_format($sumportfolio,2) ?></td>
            
        </tr>
        <tr>
            <td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td>
            <td>
                Portfolio at Risk( PAR%)
            </td>
            <td>
                <?php
                $parvalue=number_format($sumportfolio/$sumprincipalbalance*100,2);
                mysqli_query($con,"UPDATE PAR SET par_value='$parvalue' WHERE id='1'");
                echo $parvalue;
                ?>%
            </td>
        </tr>
       </tbody>
     </table>
    </div>
     </div>
    </div>

     <div id="filtermodal" class="modal fade" role="dialog">
       <div class="modal-dialog">
       <div class="modal-content">
        <h3><i class="far fa-calendar-alt"></i> Customized Duration Report<span class="close pull-right" data-dismiss="modal"><i class="fas fa-times"></i></span></h3>
        <form role="form" id="filterform">
            <div class="col-md-4">
           <div class="form-group">
            <label>Relationship Officer <span>*</span></label>
            <select class="form-control" id="officer" required>
                <option value="0">All</option>
                <?php
                $users=mysqli_query($con,"SELECT * FROM users WHERE typeId='5'");
                while($us=mysqli_fetch_assoc($users)){ ?>
                   <option value='<?php echo $us["id"] ?>'><?php echo $us["first_name"]." ".$us["last_name"] ?></option> 
               <?php }
                ?>
            </select>
           </div>
          </div>
          <div class="col-md-4">
           <div class="form-group">
            <label>Start Date <span>*</span></label>
            <input type="date" class="form-control" id="date1" required>
           </div>
          </div>
          <div class="col-md-4">
           <div class="form-group">
            <label>End Date <span>*</span></label>
            <input type="date" class="form-control" id="date2" required>
           </div>
          </div>
          <div class="form-group">
           <button class="btn btn-block" type="submit"><i class="fa fa-save"></i> Show Report</button>
          </div>
          <div class="form-group">
           <div id="filterstatus"></div>
          </div>
         </form>
        </div>
       </div>
      </div>

   </div>
  </div>
 </div>
</div>
</div>
</section>
<script src="<?php echo $base_url;?>assets/bootstrap/bootstrap.min.js"></script>
<script src="<?php echo $base_url;?>assets/js/dashboard.js"></script>
<script src="<?php echo $base_url;?>assets/js/jquery.dataTables.min.js"></script>
<script src="<?php echo $base_url;?>assets/js/dataTables.bootstrap4.min.js"></script>
<?php include_once("includes/buttons.php");?>
<script>
$(function(){
 $("#olb").attr("class","active");
 function dataTables(tb){
 var table = $('#'+tb+'').DataTable({
  lengthChange: false,
  "aaSorting": [],
  "buttons": [
  {"extend": 'copy', "text":'<i class="fas fa-copy"></i> Copy',"className": 'btn btn-success btn-sm'},
  {"extend": 'csv', "text":'<i class="fas fa-file-csv"></i> CSV',"className": 'btn btn-success btn-sm'},
  {"extend": 'excel', "text":'<i class="fas fa-file-excel"></i> Excel',"className": 'btn btn-success btn-sm' },
  {"extend": 'pdf', "text":'<i class="fas fa-file-pdf"></i> PDF',"className": 'btn btn-success btn-sm'},
  {"extend": 'print', "text":'<i class="fas fa-print"></i> Print',"className": 'btn btn-success btn-sm'}
  ]
 }); 
 table.buttons().container().appendTo( '#'+tb+'_wrapper .col-md-6:eq(0)' );
 }
 
  dataTables("tb_olb");

  //Custom duration report
  $("#filterform").submit(function(e){
   e.preventDefault();
   var date1 = $("#date1").val();
   var date2 = $("#date2").val();
   var officer = $("#officer").val();
   $("#filterform .btn").attr("disabled","disabled");
   $("#filterstatus").html("<p class='alert alert-success' style='padding:10px;'><i class='fa fa-spinner fa-pulse'></i> Please wait....</p>");
   $.ajax({
    type: "POST",
    url: $("#portal_url").html()+"reports/olbanalysisnew",
    data: {
      date1:date1,
      date2:date2,
      officer:officer
    },
    cache: false
   }).done(function(data){
    $("#filterform .btn").removeAttr("disabled");
    $("#filterstatus").html("");
    $(".report").html(data);
    $('#filtermodal').modal('toggle');
    dataTables("tb_olb");
   });
  });
});
 </script>
  <?php mysqli_close($con); ?>
</body>
</html>