<?php
ob_start();
session_start();
include_once("../config/index.php");
include_once("includes/auth.php");
$now = date('Y-m-d H:i:s');
$expld_url = explode("/", $_SERVER["REQUEST_URI"]);
$custNo = end($expld_url);
if(is_numeric($custNo)){
 $cust = mysqli_fetch_assoc(mysqli_query($con,"SELECT * FROM customers WHERE custNo='$custNo'"));
 $custid = $cust["id"];
 $branchid = $cust["branchId"];
 $genderid = $cust["gender"];
 $maritalid = $cust["maritalstatus"];
 $leadid = $cust["lead"];
 $branch = mysqli_fetch_assoc(mysqli_query($con,"SELECT * FROM branches WHERE id='$branchid'"));
 $gender = mysqli_fetch_assoc(mysqli_query($con,"SELECT * FROM gender WHERE id='$genderid'"));
 $marital = mysqli_fetch_assoc(mysqli_query($con,"SELECT * FROM marital_status WHERE id='$maritalid'"));
 $lead = mysqli_fetch_assoc(mysqli_query($con,"SELECT * FROM market_leads WHERE id='$leadid'"));
}
else{
  header("Location:".$portal_url."customers");
}
?>
<!DOCTYPE html>
<html lang="en-US">
<head>
<meta charset="UTF-8">
<title><?php echo $cust["first_name"]." ".$cust["last_name"];?> | Kuza Fine Africa</title>
<meta name="viewport" content="width=device-width,initial-scale=1">
<link rel="shortcut icon" href="<?php echo $base_url;?>assets/images/logo/favicon.ico">
<link href="<?php echo $base_url;?>assets/bootstrap/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="<?php echo $base_url;?>assets/css/dataTables.bootstrap4.min.css"/>
<link rel="stylesheet" href="<?php echo $base_url;?>assets/fontawesome/css/all.min.css"> 
<link href="<?php echo $base_url;?>assets/css/dashboard.css" rel="stylesheet">
<script src="<?php echo $base_url;?>assets/js/jquery.min.js"></script>
</head>
<body> 
<?php include_once("includes/header.php");?>
<section id="main">
<div class="container-fluid">
 <div class="row">
  <?php include_once("includes/aside.php");?>
  <div class="content">
   <div class="col-md-12">
    <div class="breadcrumbs row">
     <ul class="breadcrumb">
      <li><i class="fas fa-tachometer-alt"></i>&nbsp;Dashboard</li>
      <li><i class="fas fa-users"></i> &nbsp;&nbsp;Customers</li>
      <li><i class="fas fa-user"></i> &nbsp;&nbsp;<?php echo $cust["first_name"]." ".$cust["last_name"];?></li>
      <li><a target="_blank" href="<?php echo $portal_url;?>pdf/borrower-report?custNo=<?php echo $custNo;?>"><i class="fas fa-file-pdf"></i> Borrower Report</a></li>
     </ul>
    </div>

    <div class="row">
     <div class="col-md-12" style="padding-left: 0!important;">
      <div class="col-md-3">
       <div class="col-md-12 inner">
        <div class="row">
         <div class="col-md-7">
          <h1>Ksh <?php echo number_format(($cust["savings"]),2);?></h1>
         </div>
         <div class="col-md-5">
          <i class="fas fa-wallet"></i>
         </div>
        </div>
        <div class="row">
         <h4>LGF Balance</h4>
        </div>
       </div>
      </div>
      <div class="col-md-3">
       <div class="col-md-12 inner">
        <div class="row">
         <div class="col-md-7">
          <h1><?php echo number_format(mysqli_num_rows(mysqli_query($con,"SELECT * FROM loan_applications WHERE custId='$custid'")));?></h1>
         </div>
         <div class="col-md-5">
          <i class="fas fa-clipboard-list"></i>
         </div>
        </div>
        <div class="row">
         <h4>Total Loans</h4>
        </div>
       </div>
      </div>
      <div class="col-md-3">
       <div class="col-md-12 inner">
        <div class="row">
         <div class="col-md-7">
          <?php 
           $total = mysqli_fetch_assoc(mysqli_query($con,"SELECT SUM(amount) AS amt FROM loan_applications WHERE custId='$custid' AND status='4'"))["amt"];
          ?>
          <h1>Ksh <?php echo number_format($total,2);?></h1>
         </div>
         <div class="col-md-5">
          <i class="fas fa-hand-holding-usd"></i>
         </div>
        </div>
        <div class="row">
         <h4>Amount Borrowed</h4>
        </div>
       </div>
      </div>
      <div class="col-md-3">
       <div class="col-md-12 inner">
        <div class="row">
         <div class="col-md-7">
          <?php 
           $repaid = mysqli_fetch_assoc(mysqli_query($con,"SELECT SUM(amt_repaid) AS amt FROM loan_applications WHERE custId='$custid' AND status='4'"))["amt"];
          ?>
          <h1>Ksh <?php echo number_format($repaid,2);?></h1>
         </div>
         <div class="col-md-5">
          <i class="fas fa-file-invoice"></i>
         </div>
        </div>
        <div class="row">
         <h4>Amount Repaid</h4>
        </div>
       </div>
      </div>
     </div>
    </div>

    <div class="col-md-12 customer">
     <div class="row cust-details">
      <div class="col-md-2">
       <img class="img-responsive" src="<?php echo $base_url;?>assets/images/profiles/<?php echo $cust["image"];?>">
      </div>
      <div class="col-md-5">
       <div class="table-responsive">
        <table class="table">
         <tr><td>Cust No:</td><td><span><?php echo $cust["custNo"];?></span></td></tr>
         <tr><td>First Name:</td><td><span><?php echo $cust["first_name"];?></span></td></tr>
         <tr><td>Middle Name:</td><td><span><?php echo $cust["middle_name"];?></span></td></tr>
         <tr><td>Last Name:</td><td><span><?php echo $cust["last_name"];?></span></td></tr>
         <tr><td>Common Name:</td><td><span><?php echo $cust["nickname"];?></span></td></tr>
         <tr><td>National ID:</td><td><span><?php echo $cust["idNo"];?></span></td></tr>
         <tr><td>Branch:</td><td><span><?php echo $branch["name"];?></span></td></tr>
        </table>
       </div>
      </div>
      <div class="col-md-5">
       <div class="table-responsive">
        <table class="table">
         <tr><td>Email:</td><td><span><?php echo $cust["email"];?></span></td></tr>
         <tr><td>Mobile 1:</td><td><span><?php echo $cust["phone"];?></span></td></tr>
         <tr><td>Mobile 2:</td><td><span><?php echo $cust["phone2"];?></span></td></tr>
         <tr><td>Gender:</td><td><span><?php echo $gender["name"];?></span></td></tr>
         <tr><td>D.O.B:</td><td><span><?php echo date("d/m/Y",strtotime($cust["dob"]));?></span></td></tr>
         <tr><td>Marital Status:</td><td><span><?php echo $marital["name"];?></span></td></tr>
         <tr><td>Dependants:</td><td><span><?php echo $cust["dependants"];?></span></td></tr>
        </table>
       </div>
      </div>
     </div>

     <div class="row residence">
      <div class="col-md-12 titlediv">
       <h3>Residence & Spouse Information</h3>
      </div>
      <div class="col-md-4">
       <div class="table-responsive">
        <table class="table">
         <tr><td>Town:</td><td><span><?php echo $cust["town"];?></span></td></tr>
         <tr><td>Estate:</td><td><span><?php echo $cust["estate"];?></span></td></tr>
         <tr><td>House No:</td><td><span><?php echo $cust["house_no"];?></span></td></tr>
         <tr><td>Ownership:</td><td><span><?php if($cust["residence_ownership"]==1){echo "Owned";}else{echo "Rented";}?></span></td></tr>
         <tr><td>Landmark:</td><td><span><?php echo $cust["landmark"];?></span></td></tr>
        </table>
       </div>
      </div>
      <div class="col-md-4">
       <div class="table-responsive">
        <table class="table">
         <tr><td>Duration:</td><td><span><?php echo $cust["residence_period"];?> months</span></td></tr>
         <tr><td>Rural County:</td><td><span><?php echo $cust["rural_county"];?></span></td></tr>
         <tr><td>Rural Town:</td><td><span><?php echo $cust["rural_town"];?></span></td></tr>
         <tr><td>Rural Village:</td><td><span><?php echo $cust["rural_village"];?></span></td></tr>
         <tr><td>Rural Landmark:</td><td><span><?php echo $gender["rural_landmark"];?></span></td></tr>
        </table>
       </div>
      </div>
      <div class="col-md-4">
       <div class="table-responsive">
        <table class="table">
         <tr><td>Spouse Name:</td><td><span><?php echo $cust["spouse_name"];?></span></td></tr>
         <tr><td>Spouse ID:</td><td><span><?php echo $marital["spouse_id"];?></span></td></tr>
         <tr><td>Spouse Phone:</td><td><span><?php echo $cust["spouse_phone"];?></span></td></tr>
         <tr><td>Spouse Occupation:</td><td><span><?php echo $cust["spouse_occupation"];?></span></td></tr>
         <tr><td>Market Lead:</td><td><span><?php if($cust["lead"]==0){echo $cust["other_lead"];}else{echo $lead["name"];}?></span></td></tr>
        </table>
       </div>
      </div>
     </div>

     <div class="row business">
      <div class="col-md-12 titlediv">
       <h3>Business Information</h3>
      </div>
      <div class="col-md-4">
       <div class="table-responsive">
        <table class="table">
         <tr><td>Business Name:</td><td><span><?php echo $cust["business_name"];?></span></td></tr>
         <tr><td>Business Nature:</td><td><span><?php echo $cust["business_nature"];?></span></td></tr>
         <tr><td>Operational Period:</td><td><span><?php echo $cust["business_age"];?> years</span></td></tr>
         <tr><td>Business Type:</td><td><span><?php echo $cust["business_type"];?></span></td></tr>
         <tr><td>Postal Address:</td><td><span><?php echo $cust["business_address"];?></span></td></tr>
        </table>
       </div>
      </div>
      <div class="col-md-4">
       <div class="table-responsive">
        <table class="table">
         <tr><td>Town:</td><td><span><?php echo $cust["business_town"];?></span></td></tr>
         <tr><td>Location:</td><td><span><?php echo $cust["business_location"];?></span></td></tr>
         <tr><td>Landmark:</td><td><span><?php echo $cust["business_landmark"];?></span></td></tr>
         <tr><td>Street:</td><td><span><?php echo $cust["business_strret"];?></span></td></tr>
         <tr><td>Building:</td><td><span><?php echo $gender["business_building"];?></span></td></tr>
        </table>
       </div>
      </div>
      <div class="col-md-4">
       <div class="table-responsive">
        <table class="table">
         <tr><td>Mobile No:</td><td><span><?php echo $cust["business_phone"];?></span></td></tr>
         <tr><td>Licence No:</td><td><span><?php echo $marital["business_licence"];?></span></td></tr>
         <tr><td>KRA Pin:</td><td><span><?php echo $cust["business_pin"];?></span></td></tr>
         <tr><td>Business Map:</td><td><span><?php if($cust["business_map"]!=""){?><a target="_blank" href="<?php echo $base_url;?>assets/documents/<?php echo $cust["business_map"];?>"><i class="fas fa-file-download"></i> Download</a><?php }?></span></td></tr>
         <tr><td>Residence Map:</td><td><span><?php if($cust["business_map"]!=""){?><a target="_blank" href="<?php echo $base_url;?>assets/documents/<?php echo $cust["business_map"];?>"><i class="fas fa-file-download"></i> Download</a><?php }?></span></td></tr>
        </table>
       </div>
      </div>
     </div>
    </div>
   </div>

   <div class="col-md-12">
    <div class="panel panel-default">
     <div class="panel-header dvtitle">Loan Applications</div>
      <div class="panel-body">
       <div class="table-responsive row">
        <table id="tb_loans" class="table table-striped table-bordered" cellspacing="0" width="100%">
         <thead>
          <tr><th>Loan No.</th><th>Loan Product</th><th>Amount</th><th>Loan Date</th><th>Status</th><th>Action</th></tr>
         </thead>
         <tbody>
          <?php
           $chkloans = mysqli_query($con,"SELECT * FROM loan_applications WHERE custId='$custid'");
           while($row = mysqli_fetch_assoc($chkloans)){ ?>
           <tr>
            <td><?php echo $row["loanNo"];?></td>
            <td>
             <?php
              $prodid = $row["prodId"];
              $prod = mysqli_fetch_assoc(mysqli_query($con,"SELECT * FROM loan_products WHERE id='$prodid'"));
              echo $prod["name"];
             ?>
            </td>
            <td>KES <?php echo number_format($row["amount"]);?></td>
            <td><?php echo date("d/m/Y",strtotime($row["created_at"]));?></td>
            <td>
             <?php
              if($row["status"] == 1){ ?>
               <span class="btn btn-xs btn-warning">Pending</span>
             <?php }
              if($row["status"] == 2){ ?>
               <span class="btn btn-xs btn-success">Approved</span>
             <?php }
              if($row["status"] == 3){ ?>
               <span class="btn btn-xs btn-daanger">Rejected</span>
             <?php }
              if($row["status"] == 4){ ?>
               <span class="btn btn-xs btn-success">Disbursed</span>
             <?php } ?>
            </td> 
            <td>
             <a href="<?php echo $portal_url;?>loan/<?php echo $row["loanNo"];?>"><button class="btn btn-xs btn-success" data-toggle="tooltip" data-placement="bottom" title="View loan details"><i class="fas fa-search-plus"></i></button></a>
            </td>
           </tr>
          <?php } ?>
         </tbody>
       </table>
      </div>
     </div>
    </div>
   </div>

  </div>
 </div>
</div>
</section>
<script src="<?php echo $base_url;?>assets/bootstrap/bootstrap.min.js"></script>
<script src="<?php echo $base_url;?>assets/js/dashboard.js"></script>
<script src="<?php echo $base_url;?>assets/js/jquery.dataTables.min.js"></script>
<script src="<?php echo $base_url;?>assets/js/dataTables.bootstrap4.min.js"></script>
<script>
$(function(){
 $("#cust").attr("class","active");
 $('#tb_loans').DataTable({"aaSorting":[]});
 });
</script>
</body>
</html>