<?php
ob_start();
session_start();
include_once("../config/index.php");
include_once("includes/auth.php");
?>
<!DOCTYPE html>
<html lang="en-US">
<head>
<meta charset="UTF-8">
<title>Notification Templates | Kuza Fine Africa</title>
<meta name="viewport" content="width=device-width,initial-scale=1">
<link rel="shortcut icon" href="<?php echo $base_url;?>assets/images/logo/favicon.ico">
<link href="<?php echo $base_url;?>assets/bootstrap/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="<?php echo $base_url;?>assets/css/dataTables.bootstrap4.min.css"/>
<link rel="stylesheet" href="<?php echo $base_url;?>assets/fontawesome/css/all.min.css"> 
<link href="<?php echo $base_url;?>assets/css/dashboard.css" rel="stylesheet">
<script src="https://cloud.tinymce.com/stable/tinymce.min.js?apiKey=1v1vujckmuljfpt6zsf3grfipei6ep033cmzgdev6w8n140n"></script>
<script>
tinymce.init({
 'selector':'textarea',
 'theme': 'modern',
 'toolbar': 'superscript forecolor backcolor | alignleft aligncenter alignjustify alignright | bullist numlist | link unlink image | outdent indent emoticons hr | styleselect  fontselect fontsizeselect',
  'plugins': 'colorpicker fullpage textcolor media anchor table code paste link save autolink autoresize image emoticons pagebreak fullscreen imagetools contextmenu visualchars directionality spellchecker hr lists wordcount',
 relative_urls : false,
 remove_script_host : false,
 convert_urls : false,
 setup: function (editor) {
        editor.on('change', function () {
        editor.save();
       });
    },
});
</script>
<style>
.modal-dialog{
  width: 700px;
}
</style>
</head>
<body>
<?php include_once("includes/header.php");?>
<section id="main">
<div class="container-fluid">
 <div class="row">
 <?php include_once("includes/aside.php");?>
   <div class="content">
    <div class="col-md-12">
     <div class="breadcrumbs row">
      <ul class="breadcrumb">
        <li><i class="fas fa-tachometer-alt"></i>&nbsp;Dashboard</li>
        <li><i class="far fa-newspaper"></i> &nbsp;Notification Templates</li>
      </ul>
    </div>

    <div class="row wrapper">
      <button class="btn item item1" data-dismiss="modal" data-toggle="modal" data-target="#tempmodal"><i class="fa fa-plus"></i> New Template</button>
      <span class="item item2" data-dismiss="modal" data-toggle="modal" data-target="#tempmodal" style="display: none;"></span>
    </div>

   <div class="row">
    <div class="col-md-12">
     <div class="table-responsive">
        <table id="tb_temps" class="table table-striped" cellspacing="0" width="100%">
         <thead>
           <tr><th style="width: 20px;">#</th><th>Name</th><th>Subject</th><th>Description</th><th style="max-width: 60px;">Action</th></tr>
          </thead>
           <tbody>
             <?php
             $chktemps = mysqli_query($con,"SELECT * FROM notification_templates ORDER BY id ASC");
             while($row = mysqli_fetch_assoc($chktemps)){ ?>
             <tr>
               <td><?php echo $row["id"];?></td>
               <td><?php echo $row["name"];?></td>
               <td><?php echo $row["subject"];?></td>
               <td><?php echo $row["description"];?></td>
               <td>
                <button class="btn btn-xs btn-primary edtemp" data-toggle="tooltip" data-placement="bottom" title="Edit Template" data-id="<?php echo $row["id"];?>" data-name="<?php echo $row["name"];?>" data-desc="<?php echo $row["description"];?>" data-sub="<?php echo $row["subject"];?>" data-body='<?php echo $row["body"];?>' data-variables='<?php echo $row["variables"];?>'><i class="fas fa-pencil-alt"></i></button>
               </td>
             </tr>
             <?php }
            ?>
         </tbody>
       </table>
      </div>
     </div>
    </div>

   <div id="tempmodal" class="modal fade" role="dialog">
    <div class="modal-dialog">
     <div class="modal-content">
      <h3><i class="far fa-newspaper"></i> Manage Template<span class="close pull-right" data-dismiss="modal"><i class="fas fa-times"></i></span></h3>
     <form role="form" id="tempform">
      <div class="row">
       <div class="col-md-12">
       <div class="form-group" style="width: 98%;">
        <input type="hidden" id="id">
        <input type="text" class="form-control" id="subject" placeholder="Email Subject" required>
       </div>
       </div>
       <div class="col-md-4">
       <div class="form-group">
        <input type="text" class="form-control" id="name" placeholder="Notification Name" required>
       </div>
       </div>
       <div class="col-md-4">
       <div class="form-group">
        <input type="text" class="form-control" id="description" placeholder="Email description" required>
       </div>
       </div>
       <div class="col-md-4">
       <div class="form-group" style="width: 93%;">
        <input type="text" class="form-control" id="variables" placeholder="Variables used" required>
       </div>
       </div>
      <div class="col-md-12" style="margin: 5px;width: 98%;">
       <textarea id="body" required></textarea>
      </div>
      <div class="col-md-4" style="margin: 10px 0px 10px 5px;">
        <button class="btn btn-block" type="button"><i class="fa fa-save"></i> Save Template</button>
        <input type="reset" id="clear" style="display: none;">
      </div>
      <div class="col-md-12"><div id="status"></div></div>
      </div>
     </form>
     </div>
    </div>
   </div>

  </div>
 </div>
</div>
</div>
</section>
<script src="<?php echo $base_url;?>assets/js/jquery.min.js"></script>
<script src="<?php echo $base_url;?>assets/bootstrap/bootstrap.min.js"></script>
<script src="<?php echo $base_url;?>assets/js/dashboard.js"></script>
<script src="<?php echo $base_url;?>assets/js/jquery.dataTables.min.js"></script>
<script src="<?php echo $base_url;?>assets/js/dataTables.bootstrap4.min.js"></script>
<script>
 $(function(){
  $("#temps").attr("class","active");

  var table = $('#tb_temps').DataTable( {"aaSorting": []});

  $(document).on('focusin', function(e) {
    if ($(e.target).closest(".mce-window").length) {
        e.stopImmediatePropagation();
    }
  });


  $(".edtemp").click(function(){
   $("#tempmodal h3").html("<i class='fas fa-pencil-alt'></i> Edit Template");
   $("#id").val($(this).attr("data-id"));
   $("#name").val($(this).attr("data-name")).change();
   $("#subject").val($(this).attr("data-sub"));
   $("#description").val($(this).attr("data-desc"));
   $("#variables").val($(this).attr("data-variables"));
   var activeEditor = tinyMCE.get('body');
   tinyMCE.activeEditor.setContent($(this).attr("data-body"));
   tinymce.triggerSave();
   $(".item2").click();
  });


  $("#tempform .btn").click(function(){
   var id = $("#id").val();
   var name = $("#name").val();
   var desc = $("#description").val();
   var subject = $("#subject").val();
   var variables = $("#variables").val();
   var body = $("#body").val();
   $("#status").html("<p class='alert alert-success' style='padding:10px;'><i class='fa fa-spinner fa-pulse'></i> Saving template....</p>");
   $.ajax({
    type: "POST",
    url: $("#portal_url").html()+"app/notification-templates",
    data: {
      id:id,
      name:name,
      desc:desc,
      subject:subject,
      variables:variables,
      body:body
    },
    cache: false
   }).done(function(data){
    if(data.status == 200){
     $("#status").html("<p class='alert alert-success' style='padding:10px;'><i class='fa fa-check'></i> Template successfully saved</p>").delay(5000);
     window.location.replace($("#portal_url").html()+"email-templates");
    }
    if(data.status == 300){
     $("#status").html("<p class='alert alert-danger' style='padding:10px;'><i class='fa fa-eclamation-circle'></i> An error occured.. Try again later</p>");
    }
   });
  });
  });
</script>
</body>
</html>
