<?php
ob_start();
session_start();
include_once("../config/index.php");
include_once("includes/auth.php");
$now = date('Y-m-d H:i:s');
?>
<!DOCTYPE html>
<html lang="en-US">
<head>
<meta charset="UTF-8">
<title>Loan Products | Kuza Fine Africa</title>
<meta name="viewport" content="width=device-width,initial-scale=1">
<link rel="shortcut icon" href="<?php echo $base_url;?>assets/images/logo/favicon.ico">
<link href="<?php echo $base_url;?>assets/bootstrap/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="<?php echo $base_url;?>assets/css/dataTables.bootstrap4.min.css"/>
<link rel="stylesheet" href="<?php echo $base_url;?>assets/css/buttons.bootstrap4.min.css"/>
<link rel="stylesheet" href="<?php echo $base_url;?>assets/fontawesome/css/all.min.css"> 
<link href="<?php echo $base_url;?>assets/css/dashboard.css" rel="stylesheet">
<script src="<?php echo $base_url;?>assets/js/jquery.min.js"></script>
<style>
.modal-dialog{
  max-width: 450px;
}
form{
  padding-left: 5px;
  padding-right: 10px;
}
</style>
</head>
<body> 
<?php include_once("includes/header.php");?>
<section id="main">
<div class="container-fluid">
 <div class="row">
   <?php include_once("includes/aside.php");?>
   <div class="content">
    <div class="col-md-12">
     <div class="breadcrumbs row">
      <ul class="breadcrumb">
       <li><i class="fas fa-tachometer-alt"></i>&nbsp;Dashboard</li>
       <li><i class="fas fa-hand-holding-usd"></i> &nbsp;&nbsp;Loan Products</li>
      </ul>
    </div>

    <div class="row wrapper">
      <button class="btn item item1" data-dismiss="modal" data-toggle="modal" data-target="#productmodal"><i class="fa fa-plus"></i> New Product</button>
      <span class="item item2" data-dismiss="modal" data-toggle="modal" data-target="#productmodal" style="display: none;"></span>
    </div>

     <div class="panel panel-default">
       <div class="panel-header dvtitle">Loan Products</div>
       <div class="panel-body">
        <div class="table-responsive row">
        <table id="tb_products" class="table table-striped table-bordered" cellspacing="0" width="100%">
         <thead>
           <tr><th>Product</th><th>Description</th><th>Duration</th><th>Interest</th><th>Grace Period</th><th>Processing Fee</th><th>Excise Duty Fee</th><th>Max Amount</th><th style="min-width: 100px;">Action</th></tr>
          </thead>
           <tbody>
             <?php
             $chkproducts = mysqli_query($con,"SELECT * FROM loan_products");
             while($row = mysqli_fetch_assoc($chkproducts)){  ?>
             <tr>
              <td><?php echo $row["name"];?></td>
              <td><?php echo $row["description"];?></td>
              <td><?php echo $row["duration"];?></td>
              <td><?php echo $row["interest_rate"];?></td>
              <td><?php echo $row["grace_period"];?> days</td>
              <td>Ksh. <?php echo $row["processingfee"];?></td>
              <td>Ksh. <?php echo $row["excisefee"];?></td>
              <td>Ksh. <?php echo $row["maxamount"];?></td>
              <td>
               <button class="btn btn-xs btn-primary edtprod" data-toggle="tooltip" data-placement="bottom" title="Edit Product" data-id="<?php echo $row["id"];?>" data-processingfee="<?php echo $row["processingfee"];?>" data-excisefee="<?php echo $row["excisefee"];?>" data-maxamount="<?php echo $row["maxamount"];?>" data-name="<?php echo $row["name"];?>" data-desc="<?php echo $row["description"];?>" data-duration="<?php echo $row["duration"];?>" data-interest="<?php echo $row["interest_rate"];?>" data-graceperiod="<?php echo $row["grace_period"];?>"><i class="fas fa-pencil-alt"></i></button>
               <button class="btn btn-xs btn-danger delprod" id="<?php echo $row["id"];?>" data-toggle="tooltip" data-placement="bottom" title="Delete Product"><i class="fa fa-trash"></i></button>
              </td>
             </tr>
             <?php }
            ?>
         </tbody>
       </table>
      </div>
    </div>
   </div>
  

<div id="productmodal" class="modal fade" role="dialog">
 <div class="modal-dialog">
  <div class="modal-content">
   <h3><i class="fas fa-analytics"></i> Loan Product Management<span class="close pull-right" data-dismiss="modal"><i class="fas fa-times"></i></span></h3>
   <form role="form" id="productfrm">
    <div class="form-group">
     <label>Product Name <span>*</span></label>
     <input type="hidden" id="id" value="">
     <input type="text" class="form-control" id="name" required>
    </div>
    <div class="form-group">
     <label>Description <span>*</span></label>
     <input type="text" class="form-control" id="description" required>
    </div>
    <div class="form-group">
     <label>Duration [No. of days]<span>*</span></label>
     <input type="text" class="form-control" id="duration" required>
    </div>
    <div class="form-group">
     <label>Grace Period [No. of days]<span>*</span></label>
     <input type="text" class="form-control" id="graceperiod" required>
    </div>
    <div class="form-group">
     <label>Interest Rate [%]<span>*</span></label>
     <input type="text" class="form-control" id="interest" placeholder="eg. 10" required>
    </div>
     <div class="form-group">
     <label>Processing Fee<span>*</span></label>
     <input type="number" class="form-control" id="pfee" placeholder="eg. 250" required>
    </div>
     <div class="form-group">
     <label>Excise Duty Fee<span>*</span></label>
     <input type="number" class="form-control" id="edfee" placeholder="eg. 0 or 50" required>
    </div>
     <div class="form-group">
     <label>Max Amount<span>*</span></label>
     <input type="number" class="form-control" id="maxamount" placeholder="eg. 50000" required>
    </div>
    <div class="form-group" style="border-top: 1px solid #ddd;padding-top: 5px;">
      <button class="btn btn-block" type="submit"> <i class="fa fa-save"></i> Save Product</button>
    </div>
    <div class="form-group">
     <div id="status"></div>
    </div>
   </form>
  </div>
 </div>
</div>

  </div>
 </div>
</div>
</div>
</section>
<script src="<?php echo $base_url;?>assets/bootstrap/bootstrap.min.js"></script>
<script src="<?php echo $base_url;?>assets/js/dashboard.js"></script>
<script src="<?php echo $base_url;?>assets/js/jquery.dataTables.min.js"></script>
<script src="<?php echo $base_url;?>assets/js/dataTables.bootstrap4.min.js"></script>
<script>
$(function(){
 $("#lnprod").attr("class","active");
 function dataTables(tb){
 var table = $('#'+tb+'').DataTable({
  lengthChange: false,
  "aaSorting": [],
  "buttons": [
  {"extend": 'copy', "text":'<i class="fas fa-copy"></i> Copy',"className": 'btn btn-success btn-sm'},
  {"extend": 'csv', "text":'<i class="fas fa-file-csv"></i> CSV',"className": 'btn btn-success btn-sm'},
  {"extend": 'excel', "text":'<i class="fas fa-file-excel"></i> Excel',"className": 'btn btn-success btn-sm' },
  {"extend": 'pdf', "text":'<i class="fas fa-file-pdf"></i> PDF',"className": 'btn btn-success btn-sm'},
  {"extend": 'print', "text":'<i class="fas fa-print"></i> Print',"className": 'btn btn-success btn-sm'}
  ]
 }); 
 table.buttons().container().appendTo( '#'+tb+'_wrapper .col-md-6:eq(0)' );
 }
 $('#tb_products').DataTable({"aaSorting":[]});

 $("body").on("click",".edtprod",function(){
  $("#id").val($(this).attr("data-id"));
  $("#name").val($(this).attr("data-name"));
  $("#description").val($(this).attr("data-desc"));
  $("#duration").val($(this).attr("data-duration"));
  $("#graceperiod").val($(this).attr("data-graceperiod"));
  $("#interest").val($(this).attr("data-interest"));
  $("#pfee").val($(this).attr("data-processingfee"));
  $("#edfee").val($(this).attr("data-excisefee"));
  $("#maxamount").val($(this).attr("data-maxamount"));
  $("#status").html("");
  $(".item1").click();
 });

 $("#productfrm").submit(function(e){
  e.preventDefault();
  var id = $("#id").val();
  var name = $("#name").val();
  var description = $("#description").val();
  var duration = $("#duration").val();
  var graceperiod = $("#graceperiod").val();
  var interest = $("#interest").val();
  var pfee = $("#pfee").val();
  var edfee = $("#edfee").val();
  var maxamount = $("#maxamount").val();
  
  $("#status").html("<p class='text-success bg-success'><i class='fa fa-spinner fa-pulse'></i> Saving the loan product...</p>"); 
  $.ajax({
    method: "POST",
    url: $("#portal_url").html()+"app/loan-products",
    data: {
      id:id,
      name:name,
      description:description,
      duration:duration,
      graceperiod:graceperiod,
      interest:interest,
      pfee:pfee,
      edfee:edfee,
      maxamount:maxamount
    },
    cache:false
  }).done(function(data){
   if(data.status == 200){
    $("#status").html("<p class='alert alert-success'><i class='fa fa-check'></i> Loan product saved successfully.</p>").delay(5000);
     window.location.replace($("#portal_url").html()+"loan-products");
   }
   if(data.status == 300){
    $("#status").html("<p class='alert alert-danger'><i class='fa fa-exclamation-circle'></i> An error occured, please try again later.</p>");
   }
  });
 });

 //Deleting a loan product
 $(".delprod").click(function(){
  var delprod = $(this).attr("id");
  var d = confirm('Are you sure you want to delete this product?');
  if(d == false){
   return false;
  }
  else{
    $.ajax({
      method:"post",
      url: $("#portal_url").html()+"app/loan-products",
      data:{
        delprod:delprod
      },
      cache:false
    }).done(function(data){
      if(data.status == "200"){
       window.location.replace($("#portal_url").html()+"loan-products");
      }
    });
    }
   });
 });
</script>
</body>
</html>