<?php
ob_start();
session_start();
include_once("../config/index.php");
include_once("includes/auth.php");
$now = date('Y-m-d H:i:s');
?>
<!DOCTYPE html>
<html lang="en-US">
<head>
<meta charset="UTF-8">
<title>Office Administrators | Kuza Fine Africa</title>
<meta name="viewport" content="width=device-width,initial-scale=1">
<link rel="shortcut icon" href="<?php echo $base_url;?>assets/images/logo/favicon.ico">
<link href="<?php echo $base_url;?>assets/bootstrap/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="<?php echo $base_url;?>assets/css/dataTables.bootstrap4.min.css"/>
<link rel="stylesheet" href="<?php echo $base_url;?>assets/fontawesome/css/all.min.css"> 
<link href="<?php echo $base_url;?>assets/css/dashboard.css" rel="stylesheet">
<script src="<?php echo $base_url;?>assets/js/jquery.min.js"></script>
<style>
.modal-dialog{
  max-width: 450px;
}
form{
  padding-left: 5px;
  padding-right: 10px;
}
</style>
</head>
<body> 
<?php include_once("includes/header.php");?>
<section id="main">
<div class="container-fluid">
 <div class="row">
   <?php include_once("includes/aside.php");?>
   <div class="content">
    <div class="col-md-12">
     <div class="breadcrumbs row">
      <ul class="breadcrumb">
       <li><i class="fas fa-tachometer-alt"></i>&nbsp;Dashboard</li>
       <li><i class="fas fa-users"></i> &nbsp;&nbsp;Office Administrators</li>
      </ul>
    </div>

    <div class="row wrapper">
      <button class="btn item item1" data-dismiss="modal" data-toggle="modal" data-target="#usermodal"><i class="fa fa-plus"></i> New Administrator</button>
      <span class="item item2" data-dismiss="modal" data-toggle="modal" data-target="#usermodal" style="display: none;"></span>
    </div>

     <div class="panel panel-default">
       <div class="panel-header dvtitle">Office Administrators</div>
       <div class="panel-body">
        <div class="table-responsive row">
        <table id="tb_users" class="table table-striped table-bordered" cellspacing="0" width="100%">
         <thead>
           <tr><th>Image</th><th>Name</th><th>Phone</th><th>Email</th><th>Branch</th><th style="min-width: 100px;">Action</th></tr>
          </thead>
           <tbody>
             <?php
             $chkusers = mysqli_query($con,"SELECT * FROM users WHERE typeId='7'");
             while($row = mysqli_fetch_assoc($chkusers)){  ?>
             <tr>
              <td><img style="max-width: 40px;" src="<?php echo $base_url;?>assets/images/profiles/<?php echo $row["image"];?>"></td>
              <td><?php echo $row["first_name"]." ".$row["last_name"];?></td>
              <td><?php echo $row["phone"];?></td>
              <td><?php echo $row["email"];?></td>
              <td>
              <?php 
               $branchid = $row["branchId"];
               echo mysqli_fetch_assoc(mysqli_query($con,"SELECT * FROM branches WHERE id='$branchid'"))["name"];
              ?>
              </td>
              <td>
               <a data-toggle="tooltip" data-placement="bottom" title="Edit Admin"><button class="btn btn-xs btn-primary edtuser" data-id="<?php echo $row["id"];?>" data-fname="<?php echo $row["first_name"];?>" data-lname="<?php echo $row["last_name"];?>" data-phone="<?php echo $row["phone"];?>" data-email="<?php echo $row["email"];?>" data-branch="<?php echo $row["branchId"];?>"><i class="fas fa-pencil-alt"></i></button></a>
               <button class="btn btn-xs btn-danger deluser" id="<?php echo $row["id"];?>" data-toggle="tooltip" data-placement="bottom" title="Delete Admin"><i class="fa fa-trash"></i></button>
              </td>
             </tr>
             <?php }
            ?>
         </tbody>
       </table>
      </div>
    </div>
   </div>
  

<div id="usermodal" class="modal fade" role="dialog">
 <div class="modal-dialog">
  <div class="modal-content">
   <h3><i class="fas fa-users"></i> Manage Office Administrators<span class="close pull-right" data-dismiss="modal"><i class="fas fa-times"></i></span></h3>
   <form role="form" id="userfrm">
    <div class="form-group">
     <label>First Name <span>*</span></label>
     <input type="hidden" id="id" value="">
     <input type="hidden" id="typeid" value="7">
     <input type="text" class="form-control" id="fname" required>
    </div>
    <div class="form-group">
     <label>Last Name <span>*</span></label>
     <input type="text" class="form-control" id="lname" required>
    </div>
    <div class="form-group">
     <label>Phone <span>*</span></label>
     <input type="tel" class="form-control" id="phone" required>
    </div>
    <div class="form-group">
     <label>Email <span>*</span></label>
     <input type="email" class="form-control" id="email" required>
    </div>
    <div class="form-group">
     <label>Branch <span>*</span></label>
     <select class="form-control" id="branch">
     <?php
      $chkbranches = mysqli_query($con,"SELECT * FROM branches");
      while($row = mysqli_fetch_assoc($chkbranches)){ ?>
       <option value="<?php echo $row["id"]?>"><?php echo $row["name"]?></option>
      <?php }
     ?>
     </select>
    </div>
    <div class="form-group" style="border-top: 1px solid #ddd;padding-top: 5px;">
      <button class="btn btn-block" type="submit"> <i class="fa fa-save"></i> Save Administrator</button>
    </div>
    <div class="form-group">
     <div id="status"></div>
    </div>
   </form>
  </div>
 </div>
</div>

  </div>
 </div>
</div>
</div>
</section>
<script src="<?php echo $base_url;?>assets/bootstrap/bootstrap.min.js"></script>
<script src="<?php echo $base_url;?>assets/js/dashboard.js"></script>
<script src="<?php echo $base_url;?>assets/js/jquery.dataTables.min.js"></script>
<script src="<?php echo $base_url;?>assets/js/dataTables.bootstrap4.min.js"></script>
<script>
$(function(){
 $("#offadm").attr("class","active");
 $('#tb_users').DataTable({"aaSorting":[]});

 $("body").on("click",".edtuser",function(){
  $("#id").val($(this).attr("data-id"));
  $("#fname").val($(this).attr("data-fname"));
  $("#lname").val($(this).attr("data-lname"));
  $("#phone").val($(this).attr("data-phone"));
  $("#email").val($(this).attr("data-email"));
  $("#branch").val($(this).attr("data-branch"));
  $("#status").html("");
  $(".item1").click();
 });

 $("#userfrm").submit(function(e){
  e.preventDefault();
  var id = $("#id").val();
  var typeid = $("#typeid").val();
  var fname = $("#fname").val();
  var lname = $("#lname").val();
  var phone = $("#phone").val();
  var email = $("#email").val();
  var branch = $("#branch").val();
  
  $("#status").html("<p class='text-success bg-success'><i class='fa fa-spinner fa-pulse'></i> Saving the officer...</p>"); 
  $.ajax({
    method: "POST",
    url: $("#portal_url").html()+"app/users",
    data: {
      id:id,
      typeid:typeid,
      fname:fname,
      lname:lname,
      phone:phone,
      email:email,
      branch:branch
    },
    cache:false
  }).done(function(data){
   if(data.status == 200){
    $("#status").html("<p class='alert alert-success'><i class='fa fa-check'></i> Admin saved successfully.</p>").delay(5000);
     window.location.replace($("#portal_url").html()+"office-admin");
   }
   if(data.status == 300){
    $("#status").html("<p class='alert alert-danger'><i class='fa fa-exclamation-circle'></i> An error occured, please try again later.</p>");
   }
   if(data.status == 401){
    $("#status").html("<p class='alert alert-danger'><i class='fa fa-exclamation-circle'></i> A user with this email address already exist. Use a different email.</p>");
   }
  });
 });

 //Deleting an officer
 $(".deluser").click(function(){
  var deluser = $(this).attr("id");
  var d = confirm('Are you sure you want to delete this admin?');
  if(d == false){
   return false;
  }
  else{
    $.ajax({
      method:"post",
      url: $("#portal_url").html()+"app/users",
      data:{
        deluser:deluser
      },
      cache:false
    }).done(function(data){
      if(data.status == "200"){
       window.location.replace($("#portal_url").html()+"office-admin");
      }
    });
    }
   });
 });
</script>
</body>
</html>