<?php
ob_start();
session_start();
include_once("../config/index.php");
include_once("includes/auth.php");
$now = date('Y-m-d H:i:s');
$uid = $user["id"];
$expld_url = explode("/", $_SERVER["REQUEST_URI"]);
$loanid = end($expld_url);
if(is_numeric($loanid)){
 $loan = mysqli_fetch_assoc(mysqli_query($con,"SELECT * FROM loan_applications WHERE id='$loanid'"));
 $loanno = $loan["loanNo"];
}
else{
  header("Location:".$portal_url."defaulters");
}
?>
<!DOCTYPE html>
<html lang="en-US">
<head>
<meta charset="UTF-8">
<title>Loan Collection Followup | Microfinance</title>
<meta name="viewport" content="width=device-width,initial-scale=1">
<link rel="shortcut icon" href="<?php echo $base_url;?>assets/images/logo/favicon.ico">
<link href="<?php echo $base_url;?>assets/bootstrap/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="<?php echo $base_url;?>assets/css/dataTables.bootstrap4.min.css"/>
<link rel="stylesheet" href="<?php echo $base_url;?>assets/fontawesome/css/all.min.css"> 
<link href="<?php echo $base_url;?>assets/css/dashboard.css" rel="stylesheet">
<script src="<?php echo $base_url;?>assets/js/jquery.min.js"></script>
</head>
<body> 
<?php include_once("includes/header.php");?>
<section id="main">
<div class="container-fluid">
 <div class="row">
   <?php include_once("includes/aside.php");?>
   <div class="content">
    <div class="col-md-12">
     <div class="breadcrumbs row">
      <ul class="breadcrumb">
       <li><i class="fas fa-tachometer-alt"></i>&nbsp;Dashboard</li>
       <li><i class="fas fa-external-link-square-alt"></i> &nbsp;&nbsp;Loan Collection Followup</li>
      </ul>
    </div>

    <div class="row wrapper">
     <button class="btn item item1" data-dismiss="modal" data-toggle="modal" data-target="#followupmodal"><i class="fa fa-plus"></i> New Followup</button>
     <button class="btn item item2" data-dismiss="modal" data-toggle="modal" data-target="#followupmodal" style="display:none"></button>
    </div>

    <div class="panel panel-default">
     <div class="panel-header dvtitle">Loans Collection Followups</div>
      <div class="panel-body">
       <div class="table-responsive row">
        <table id="tb_followup" class="table table-striped table-bordered" cellspacing="0" width="100%">
         <thead>
           <tr><th>Date & Time</th><th>Comment</th><th>Action</th></tr>
          </thead>
           <tbody>
             <?php
             $chkfollowups = mysqli_query($con,"SELECT * FROM loan_collections WHERE loanId='$loanid' AND userId='$uid' ORDER BY id DESC");
             while($row = mysqli_fetch_assoc($chkfollowups)){ ?>
             <tr>
               <td><?php echo date("d/m/Y H:i",strtotime($row["created_at"]));?></td>
               <td><?php echo $row["comment"];?></td>
               <td>
                <button class="btn btn-xs btn-primary edtfollowup" data-toggle="tooltip" data-placement="bottom" title="Edit this Followup" data-id="<?php echo $row["id"];?>" data-date="<?php echo $row["created_at"];?>" data-comment='<?php echo $row["comment"];?>'><i class="fas fa-pencil-alt"></i></button>
                <button class="btn btn-xs btn-danger delfollowup" data-toggle="tooltip" data-placement="bottom" title="Delete this Followup" data-id="<?php echo $row["id"];?>"><i class="fas fa-trash"></i></button>
               </td>
             </tr>
             <?php }
            ?>
          </tbody>
        </table>
       </div>
      </div>
     </div>

    <div id="followupmodal" class="modal fade" role="dialog">
     <div class="modal-dialog">
      <div class="modal-content">
       <h3><i class="fas fa-external-link-square-alt"></i> Loan Collection Followups<span class="close pull-right" data-dismiss="modal"><i class="fas fa-times"></i></span></h3>
       <form role="form" id="followupform">
        <div class="form-group">
         <label>Followup Date <span>*</span></label>
         <input type="hidden" id="id">
         <input type="hidden" id="loanid" value="<?php echo $loanid;?>">
         <input type="text" class="form-control" id="contdate">
        </div>
        <div class="form-group">
         <label>Comment <span>*</span></label>
         <textarea class="form-control" rows="3" id="comment"></textarea>
        </div>
       <div class="form-group">
        <button class="btn btn-block" type="submit"><i class="fa fa-save"></i> Save Followup</button>
        <input type="reset" id="clear" style="display: none;">
       </div>
       <div class="form-group">
        <div id="status"></div>
       </div>
      </form>
      </div>
     </div>
    </div>

  </div>
 </div>
</div>
</div>
</section>
<script src="<?php echo $base_url;?>assets/bootstrap/bootstrap.min.js"></script>
<script src="<?php echo $base_url;?>assets/js/dashboard.js"></script>
<script src="<?php echo $base_url;?>assets/js/jquery.dataTables.min.js"></script>
<script src="<?php echo $base_url;?>assets/js/dataTables.bootstrap4.min.js"></script>
<script>
$(function(){
 $("#default").attr("class","active");
 $('#tb_defaults').DataTable({"aaSorting":[]});
 });

 $("body").on("click", ".edtfollowup" ,function(){
  $("#id").val($(this).attr("data-id"));
  $("#contdate").val($(this).attr("data-date"));
  $("#comment").val($(this).attr("data-comment"));
  $(".item2").click();
 });

 $("#followupform").submit(function(e){
  e.preventDefault();
  var id = $("#id").val();
  var loanid = $("#loanid").html();
  var contdate = $("#contdate").val();
  var comment = $("#comment").val();
  $("#status").html("<p class='alert alert-success' style='padding:10px;'><i class='fa fa-spinner fa-pulse'></i> Saving the followup....</p>");
  $.ajax({
    type: "POST",
    url: $("#portal_url").html()+"app/followups",
    data: {
      id:id,
      loanid:loanid,
      contdate:contdate,
      comment:comment
    },
    cache: false
  }).done(function(data){
   if(data.status == 200){
    $("#status").html("<p class='alert alert-success' style='padding:10px;'><i class='fa fa-check'></i> followup successfully saved</p>");
      document.location.replace($("#portal_url").html()+"followup/"+loanid);
    }
    if(data.status == 300){
     $("#status").html("<p class='alert alert-danger' style='padding:10px;'><i class='fa fa-exclamation-circle'></i> An error occured. Please try again later.</p>");
     }
     if(data.status == 400){
      $("#status").html("<p class='alert alert-danger' style='padding:10px;'><i class='fa fa-exclamation-circle'></i> The followup already exist.</p>");
     }
   });
 });
</script>
</body>
</html>