<?php
ob_start();
session_start();
include_once("../config/index.php");
include_once("includes/auth.php");
$now = date('Y-m-d H:i:s');
$branchid = $user["branchId"];
?>
<!DOCTYPE html>
<html lang="en-US">
<head>
<meta charset="UTF-8">
<title>Loan Applications | Microfinance</title>
<meta name="viewport" content="width=device-width,initial-scale=1">
<link rel="shortcut icon" href="<?php echo $base_url;?>assets/images/logo/favicon.ico">
<link href="<?php echo $base_url;?>assets/bootstrap/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="<?php echo $base_url;?>assets/css/dataTables.bootstrap4.min.css"/>
<link rel="stylesheet" href="<?php echo $base_url;?>assets/fontawesome/css/all.min.css"> 
<link href="<?php echo $base_url;?>assets/css/dashboard.css" rel="stylesheet">
<script src="<?php echo $base_url;?>assets/js/jquery.min.js"></script>
</head>
<body> 
<?php include_once("includes/header.php");?>
<section id="main">
<div class="container-fluid">
 <div class="row">
   <?php include_once("includes/aside.php");?>
   <div class="content">
    <div class="col-md-12">
     <div class="breadcrumbs row">
      <ul class="breadcrumb">
       <li><i class="fas fa-tachometer-alt"></i>&nbsp;Dashboard</li>
       <li><i class="fas fa-hand-holding-usd"></i> &nbsp;&nbsp;Loan Applications</li>
      </ul>
    </div>

     <div class="panel panel-default">
       <div class="panel-header dvtitle">Loan Applications</div>
       <div class="panel-body">
        <div class="table-responsive row">
        <table id="tb_loans" class="table table-striped table-bordered" cellspacing="0" width="100%">
         <thead>
           <tr><th>Loan No.</th><th>Customer</th><th>Loan Product</th><th>Sequence</th><th>Amount</th><th>Repayable</th><th>Date</th><th>Status</th><th style="min-width: 100px;">Action</th></tr>
          </thead>
           <tbody>
             <?php
             $chkloans = mysqli_query($con,"SELECT * FROM loan_applications WHERE userId!='0' ORDER BY id DESC");
             while($row = mysqli_fetch_assoc($chkloans)){ 
              $custid = $row["custId"];
              $cust = mysqli_fetch_assoc(mysqli_query($con,"SELECT * FROM customers WHERE id='$custid'"));
              if($cust["branchId"] == $branchid){ ?>
             <tr>
              <td><?php echo $row["loanNo"];?></td>
              <td>
               <?php
                echo $cust["first_name"]." ".$cust["last_name"]." (".$cust["custNo"].")";
               ?>
              </td>
              <td>
               <?php
                $prodid = $row["prodId"];
                $prod = mysqli_fetch_assoc(mysqli_query($con,"SELECT * FROM loan_products WHERE id='$prodid'"));
                echo $prod["name"];
               ?>
              </td>
              <td>
               <?php
                $seqid = $row["seqId"];
                $seq = mysqli_fetch_assoc(mysqli_query($con,"SELECT * FROM loan_sequence WHERE id='$seqid'"));
                echo $seq["name"];
               ?>
              </td>
              <td>KES <?php echo number_format($row["amount"]);?></td>
              <td>KES <?php echo number_format($row["amount_repayable"]);?></td>
              </td>
              <td><?php echo date("d M Y", strtotime($row["created_at"]));?></td>
              <td>
               <?php
               if($row["status"] == 1){ ?>
                <span class="btn btn-xs btn-warning">Pending</span>
               <?php }
               if($row["status"] == 2){ ?>
                <span class="btn btn-xs btn-info">Approved</span>
               <?php }
               if($row["status"] == 3){ ?>
                <span class="btn btn-xs btn-danger">Rejected</span>
               <?php }
               if($row["status"] == 4){ ?>
                <span class="btn btn-xs btn-success">Disbursed</span>
               <?php }
               ?>
              <td>
              <a href="<?php echo $portal_url;?>loan/<?php echo $row["loanNo"];?>"><button class="btn btn-xs btn-success" data-toggle="tooltip" data-placement="bottom" title="View loan details"><i class="fas fa-search-plus"></i></button></a>
              <?php if($row["status"] == 1 && $row["recommendation"] != ""){ ?>
               <button class="btn btn-xs btn-primary approve" id="<?php echo $row["id"];?>" data-status="2" data-toggle="tooltip" data-placement="bottom" data-caption="approve this loan application" title="Approve this loan application"><i class="fas fa-check"></i></button>
               <button class="btn btn-xs btn-danger approve" id="<?php echo $row["id"];?>" data-status="3" data-toggle="tooltip" data-placement="bottom" data-caption="reject this loan application" title="Reject this loan application"><i class="fa fa-times"></i></button>
              <?php } ?>
              </td>  
             </tr>
             <?php } }
            ?>
         </tbody>
       </table>
      </div>
    </div>
   </div>

  </div>
 </div>
</div>
</div>
</section>
<script src="<?php echo $base_url;?>assets/bootstrap/bootstrap.min.js"></script>
<script src="<?php echo $base_url;?>assets/js/dashboard.js"></script>
<script src="<?php echo $base_url;?>assets/js/jquery.dataTables.min.js"></script>
<script src="<?php echo $base_url;?>assets/js/dataTables.bootstrap4.min.js"></script>
<script>
$(function(){
 $("#loan").attr("class","active");
 $('#tb_loans').DataTable({"aaSorting":[]});

 //Approving loan application
 $(".approve").click(function(){
  var approve = $(this).attr("id");
  var status = $(this).attr("data-status");
  var caption = $(this).attr("data-caption");
  var d = confirm('Are you sure you want to '+caption+'?');
  if(d == false){
   return false;
  }
  else{
    $.ajax({
      method:"post",
      url: $("#portal_url").html()+"app/loans",
      data:{
        approve:approve,
        status:status
      },
      cache:false
    }).done(function(data){
      if(data.status == "200"){
       window.location.replace($("#portal_url").html()+"loans");
      }
    });
    }
   });
 });
</script>
</body>
</html>