<?php
ob_start();
session_start();
include_once("../config/index.php");
include_once("includes/auth.php");
$now = date('Y-m-d H:i:s');
?>
<!DOCTYPE html>
<html lang="en-US">
<head>
<meta charset="UTF-8">
<title>Expenses | Kuza Fine Africa</title>
<meta name="viewport" content="width=device-width,initial-scale=1">
<link rel="shortcut icon" href="<?php echo $base_url;?>assets/images/logo/favicon.ico">
<link href="<?php echo $base_url;?>assets/bootstrap/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="<?php echo $base_url;?>assets/css/dataTables.bootstrap4.min.css"/>
<link rel="stylesheet" href="<?php echo $base_url;?>assets/css/buttons.bootstrap4.min.css"/>
<link rel="stylesheet" href="<?php echo $base_url;?>assets/fontawesome/css/all.min.css"> 
<link href="<?php echo $base_url;?>assets/css/dashboard.css" rel="stylesheet">
<script src="<?php echo $base_url;?>assets/js/jquery.min.js"></script>
<style>
.modal-dialog{
  max-width: 450px;
}
form{
  padding-left: 5px;
  padding-right: 10px;
}
</style>
</head>
<body> 
<?php include_once("includes/header.php");?>
<section id="main">
<div class="container-fluid">
 <div class="row">
  <?php include_once("includes/aside.php");?>
  <div class="content">
   <div class="col-md-12">
    <div class="breadcrumbs row">
     <ul class="breadcrumb">
      <li><i class="fas fa-tachometer-alt"></i>&nbsp;Dashboard</li>
      <li><i class="fas fa-cart-arrow-down"></i> &nbsp;&nbsp;Expenses</li>
     </ul>
    </div>

    <div class="row wrapper">
      <button class="btn item item1" data-dismiss="modal" data-toggle="modal" data-target="#purchmodal"><i class="fa fa-plus"></i> New Expenditure</button>
      <span class="item item2" data-dismiss="modal" data-toggle="modal" data-target="#purchmodal" style="display: none;"></span>&nbsp;&nbsp;&nbsp;
      <button style="display:none" class="btn item" data-dismiss="modal" data-toggle="modal" data-target="#filtermodal"><i class="far fa-calendar-alt"></i> Filter by Date</button>
    </div>

     <div class="panel panel-default dashboard">
      <div class="panel-header dvtitle">Expenses</div>
      <div class="panel-body">
       <div class="table-responsive row">
        <table id="tb_purchs" class="table table-striped table-bordered" cellspacing="0" width="100%">
         <thead>
          <tr><th>Description</th><th>Amount</th><th>Date</th><th style="min-width: 100px;">Action</th></tr>
         </thead>
         <tbody>
         <?php
          $chkpurchs = mysqli_query($con,"SELECT * FROM expenses ORDER BY id DESC");
          while($row = mysqli_fetch_assoc($chkpurchs)){
             
          ?>
          <tr>
           <td><?php echo $row["description"];?></td>
           <td>Ksh. <?php echo number_format($row["amount"]);?></td>
           <td><?php echo date("d M Y",strtotime($row["expensedate"]));?></td>
           <td>
            <button class="btn btn-xs btn-primary edtpurch" data-toggle="tooltip" data-placement="bottom" title="Edit expense" data-expensedate="<?php echo $row['expensedate'] ?>" data-id="<?php echo $row["id"];?>" data-amount="<?php echo $row["amount"];?>" data-description="<?php echo $row['description'];?>"><i class="fas fa-pencil-alt"></i></button>
            <button class="btn btn-xs btn-danger delpurch" id="<?php echo $row["id"];?>" data-toggle="tooltip" data-placement="bottom" title="Delete expense"><i class="fa fa-trash"></i></button>
           </td>
          </tr>
          <?php } ?>
         </tbody>
        </table>
       </div>
      </div>
     </div>

     <div id="purchmodal" class="modal fade" role="dialog">
      <div class="modal-dialog">
       <div class="modal-content">
        <h3><i class="fas fa-cart-arrow-down"></i> New Expenditure<span class="close pull-right" data-dismiss="modal"><i class="fas fa-times"></i></span></h3>
        <form role="form" id="expensefrm">

        <div class="form-group">
         <label>Description <span>*</span></label>
         <input type="hidden" id="id" value="" name="id">
         <input type="text" class="form-control" id="description" name="description" required>
        </div>
        <div class="form-group">
         <label>Amount <span>*</span></label>
         <input type="number" class="form-control" id="amount" name="amount" required>
        </div>
        <div class="form-group">
         <label>Date of Expense <span>*</span></label>
         <input type="date" class="form-control" id="expensedate" name="expensedate" required>
        </div>
        <div class="form-group" style="border-top: 1px solid #ddd;padding-top: 5px;">
         <button class="btn btn-block" type="submit"> <i class="fa fa-save"></i> Save Expenditure</button>
        </div>
        <div class="form-group">
         <div id="status"></div>
        </div>
       </form>
      </div>
     </div>
    </div>
    
    <div id="filtermodal" class="modal fade" role="dialog">
   <div class="modal-dialog">
    <div class="modal-content">
     <h3><i class="far fa-calendar-alt"></i> Customized Duration Report<span class="close pull-right" data-dismiss="modal"><i class="fas fa-times"></i></span></h3>
     <form role="form" id="filterform">
      <div class="col-md-6">
       <div class="form-group">
        <label>Start Date <span>*</span></label>
        <input type="date" class="form-control" id="date1" required>
       </div>
      </div>
      <div class="col-md-6">
       <div class="form-group">
        <label>End Date <span>*</span></label>
        <input type="date" class="form-control" id="date2" required>
       </div>
      </div>
      <div class="form-group">
       <button class="btn btn-block" type="submit"><i class="fa fa-save"></i> Show Report</button>
      </div>
      <div class="form-group">
       <div id="filterstatus"></div>
      </div>
     </form>
    </div>
   </div>
  </div>

  </div>
 </div>
</div>
</div>
</section>
<script src="<?php echo $base_url;?>assets/bootstrap/bootstrap.min.js"></script>
<script src="<?php echo $base_url;?>assets/js/dashboard.js"></script>
<script src="<?php echo $base_url;?>assets/js/jquery.dataTables.min.js"></script>
<script src="<?php echo $base_url;?>assets/js/dataTables.bootstrap4.min.js"></script>
<script>
$(function(){
 $("#exp").attr("class","active");
 $('#tb_purchs').DataTable({"aaSorting":[]});

 $("body").on("click",".edtpurch",function(){
  $("#id").val($(this).attr("data-id"));
  $("#expensedate").val($(this).attr("data-expensedate"));
  $("#description").val($(this).attr("data-description"));
  $("#amount").val($(this).attr("data-amount"));
  $("#status").html("");
  $(".item1").click();
 });

 $("#expensefrm").submit(function(e){
  e.preventDefault();
  var id = $("#id").val();
  var expensedate = $("#expensedate").val();
  var description = $("#description").val();
  var amount = $("#amount").val();
  
  $("#status").html("<p class='text-success bg-success'><i class='fa fa-spinner fa-pulse'></i> Saving the expense...</p>"); 
  $.ajax({
    method: "POST",
    url: $("#portal_url").html()+"app/expenses",
    data: {
      id:id,
      expensedate:expensedate,
      description:description,
      amount:amount
    },
    cache:false
  }).done(function(data){
   if(data.status == 200){
    $("#status").html("<p class='alert alert-success'><i class='fa fa-check'></i> expense saved successfully.</p>").delay(5000);
     window.location.replace($("#portal_url").html()+"expense");
   }
   if(data.status == 300){
    $("#status").html("<p class='alert alert-danger'><i class='fa fa-exclamation-circle'></i> An error occured, please try again later.</p>");
   }
  });
 });

 //Deleting a expense
 $(".delpurch").click(function(){
  var delpurch = $(this).attr("id");
  var d = confirm('Are you sure you want to delete this expense?');
  if(d == false){
   return false;
  }
  else{
    $.ajax({
      method:"post",
      url: $("#portal_url").html()+"app/expenses",
      data:{
        delpurch:delpurch
      },
      cache:false
    }).done(function(data){
      if(data.status == "200"){
       window.location.replace($("#portal_url").html()+"expense");
      }
    });
    }
   });
   
   //Custom duration report
  $("#filterform").submit(function(e){
   e.preventDefault();
   var date1 = $("#date1").val();
   var date2 = $("#date2").val();
   $("#filterform .btn").attr("disabled","disabled");
   $("#filterstatus").html("<p class='alert alert-success' style='padding:10px;'><i class='fa fa-spinner fa-pulse'></i> Please wait....</p>");
   $.ajax({
    type: "POST",
    url: $("#portal_url").html()+"reports/expenses",
    data: {
      date1:date1,
      date2:date2
    },
    cache: false
   }).done(function(data){
    $("#filterform .btn").removeAttr("disabled");
    $("#filterstatus").html("");
    $(".dashboard").html(data);
    $('#filtermodal').modal('toggle');
    $('#tb_purchs').DataTable({"aaSorting": []});
   });
  });
 });
</script>
</body>
</html>