<?php
ob_start();
session_start();
include_once("../config/index.php");
include_once("includes/auth.php");
$now = date('Y-m-d H:i:s');
$branchid = $user["branchId"];
?>
<!DOCTYPE html>
<html lang="en-US">
<head>
<meta charset="UTF-8">
<title>Loan Applications | Kuza Work Africa</title>
<meta name="viewport" content="width=device-width,initial-scale=1">
<link rel="shortcut icon" href="<?php echo $base_url;?>assets/images/logo/favicon.ico">
<link href="<?php echo $base_url;?>assets/bootstrap/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="<?php echo $base_url;?>assets/css/dataTables.bootstrap4.min.css"/>
<link rel="stylesheet" href="<?php echo $base_url;?>assets/fontawesome/css/all.min.css"> 
<link href="<?php echo $base_url;?>assets/css/dashboard.css" rel="stylesheet">
<script src="<?php echo $base_url;?>assets/js/jquery.min.js"></script>
<style>
.modal-dialog{
  max-width: 800px !important;
}
.modal-dialog .col-md-4{
  padding: 2px;
}
form{
  padding-left: 5px;
  padding-right: 10px;
}
#loanfrm p{
  padding-left: 5px;
}
.custinfo,.bsinfo{
  border-bottom: 1px dashed #ddd;
  padding: 0;
  color: #c1c100;
}
.bsinfo{
  margin-top: 20px;
}
#loanmodal td{
  padding: 0!important;
  max-width: 200px;
  border-right: 1px solid #ddd;
}
#loanmodal td input{
  border: none;
  box-shadow: none;
  width: 100%;
}
</style>
</head>
<body> 
<?php include_once("includes/header.php");?>
<section id="main">
<div class="container-fluid">
 <div class="row">
   <?php include_once("includes/aside.php");?>
   <div class="content">
    <div class="col-md-12">
     <div class="breadcrumbs row">
      <ul class="breadcrumb">
       <li><i class="fas fa-tachometer-alt"></i>&nbsp;Dashboard</li>
       <li><i class="fas fa-hand-holding-usd"></i> &nbsp;&nbsp;Loan Applications</li>
      </ul>
    </div>

    <div class="row wrapper">
      <button class="btn item item1" data-dismiss="modal" data-toggle="modal" data-target="#loanmodal"><i class="fa fa-plus"></i> New loan application</button>
      <span class="item item2" data-dismiss="modal" data-toggle="modal" data-target="#loanmodal" style="display: none;"></span>
    </div>

     <div class="panel panel-default">
       <div class="panel-header dvtitle">Loan Applications</div>
       <div class="panel-body">
        <div class="table-responsive row">
        <table id="tb_loans" class="table table-striped table-bordered" cellspacing="0" width="100%">
         <thead>
           <tr><th>Loan No.</th><th>Customer</th><th>Loan Product</th><th>Sequence</th><th>Amount</th><th>Repayable</th><th>Date</th><th>Status</th><th style="min-width: 100px;">Action</th></tr>
          </thead>
           <tbody>
             <?php
             $chkloans = mysqli_query($con,"SELECT * FROM loan_applications ORDER BY id DESC LIMIT 100");
             while($row = mysqli_fetch_assoc($chkloans)){
              $custid = $row["custId"];
              $cust = mysqli_fetch_assoc(mysqli_query($con,"SELECT * FROM customers WHERE id='$custid'"));
              $loanid = $row["id"];
             if($cust["branchId"] == $branchid){
              $guarantor1 = mysqli_fetch_assoc(mysqli_query($con,"SELECT * FROM loan_guarantors WHERE loanId='$loanid' ORDER BY id ASC LIMIT 0,1"));
              $guarantor2 = mysqli_fetch_assoc(mysqli_query($con,"SELECT * FROM loan_guarantors WHERE loanId='$loanid' ORDER BY id ASC LIMIT 1,1"));
              $referee1 = mysqli_fetch_assoc(mysqli_query($con,"SELECT * FROM loan_referees WHERE loanId='$loanid' ORDER BY id ASC LIMIT 0,1"));
              $referee2 = mysqli_fetch_assoc(mysqli_query($con,"SELECT * FROM loan_referees WHERE loanId='$loanid' ORDER BY id ASC LIMIT 1,1"));
              $collateral1 = mysqli_fetch_assoc(mysqli_query($con,"SELECT * FROM loan_collaterals WHERE loanId='$loanid' ORDER BY id ASC LIMIT 0,1"));
              $collateral2 = mysqli_fetch_assoc(mysqli_query($con,"SELECT * FROM loan_collaterals WHERE loanId='$loanid' ORDER BY id ASC LIMIT 1,1"));
              $collateral3 = mysqli_fetch_assoc(mysqli_query($con,"SELECT * FROM loan_collaterals WHERE loanId='$loanid' ORDER BY id ASC LIMIT 2,1"));
              $collateral4 = mysqli_fetch_assoc(mysqli_query($con,"SELECT * FROM loan_collaterals WHERE loanId='$loanid' ORDER BY id ASC LIMIT 3,1"));
              $collateral5 = mysqli_fetch_assoc(mysqli_query($con,"SELECT * FROM loan_collaterals WHERE loanId='$loanid' ORDER BY id ASC LIMIT 4,1"));
             ?>
             <tr>
              <td><?php echo $row["loanNo"];?></td>
              <td>
               <?php
                echo $cust["first_name"]." ".$cust["last_name"]." (".$cust["custNo"].")";
               ?>
              </td>
              <td>
               <?php
                $prodid = $row["prodId"];
                $prod = mysqli_fetch_assoc(mysqli_query($con,"SELECT * FROM loan_products WHERE id='$prodid'"));
                echo $prod["name"];
               ?>
              </td>
              <td>
               <?php
                $seqid = $row["seqId"];
                $seq = mysqli_fetch_assoc(mysqli_query($con,"SELECT * FROM loan_sequence WHERE id='$seqid'"));
                echo $seq["name"];
               ?>
              </td>
              <td>KES <?php echo number_format($row["amount"]);?></td>
              <td>KES <?php echo number_format($row["amount_repayable"]);?></td>
              <td><?php echo date("d M Y",strtotime($row["created_at"]));?></td>
              <td>
               <?php
               if($row["userId"] == 0){ ?>
                <span class="btn btn-xs btn-info">New</span>
               <?php }
               else{ 
               if($row["status"] == 1){ ?>
                <span class="btn btn-xs btn-warning">Pending</span>
               <?php }
               if($row["status"] == 2){ ?>
                <span class="btn btn-xs btn-info">Approved</span>
               <?php }
               if($row["status"] == 3){ ?>
                <span class="btn btn-xs btn-danger">Rejected</span>
               <?php }
               if($row["status"] == 4){ ?>
                <span class="btn btn-xs btn-success">Disbursed</span>
               <?php } 
                }
               ?>
              </td>
              <td>
              <a href="<?php echo $portal_url;?>loan/<?php echo $row["loanNo"];?>"><button class="btn btn-xs btn-success" data-toggle="tooltip" data-placement="bottom" title="View loan details"><i class="fas fa-search-plus"></i></button></a>
              <?php if($row["recommended_by"] == 0){ ?>
               <button class="btn btn-xs btn-primary edtloan" data-toggle="tooltip" data-placement="bottom" title="Edit loan application" data-id="<?php echo $row["id"];?>" data-custid="<?php echo $row["custId"];?>" data-prodid="<?php echo $row["prodId"];?>" data-seqid="<?php echo $row["seqId"];?>" data-amount="<?php echo $row["amount"];?>" data-phone="<?php echo $row["mpesaNo"];?>" data-purpose="<?php echo $row["loan_purpose"];?>" data-ref1name="<?php echo $referee1["name"];?>" data-ref1address="<?php echo $referee1["address"];?>" data-ref1phone1="<?php echo $referee1["phone"];?>" data-ref1phone2="<?php echo $referee1["phone2"];?>" data-ref1rel="<?php echo $referee1["relationship"];?>" data-ref2name="<?php echo $referee2["name"];?>" data-ref2address="<?php echo $referee2["address"];?>" data-ref2phone1="<?php echo $referee2["phone"];?>" data-ref2phone2="<?php echo $referee2["phone2"];?>" data-ref2rel="<?php echo $referee2["relationship"];?>" data-guar1="<?php echo $guarantor1["name"];?>" data-guar1rel="<?php echo $guarantor1["relationship"];?>" data-guar1phone1="<?php echo $guarantor1["phone"];?>" data-guar1phone2="<?php echo $guarantor1["phone2"];?>" data-guar1occup="<?php echo $guarantor1["occupation"];?>" data-guar1resid="<?php echo $guarantor1["residence"];?>" data-guar1landmark="<?php echo $guarantor1["landmark"];?>" data-guar2="<?php echo $guarantor2["name"];?>" data-guar2rel="<?php echo $guarantor2["relationship"];?>" data-guar2phone1="<?php echo $guarantor2["phone"];?>" data-guar2phone2="<?php echo $guarantor2["phone2"];?>" data-guar2occup="<?php echo $guarantor2["occupation"];?>" data-guar2resid="<?php echo $guarantor2["residence"];?>" data-guar2landmark="<?php echo $guarantor2["landmark"];?>" data-item1="<?php echo $collateral1["description"];?>" data-item1serial="<?php echo $collateral1["serialno"];?>" data-item1value="<?php echo $collateral1["value"];?>" data-item2="<?php echo $collateral2["description"];?>" data-item2serial="<?php echo $collateral2["serialno"];?>" data-item2value="<?php echo $collateral2["value"];?>" data-item3="<?php echo $collateral3["description"];?>" data-item3serial="<?php echo $collateral3["serialno"];?>" data-item3value="<?php echo $collateral3["value"];?>" data-item4="<?php echo $collateral4["description"];?>" data-item4serial="<?php echo $collateral4["serialno"];?>" data-item4value="<?php echo $collateral4["value"];?>" data-item5="<?php echo $collateral5["description"];?>" data-item5serial="<?php echo $collateral5["serialno"];?>" data-item5value="<?php echo $collateral5["value"];?>" data-income="<?php echo $row["bfa_income"];?>" data-dailysales="<?php echo $row["bfa_dailysales"];?>" data-monthlysales="<?php echo $row["bfa_monthlysales"];?>" data-costofsales="<?php echo $row["bfa_costofsales"];?>" data-grossprofit="<?php echo $row["bfa_grossprofit"];?>" data-otherincome="<?php echo $row["bfa_otherincome"];?>" data-cummincome="<?php echo $row["bfa_cummincome"];?>" data-expenditure="<?php echo $row["bfa_expenditure"];?>" data-ttlnetincome="<?php echo $row["bfa_ttlnetincome"];?>" data-lessinstallments="<?php echo $row["bfa_lessinstallments"];?>" data-netincome="<?php echo $row["bfa_netincome"];?>"><i class="fas fa-pencil-alt"></i></button>
               <button class="btn btn-xs btn-danger delloan" id="<?php echo $row["id"];?>" data-toggle="tooltip" data-placement="bottom" title="Delete loan application"><i class="fa fa-trash"></i></button>
              <?php } ?>
              </td>  
             </tr>
             <?php } }
            ?>
         </tbody>
       </table>
      </div>
    </div>
   </div>
  

<div id="loanmodal" class="modal fade" role="dialog">
 <div class="modal-dialog">
  <div class="modal-content">
   <h3><i class="fas fa-users"></i> Loan Application Form<span class="close pull-right" data-dismiss="modal"><i class="fas fa-times"></i></span></h3>
   <form role="form" id="loanfrm">
   <p>Fill in loan details. All fields marked with <span style="color: #ff0000">*</span> are mandatory.</p> 
    <div class="col-md-12 custinfo">
     <h4>Loan Particulars</h4>
    </div>
    <div class="col-md-4">
     <div class="form-group">
      <label>Customer <span>*</span></label>
      <input type="hidden" id="id" value="">
      <select class="form-control" id="custid" onchange="custPhone()">
      <?php
       $chkcustomers = mysqli_query($con,"SELECT * FROM customers WHERE status='1' ORDER BY first_name ASC");
       while($row = mysqli_fetch_assoc($chkcustomers)){ ?>
        <option value="<?php echo $row["id"];?>" data-mpesano="<?php echo $row["phone"];?>"><?php echo $row["first_name"]." ".$row["middle_name"]." ".$row["last_name"]."(".$row["custNo"].")";?></option>
      <?php } ?>
      </select>
     </div>
    </div>
    <div class="col-md-4">
     <div class="form-group">
      <label>Loan product <span>*</span></label>
      <select class="form-control" id="prodid" onchange="loanProduct()">
      <?php
       $chkproducts = mysqli_query($con,"SELECT * FROM loan_products");
       while($row = mysqli_fetch_assoc($chkproducts)){ ?>
        <option value="<?php echo $row["id"];?>" data-maxvalue="<?php echo $row["maxamount"];?>"><?php echo $row["name"];?></option>
      <?php } ?>
      </select>
     </div>
    </div>
    <div class="col-md-4">
     <div class="form-group">
      <label>Loan Sequence <span>*</span></label>
      <select class="form-control" id="seqid">
      <?php
       $chksequence = mysqli_query($con,"SELECT * FROM loan_sequence");
       while($row = mysqli_fetch_assoc($chksequence)){ ?>
        <option value="<?php echo $row["id"];?>"><?php echo $row["name"];?></option>
      <?php } ?>
      </select>
     </div>
    </div>
    <div class="col-md-4">
     <div class="form-group">
      <label>Loan Amount <span>*</span></label>
      <input type="number" class="form-control" id="amount" min="500" required>
     </div>
    </div>
    <div class="col-md-4">
     <div class="form-group">
      <label>Mpesa Number <span>*</span></label>
      <input type="text" class="form-control" id="phone" required>
     </div>
    </div>
    <div class="col-md-4">
     <div class="form-group">
      <label>Purpose of Loan <span>*</span></label>
      <input type="text" class="form-control" id="purpose" required>
     </div>
    </div>
    <div class="col-md-4">
     <div class="form-group">
      <label>Is Topup? <span>*</span></label>
      <select class="form-control" id="istopup" required>
      <option value="">Select</option>
      <option value="1">Yes</option>
      <option value="2">No</option>
      </select>
     </div>
    </div>
    

    <div class="col-md-12 bsinfo">
     <h4>Loan Referees</h4>
    </div>
    <div class="table-responsive">
    <table class="table table-bordered" style="min-width: 700px !important;">
     <thead>
     <tr><th>Name</th><th>Address</th><th>Phone 1</th><th>Phone 2</th><th>Relationship</th></tr>
     </thead>
     <tbody>
     <tr>
      <td><input type="text" id="ref1name"></td>
      <td><input type="text" id="ref1address"></td>
      <td><input type="text" id="ref1phone1"></td>
      <td><input type="text" id="ref1phone2"></td>
      <td><input type="text" id="ref1rel"></td>
     </tr>
     <tr>
      <td><input type="text" id="ref2name"></td>
      <td><input type="text" id="ref2address"></td>
      <td><input type="text" id="ref2phone1"></td>
      <td><input type="text" id="ref2phone2"></td>
      <td><input type="text" id="ref2rel"></td>
     </tr>
     </tbody>
    </table>
    </div>
    

    <div class="col-md-12 bsinfo">
     <h4>Loan Guarantors</h4>
    </div>
    <div class="table-responsive">
    <table class="table table-bordered" style="min-width: 800px !important;">
     <thead>
     <tr><th>Name</th><th>Relationship</th><th>Phone 1</th><th>Phone 2</th><th>Occupation</th><th>Residence</th><th>Landmark</th></tr>
     </thead>
     <tbody>
     <tr>
      <td><input type="text" id="guar1"></td>
      <td><input type="text" id="guar1rel"></td>
      <td><input type="text" id="guar1phone1"></td>
      <td><input type="text" id="guar1phone2"></td>
      <td><input type="text" id="guar1occup"></td>
      <td><input type="text" id="guar1resid"></td>
      <td><input type="text" id="guar1landmark"></td>
     </tr>
     <tr>
      <td><input type="text" id="guar2"></td>
      <td><input type="text" id="guar2rel"></td>
      <td><input type="text" id="guar2phone1"></td>
      <td><input type="text" id="guar2phone2"></td>
      <td><input type="text" id="guar2occup"></td>
      <td><input type="text" id="guar2resid"></td>
      <td><input type="text" id="guar2landmark"></td>
     </tr>
     </tbody>
    </table>
    </div>
    

    <div class="col-md-12 bsinfo">
     <h4>Loan Collaterals</h4>
    </div>
    <div class="table-responsive">
    <table class="table table-bordered">
     <thead>
     <tr><th>Item Description</th><th>Serial No.</th><th>Estimate value</th></tr>
     </thead>
     <tbody>
     <tr>
      <td><input type="text" id="item1"></td>
      <td><input type="text" id="item1serial"></td>
      <td><input type="text" id="item1value"></td>
     </tr>
     <tr>
      <td><input type="text" id="item2"></td>
      <td><input type="text" id="item2serial"></td>
      <td><input type="text" id="item2value"></td>
     </tr>
     <tr>
      <td><input type="text" id="item3"></td>
      <td><input type="text" id="item3serial"></td>
      <td><input type="text" id="item3value"></td>
     </tr>
     <tr>
      <td><input type="text" id="item4"></td>
      <td><input type="text" id="item4serial"></td>
      <td><input type="text" id="item4value"></td>
     </tr>
     <tr>
      <td><input type="text" id="item5"></td>
      <td><input type="text" id="item5serial"></td>
      <td><input type="text" id="item5value"></td>
     </tr>
     </tbody>
    </table>
    </div>

    <div class="col-md-12 bsinfo">
     <h4>Business Financial Analysis</h4>
    </div>
    <div class="col-md-4">
     <div class="form-group">
      <label>Income</label>
      <input type="number" class="form-control" id="income">
     </div>
    </div>
    <div class="col-md-4">
     <div class="form-group">
      <label>Total daily sales</label>
      <input type="number" class="form-control" id="dailysales">
     </div>
    </div>
    <div class="col-md-4">
     <div class="form-group">
      <label>Comm: monthly sales</label>
      <input type="number" class="form-control" id="monthlysales">
     </div>
    </div>
    <div class="col-md-4">
     <div class="form-group">
      <label>Less cost of sales</label>
      <input type="number" class="form-control" id="costofsales">
     </div>
    </div>
    <div class="col-md-4">
     <div class="form-group">
      <label>Gross profit(A)</label>
      <input type="number" class="form-control" id="grossprofit">
     </div>
    </div>
    <div class="col-md-4">
     <div class="form-group">
      <label>Income from other sources</label>
      <input type="number" class="form-control" id="otherincome">
     </div>
    </div>
    <div class="col-md-4">
     <div class="form-group">
      <label>Total cumm incomes (B)</label>
      <input type="number" class="form-control" id="cummincome">
     </div>
    </div>
    <div class="col-md-4">
     <div class="form-group">
      <label>Expenditure patterns(C)</label>
      <input type="number" class="form-control" id="expenditure">
     </div>
    </div>
    <div class="col-md-4">
     <div class="form-group">
      <label>Total net income (B-C)</label>
      <input type="number" class="form-control" id="ttlnetincome">
     </div>
    </div>
    <div class="col-md-4">
     <div class="form-group">
      <label>Less loan installment</label>
      <input type="number" class="form-control" id="lessinstallments">
     </div>
    </div>
    <div class="col-md-4">
     <div class="form-group">
      <label>Net income after loan instalmnt</label>
      <input type="number" class="form-control" id="netincome">
     </div>
    </div>

    <div class="form-group" style="border-top: 1px solid #ddd;padding-top: 5px;">
      <button class="btn btn-block" type="submit"> <i class="fa fa-save"></i> Submit Application</button>
    </div>
    <div class="form-group">
     <div id="status"></div>
    </div>
   </form>
  </div>
 </div>
</div>

  </div>
 </div>
</div>
</div>
</section>
<script src="<?php echo $base_url;?>assets/bootstrap/bootstrap.min.js"></script>
<script src="<?php echo $base_url;?>assets/js/dashboard.js"></script>
<script src="<?php echo $base_url;?>assets/js/jquery.dataTables.min.js"></script>
<script src="<?php echo $base_url;?>assets/js/dataTables.bootstrap4.min.js"></script>
<script>
$("#prodid").change(function () {
     var maxvalue=$(this).find(':selected').data('maxvalue');
     $("#amount").attr("max",maxvalue);
});
$("#custid").change(function () {
     var mpesano=$(this).find(':selected').data('mpesano');
     $("#phone").val(mpesano);
});
$(function(){
 $("#loan").attr("class","active");
 $('#tb_loans').DataTable({"aaSorting":[]});

 $("body").on("click",".edtloan",function(){
  $("#id").val($(this).attr("data-id"));
  $("#custid").val($(this).attr("data-custid"));
  $("#prodid").val($(this).attr("data-prodid"));
  $("#seqid").val($(this).attr("data-seqid"));
  $("#amount").val($(this).attr("data-amount"));
  $("#phone").val($(this).attr("data-phone"));
  $("#purpose").val($(this).attr("data-purpose"));
  $("#ref1name").val($(this).attr("data-ref1name"));
  $("#ref1address").val($(this).attr("data-ref1address"));
  $("#ref1phone1").val($(this).attr("data-ref1phone1"));
  $("#ref1phone2").val($(this).attr("data-ref1phone2"));
  $("#ref1rel").val($(this).attr("data-ref1rel"));
  $("#ref2name").val($(this).attr("data-ref2name"));
  $("#ref2address").val($(this).attr("data-ref2address"));
  $("#ref2phone1").val($(this).attr("data-ref2phone1"));
  $("#ref2phone2").val($(this).attr("data-ref2phone2"));
  $("#ref2rel").val($(this).attr("data-ref2rel"));
  $("#guar1").val($(this).attr("data-guar1"));
  $("#guar1rel").val($(this).attr("data-guar1rel"));
  $("#guar1phone1").val($(this).attr("data-guar1phone1"));
  $("#guar1phone2").val($(this).attr("data-guar1phone2"));
  $("#guar1occup").val($(this).attr("data-guar1occup"));
  $("#guar1resid").val($(this).attr("data-guar1resid"));
  $("#guar1landmark").val($(this).attr("data-guar1landmark"));
  $("#guar2").val($(this).attr("data-guar2"));
  $("#guar2rel").val($(this).attr("data-guar2rel"));
  $("#guar2phone1").val($(this).attr("data-guar2phone1"));
  $("#guar2phone2").val($(this).attr("data-guar2phone2"));
  $("#guar2occup").val($(this).attr("data-guar2occup"));
  $("#guar2resid").val($(this).attr("data-guar2resid"));
  $("#guar2landmark").val($(this).attr("data-guar2landmark"));
  $("#item1").val($(this).attr("data-item1"));
  $("#item1serial").val($(this).attr("data-item1serial"));
  $("#item1value").val($(this).attr("data-item1value"));
  $("#item2").val($(this).attr("data-item2"));
  $("#item2serial").val($(this).attr("data-item2serial"));
  $("#item2value").val($(this).attr("data-item2value"));
  $("#item3").val($(this).attr("data-item3"));
  $("#item3serial").val($(this).attr("data-item3serial"));
  $("#item3value").val($(this).attr("data-item3value"));
  $("#item4").val($(this).attr("data-item4"));
  $("#item4serial").val($(this).attr("data-item4serial"));
  $("#item4value").val($(this).attr("data-item4value"));
  $("#item5").val($(this).attr("data-item5"));
  $("#item5serial").val($(this).attr("data-item5serial"));
  $("#item5value").val($(this).attr("data-item5value"));
  $("#income").val($(this).attr("data-income"));
  $("#dailysales").val($(this).attr("data-dailysales"));
  $("#monthlysales").val($(this).attr("data-monthlysales"));
  $("#costofsales").val($(this).attr("data-costofsales"));
  $("#grossprofit").val($(this).attr("data-grossprofit"));
  $("#otherincome").val($(this).attr("data-otherincome"));
  $("#cummincome").val($(this).attr("data-cummincome"));
  $("#expenditure").val($(this).attr("data-expenditure"));
  $("#ttlnetincome").val($(this).attr("data-ttlnetincome"));
  $("#lessinstallments").val($(this).attr("data-lessinstallments"));
  $("#netincome").val($(this).attr("data-netincome"));
  $("#status").html("");
  $(".item2").click();
 });

 $("#loanfrm").submit(function(e){
  e.preventDefault();
  var id = $("#id").val();
  var custid = $("#custid").val();
  var prodid = $("#prodid").val();
  var seqid = $("#seqid").val();
  var amount = $("#amount").val();
  var phone = $("#phone").val();
  var purpose = $("#purpose").val();
  var ref1name = $("#ref1name").val();
  var ref1address = $("#ref1address").val();
  var ref1phone1 = $("#ref1phone1").val();
  var ref1phone2 = $("#ref1phone2").val();
  var ref1rel = $("#ref1rel").val();
  var ref2name = $("#ref2name").val();
  var ref2address = $("#ref2address").val();
  var ref2phone1 = $("#ref2phone1").val();
  var ref2phone2 = $("#ref2phone2").val();
  var ref2rel = $("#ref2rel").val();
  var guar1 = $("#guar1").val();
  var guar1rel = $("#guar1rel").val();
  var guar1phone1 = $("#guar1phone1").val();
  var guar1phone2 = $("#guar1phone2").val();
  var guar1occup = $("#guar1occup").val();
  var guar1resid = $("#guar1resid").val();
  var guar1landmark = $("#guar1landmark").val();
  var guar2 = $("#guar2").val();
  var guar2rel = $("#guar2rel").val();
  var guar2phone1 = $("#guar2phone1").val();
  var guar2phone2 = $("#guar2phone2").val();
  var guar2occup = $("#guar2occup").val();
  var guar2resid = $("#guar2resid").val();
  var guar2landmark = $("#guar2landmark").val();
  var item1 = $("#item1").val();
  var item1serial = $("#item1serial").val();
  var item1value = $("#item1value").val();
  var item2 = $("#item2").val();
  var item2serial = $("#item2serial").val();
  var item2value = $("#item2value").val();
  var item3 = $("#item3").val();
  var item3serial = $("#item3serial").val();
  var item3value = $("#item3value").val();
  var item4 = $("#item4").val();
  var item4serial = $("#item4serial").val();
  var item4value = $("#item4value").val();
  var item5 = $("#item5").val();
  var item5serial = $("#item5serial").val();
  var item5value = $("#item5value").val();
  var income = $("#income").val();
  var dailysales = $("#dailysales").val();
  var monthlysales = $("#monthlysales").val();
  var costofsales = $("#costofsales").val();
  var grossprofit = $("#grossprofit").val();
  var otherincome = $("#otherincome").val();
  var cummincome = $("#cummincome").val();
  var expenditure = $("#expenditure").val();
  var ttlnetincome = $("#ttlnetincome").val();
  var lessinstallments = $("#lessinstallments").val();
  var netincome = $("#netincome").val(); 
  var istopup=$("#istopup").val();
  $("#status").html("<p class='text-success bg-success'><i class='fa fa-spinner fa-pulse'></i> Saving the loan details...</p>"); 
  $.ajax({
    method: "POST",
    url: "app/loans",
    data: {
      id:id,
      custid:custid,
      prodid:prodid,
      seqid:seqid,
      amount:amount,
      phone:phone,
      purpose:purpose,
      ref1name:ref1name,
      ref1address:ref1address,
      ref1phone1:ref1phone1,
      ref1phone2:ref1phone2,
      ref1rel:ref1rel,
      ref2name:ref2name,
      ref2address:ref2address,
      ref2phone1:ref2phone1,
      ref2phone2:ref2phone2,
      ref2rel:ref2rel,
      guar1:guar1,
      guar1rel:guar1rel,
      guar1phone1:guar1phone1,
      guar1phone2:guar1phone2,
      guar1occup:guar1occup,
      guar1resid:guar1resid,
      guar1landmark:guar1landmark,
      guar2:guar2,
      guar2rel:guar2rel,
      guar2phone1:guar2phone1,
      guar2phone2:guar2phone2,
      guar2occup:guar2occup,
      guar2resid:guar2resid,
      guar2landmark:guar2landmark,
      item1:item1,
      item1serial:item1serial,
      item1value:item1value,
      item2:item2,
      item2serial:item2serial,
      item2value:item2value,
      item3:item3,
      item3serial:item3serial,
      item3value:item3value,
      item4:item4,
      item4serial:item4serial,
      item4value:item4value,
      item5:item5,
      item5serial:item5serial,
      item5value:item5value,
      income:income,
      dailysales:dailysales,
      monthlysales:monthlysales,
      costofsales:costofsales,
      grossprofit:grossprofit,
      otherincome:otherincome,
      cummincome:cummincome,
      expenditure:expenditure,
      ttlnetincome:ttlnetincome,
      lessinstallments:lessinstallments,
      netincome:netincome,
      istopup:istopup
    },
    cache:false
  }).done(function(data){
   if(data.status == 200){
    $("#status").html("<p class='alert alert-success'><i class='fa fa-check'></i> loan saved successfully.</p>").delay(5000);
     window.location.replace($("#portal_url").html()+"loans");
   }
   if(data.status == 403){
    $("#status").html("<p class='alert alert-danger'><i class='fa fa-exclamation-circle'></i> You are not allowed to register loans.</p>");
   }
   if(data.status == 300){
    $("#status").html("<p class='alert alert-danger'><i class='fa fa-exclamation-circle'></i> An error occured, please try again later.</p>");
   }
   if(data.status == 401){
    $("#status").html("<p class='alert alert-danger'><i class='fa fa-exclamation-circle'></i> The customer has an existing loan that is not fully paid.</p>");
   }
  });
 });

 //Deleting a loan
 $(".delloan").click(function(){
  var delloan = $(this).attr("id");
  var d = confirm('Are you sure you want to delete this loan application?');
  if(d == false){
   return false;
  }
  else{
    $.ajax({
      method:"post",
      url: $("#portal_url").html()+"app/loans",
      data:{
        delloan:delloan
      },
      cache:false
    }).done(function(data){
      if(data.status == "200"){
       window.location.replace($("#portal_url").html()+"loans");
      }
    });
    }
   });
 });
</script>
</body>
<?php mysqli_close($con) ?>
</html>