<?php
ob_start();
session_start();
include_once("../config/index.php");
include_once("includes/auth.php");
$now = date('Y-m-d H:i:s');
?>
<!DOCTYPE html>
<html lang="en-US">
<head>
<meta charset="UTF-8">
<title>Loan Applications | Kuza Work Africa</title>
<meta name="viewport" content="width=device-width,initial-scale=1">
<link rel="shortcut icon" href="<?php echo $base_url;?>assets/images/logo/favicon.ico">
<link href="<?php echo $base_url;?>assets/bootstrap/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="<?php echo $base_url;?>assets/css/dataTables.bootstrap4.min.css"/>
<link rel="stylesheet" href="<?php echo $base_url;?>assets/css/buttons.bootstrap4.min.css"/>
<link rel="stylesheet" href="<?php echo $base_url;?>assets/fontawesome/css/all.min.css"> 
<link href="<?php echo $base_url;?>assets/css/dashboard.css" rel="stylesheet">
<script src="<?php echo $base_url;?>assets/js/jquery.min.js"></script>
</head>
<body> 
<?php include_once("includes/header.php");?>
<section id="main">
<div class="container-fluid">
 <div class="row">
   <?php include_once("includes/aside.php");?>
   <div class="content">
    <div class="col-md-12">
     <div class="breadcrumbs row">
      <ul class="breadcrumb">
       <li><i class="fas fa-tachometer-alt"></i>&nbsp;Dashboard</li>
       <li><i class="fas fa-hand-holding-usd"></i> &nbsp;&nbsp;Loan Applications</li>
      </ul>
    </div>

    <div class="row wrapper">
      <button class="btn item" data-dismiss="modal" data-toggle="modal" data-target="#filtermodal"><i class="far fa-calendar-alt"></i> Filter by Date</button>
    </div>

     <div class="row report">
      <div class="col-md-12 summary">
       <p>Loan Amount: <span>Ksh <?php echo number_format(mysqli_fetch_assoc(mysqli_query($con,"SELECT SUM(amount) AS amt FROM loan_applications"))["amt"]);?></span></p>
       <p>Period: <span>All Time</span></p>
       </div>
       <div class="col-md-12">
        <div class="table-responsive row">
        <table id="tb_loans" class="table table-striped table-bordered" cellspacing="0" width="100%">
         <thead>
           <tr><th>Loan No.</th><th>Customer</th><th>Loan Product</th><th>Sequence</th><th>Amount</th><th>Repayable</th><th>Status</th><th>Date</th><th>Mode</th><th></th><th style="min-width: 100px;">Action</th></tr>
          </thead>
           <tbody>
             <?php
             $chkloans = mysqli_query($con,"SELECT * FROM loan_applications ORDER BY id DESC");
             while($row = mysqli_fetch_assoc($chkloans)){ ?>
             <tr>
              <td><?php echo $row["loanNo"];?></td>
              <td>
               <?php
                $custid = $row["custId"];
                $cust = mysqli_fetch_assoc(mysqli_query($con,"SELECT * FROM customers WHERE id='$custid'"));
                echo $cust["first_name"]." ".$cust["last_name"]." (".$cust["custNo"].")";
               ?>
              </td>
              <td>
               <?php
                $prodid = $row["prodId"];
                $prod = mysqli_fetch_assoc(mysqli_query($con,"SELECT * FROM loan_products WHERE id='$prodid'"));
                echo $prod["name"];
               ?>
              </td>
              <td>
               <?php
                $seqid = $row["seqId"];
                $seq = mysqli_fetch_assoc(mysqli_query($con,"SELECT * FROM loan_sequence WHERE id='$seqid'"));
                echo $seq["name"];
               ?>
              </td>
              <td>KES <?php echo number_format($row["amount"]);?></td>
              <td>KES <?php echo number_format($row["amount_repayable"]);?></td>
              <td>
               <?php
               if($row["status"] == 1){ ?>
                <span class="btn btn-xs btn-warning">Pending</span>
               <?php }
               if($row["status"] == 2){ ?>
                <span class="btn btn-xs btn-info">Approved</span>
               <?php }
               if($row["status"] == 3){ ?>
                <span class="btn btn-xs btn-danger">Rejected</span>
               <?php }
               if($row["status"] == 4){ ?>
                <span class="btn btn-xs btn-success">Disbursed</span>
               <?php }
               ?>
              </td>
              <td><?php echo date("d M Y", strtotime($row["created_at"]));?></td>
              <td><?php echo $row["thelead"];?></td>
              <td>
                <?php
                if($row["hasloan"]==1){
                    echo "hasloan";
                }
                ?>
              </td>
              <td>
                  <?php if($row["status"] == 1 && $row["recommendation"] != ""){ ?>
               <button class="btn btn-xs btn-primary approve" id="<?php echo $row["id"];?>" data-status="2" data-toggle="tooltip" data-placement="bottom" data-caption="approve this loan application" title="Approve this loan application"><i class="fas fa-check"></i></button>
               <button class="btn btn-xs btn-danger approve" id="<?php echo $row["id"];?>" data-status="3" data-toggle="tooltip" data-placement="bottom" data-caption="reject this loan application" title="Reject this loan application"><i class="fa fa-times"></i></button>
              <?php } ?>
              <a href="<?php echo $portal_url;?>loan/<?php echo $row["loanNo"];?>"><button class="btn btn-xs btn-success" data-toggle="tooltip" data-placement="bottom" title="View loan details"><i class="fas fa-search-plus"></i></button></a>
              <a target="_blank" href="<?php echo $portal_url;?>pdf/loan-statement?loanNo=<?php echo $row["loanNo"];?>"><button class="btn btn-xs btn-info" data-toggle="tooltip" data-placement="bottom" title="Print loan statement"><i class="fas fa-file-pdf"></i></button></a>
              </td>  
             </tr>
             <?php }
            ?>
         </tbody>
       </table>
      </div>
    </div>
   </div>

     <div id="filtermodal" class="modal fade" role="dialog">
       <div class="modal-dialog">
       <div class="modal-content">
        <h3><i class="far fa-calendar-alt"></i> Customized Duration Report<span class="close pull-right" data-dismiss="modal"><i class="fas fa-times"></i></span></h3>
        <form role="form" id="filterform">
          <div class="col-md-6">
           <div class="form-group">
            <label>Start Date <span>*</span></label>
            <input type="date" class="form-control" id="date1" required>
           </div>
          </div>
          <div class="col-md-6">
           <div class="form-group">
            <label>End Date <span>*</span></label>
            <input type="date" class="form-control" id="date2" required>
           </div>
          </div>
          <div class="form-group">
           <button class="btn btn-block" type="submit"><i class="fa fa-save"></i> Show Report</button>
          </div>
          <div class="form-group">
           <div id="filterstatus"></div>
          </div>
         </form>
        </div>
       </div>
      </div>

  </div>
 </div>
</div>
</div>
</section>
<script src="<?php echo $base_url;?>assets/bootstrap/bootstrap.min.js"></script>
<script src="<?php echo $base_url;?>assets/js/dashboard.js"></script>
<script src="<?php echo $base_url;?>assets/js/jquery.dataTables.min.js"></script>
<script src="<?php echo $base_url;?>assets/js/dataTables.bootstrap4.min.js"></script>
<?php include_once("includes/buttons.php");?>
<script>
$(function(){
 $("#lnapp").attr("class","active");
 function dataTables(tb){
 var table = $('#'+tb+'').DataTable({
  lengthChange: false,
  "aaSorting": [],
  "buttons": [
  {"extend": 'copy', "text":'<i class="fas fa-copy"></i> Copy',"className": 'btn btn-success btn-sm'},
  {"extend": 'csv', "text":'<i class="fas fa-file-csv"></i> CSV',"className": 'btn btn-success btn-sm'},
  {"extend": 'excel', "text":'<i class="fas fa-file-excel"></i> Excel',"className": 'btn btn-success btn-sm' },
  {"extend": 'pdf', "text":'<i class="fas fa-file-pdf"></i> PDF',"className": 'btn btn-success btn-sm'},
  {"extend": 'print', "text":'<i class="fas fa-print"></i> Print',"className": 'btn btn-success btn-sm'}
  ]
 }); 
 table.buttons().container().appendTo( '#'+tb+'_wrapper .col-md-6:eq(0)' );
 }
 dataTables("tb_loans");
 
 //Approving loan application
 //$(".approve").click(function(){
 $("body").on("click",".approve",function(){
  var approve = $(this).attr("id");
  var status = $(this).attr("data-status");
  var caption = $(this).attr("data-caption");
  var d = confirm('Are you sure you want to '+caption+'?');
  if(d == false){
   return false;
  }
  else{
    $.ajax({
      method:"post",
      url: $("#portal_url").html()+"app/loans",
      data:{
        approve:approve,
        status:status
      },
      cache:false
    }).done(function(data){
      if(data.status == "200"){
       window.location.replace($("#portal_url").html()+"loan-applications");
      }
    });
    }
   });

  //Custom duration report
  $("#filterform").submit(function(e){
   e.preventDefault();
   var date1 = $("#date1").val();
   var date2 = $("#date2").val();
   $("#filterform .btn").attr("disabled","disabled");
   $("#filterstatus").html("<p class='alert alert-success' style='padding:10px;'><i class='fa fa-spinner fa-pulse'></i> Please wait....</p>");
   $.ajax({
    type: "POST",
    url: $("#portal_url").html()+"reports/loans",
    data: {
      date1:date1,
      date2:date2,
      prod:"0"
    },
    cache: false
   }).done(function(data){
    $("#filterform .btn").removeAttr("disabled");
    $("#filterstatus").html("");
    $(".report").html(data);
    $('#filtermodal').modal('toggle');
    dataTables("tb_loans");
   });
  });
 });
</script>
</body>
</html>