<?php
ob_start();
session_start();
include_once("../config/index.php");
include_once("includes/auth.php");
$now = date('Y-m-d H:i:s');
?>
<!DOCTYPE html>
<html lang="en-US">
<head>
<meta charset="UTF-8">
<title>M-Pesa Paybill Payments | Kuza Work Africa</title>
<meta name="viewport" content="width=device-width,initial-scale=1">
<link rel="shortcut icon" href="<?php echo $base_url;?>assets/images/logo/favicon.ico">
<link href="<?php echo $base_url;?>assets/bootstrap/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="<?php echo $base_url;?>assets/css/dataTables.bootstrap4.min.css"/>
<link rel="stylesheet" href="<?php echo $base_url;?>assets/fontawesome/css/all.min.css"> 
<link href="<?php echo $base_url;?>assets/css/dashboard.css" rel="stylesheet">
<script src="<?php echo $base_url;?>assets/js/jquery.min.js"></script>
</head>
<body> 
<?php include_once("includes/header.php");?>
<section id="main">
<div class="container-fluid">
 <div class="row">
   <?php include_once("includes/aside.php");?>
   <div class="content">
    <div class="col-md-12">
     <div class="breadcrumbs row">
      <ul class="breadcrumb">
       <li><i class="fas fa-tachometer-alt"></i>&nbsp;Dashboard</li>
       <li><i class="fas fa-file-invoice-dollar"></i> &nbsp;M-Pesa Payments</li>
      </ul>
    </div>

    <div class="table-responsive">
     <table id="tb_pymts" class="table table-striped table-bordered" cellspacing="0" width="100%">
      <thead>
       <tr><th>Name</th><th>phone</th><th>Paybill</th><th>Acc/No</th><th>Amount</th><th>M-Pesa Code</th><th style="min-width: 100px;">Date-Time</th></tr>
      </thead>
      <tbody>
       <?php
        $chkpayments = mysqli_query($con,"SELECT * FROM mpesac2b ORDER BY id DESC");
        while($row = mysqli_fetch_assoc($chkpayments)){ ?>
        <tr>
          <td><?php echo $row["first_name"]." ".$row["middle_name"]." ".$row["last_name"];?></td>
          <td><?php echo $row["phone"];?></td>
          <td><?php echo $row["paybill"];?></td>
          <td><?php echo $row["accno"];?></td>
          <td>Ksh <?php echo number_format($row["amount"]);?></td>
          <td><?php echo $row["txncode"];?></td>
          <td><?php echo date("d M Y H:i", strtotime($row["transtime"]));?></td>
        </tr>
       <?php } ?>
      </tbody>
     </table>
    </div>

  </div>
 </div>
</div>
</div>
</section>
<script src="<?php echo $base_url;?>assets/js/jquery.min.js"></script>
<script src="<?php echo $base_url;?>assets/bootstrap/bootstrap.min.js"></script>
<script src="<?php echo $base_url;?>assets/js/dashboard.js"></script>
<script src="<?php echo $base_url;?>assets/js/jquery.dataTables.min.js"></script>
<script src="<?php echo $base_url;?>assets/js/dataTables.bootstrap4.min.js"></script>
<script>
$(function(){
 $("#pymt").attr("class","active");
 $('#tb_pymts').DataTable({"aaSorting" : []});
});
</script>
</body>
</html>