<?php
ob_start();
session_start();
include_once("../config/index.php");
include_once("includes/auth.php");
$now = date('Y-m-d H:i:s');
?>
<!DOCTYPE html>
<html lang="en-US">
<head>
<meta charset="UTF-8">
<title>Ussd Loan Disbursements | Kuza Work Africa</title>
<meta name="viewport" content="width=device-width,initial-scale=1">
<link rel="shortcut icon" href="<?php echo $base_url;?>assets/images/logo/favicon.ico">
<link href="<?php echo $base_url;?>assets/bootstrap/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="<?php echo $base_url;?>assets/css/dataTables.bootstrap4.min.css"/>
<link rel="stylesheet" href="<?php echo $base_url;?>assets/css/buttons.bootstrap4.min.css"/>
<link rel="stylesheet" href="<?php echo $base_url;?>assets/fontawesome/css/all.min.css"> 
<link href="<?php echo $base_url;?>assets/css/dashboard.css" rel="stylesheet">
<script src="<?php echo $base_url;?>assets/js/jquery.min.js"></script>
</head>
<body> 
<?php include_once("includes/header.php");?>
<section id="main">
<div class="container-fluid">
 <div class="row">
  <?php include_once("includes/aside.php");?>
  <div class="content">
   <div class="col-md-12">
    <div class="breadcrumbs row">
     <ul class="breadcrumb">
      <li><i class="fas fa-tachometer-alt"></i>&nbsp;Dashboard</li>
      <li><i class="fas fa-chart-line"></i> &nbsp;&nbsp;Ussd Loan Disbursements</li>
     </ul>
    </div>

    <div class="row wrapper">
      <button class="btn item" data-dismiss="modal" data-toggle="modal" data-target="#filtermodal"><i class="far fa-calendar-alt"></i> Filter by Date</button>
    </div>

    <div class="row report">
     <div class="col-md-12 summary">
     <p>Total Disbursed: <span>Ksh <?php echo number_format(mysqli_fetch_assoc(mysqli_query($con,"SELECT SUM(amount) AS amt FROM loan_applications WHERE disbursed_by!='0' AND thelead='ussd'"))["amt"]);?></span></p>
     <p>Period: <span>All Time</span></p>
     </div>
     <div class="col-md-12">
      <div class="table-responsive">
     <table id="tb_disb" class="table table-striped table-bordered" cellspacing="0" width="100%">
      <thead>
       <tr><th>Loan No</th><th>Customer Name</th><th>Phone</th><th>Loan Amount</th><th>Disbursed Amt</th><th>Txn Code</th><th style="min-width: 100px;">Date</th></tr>
      </thead>
      <tbody>
      <?php
       $chkdisbs = mysqli_query($con,"SELECT * FROM loan_applications WHERE disbursed_by!='0' AND thelead='ussd' ORDER BY id DESC");
       while($row = mysqli_fetch_assoc($chkdisbs)){  ?>
       <tr>
        <td><?php echo $row["loanNo"];?></td>
        <td>
          <?php 
          $custid = $row["custId"];
          $cust = mysqli_fetch_assoc(mysqli_query($con,"SELECT * FROM customers WHERE id='$custid'"));
          echo $cust["first_name"]." ".$cust["last_name"];
          ?>
        </td>
        <td><?php echo $cust["phone"];?>
        <td>Ksh <?php echo number_format($row["amount"]);?></td>
        <td>Ksh <?php echo number_format($row["disbursed_amount"]);?></td>
        <td><?php echo $row["txncode"];?>
        <td><?php echo date("d M Y H:i", strtotime($row["disbursed_at"]));?></td>
       </tr>
      <?php } ?>
      </tbody>
     </table>
    </div>
     </div>
    </div>

     <div id="filtermodal" class="modal fade" role="dialog">
       <div class="modal-dialog">
       <div class="modal-content">
        <h3><i class="far fa-calendar-alt"></i> Customized Duration Report<span class="close pull-right" data-dismiss="modal"><i class="fas fa-times"></i></span></h3>
        <form role="form" id="filterform">
          <div class="col-md-6">
           <div class="form-group">
            <label>Start Date <span>*</span></label>
            <input type="date" class="form-control" id="date1" required>
           </div>
          </div>
          <div class="col-md-6">
           <div class="form-group">
            <label>End Date <span>*</span></label>
            <input type="date" class="form-control" id="date2" required>
           </div>
          </div>
          <div class="form-group">
           <button class="btn btn-block" type="submit"><i class="fa fa-save"></i> Show Report</button>
          </div>
          <div class="form-group">
           <div id="filterstatus"></div>
          </div>
         </form>
        </div>
       </div>
      </div>

   </div>
  </div>
 </div>
</div>
</div>
</section>
<script src="<?php echo $base_url;?>assets/bootstrap/bootstrap.min.js"></script>
<script src="<?php echo $base_url;?>assets/js/dashboard.js"></script>
<script src="<?php echo $base_url;?>assets/js/jquery.dataTables.min.js"></script>
<script src="<?php echo $base_url;?>assets/js/dataTables.bootstrap4.min.js"></script>
<?php include_once("includes/buttons.php");?>
<script>
$(function(){
 $("#ussdl").attr("class","active");
 function dataTables(tb){
 var table = $('#'+tb+'').DataTable({
  lengthChange: false,
  "aaSorting": [],
  "buttons": [
  {"extend": 'copy', "text":'<i class="fas fa-copy"></i> Copy',"className": 'btn btn-success btn-sm'},
  {"extend": 'csv', "text":'<i class="fas fa-file-csv"></i> CSV',"className": 'btn btn-success btn-sm'},
  {"extend": 'excel', "text":'<i class="fas fa-file-excel"></i> Excel',"className": 'btn btn-success btn-sm' },
  {"extend": 'pdf', "text":'<i class="fas fa-file-pdf"></i> PDF',"className": 'btn btn-success btn-sm'},
  {"extend": 'print', "text":'<i class="fas fa-print"></i> Print',"className": 'btn btn-success btn-sm'}
  ]
 }); 
 table.buttons().container().appendTo( '#'+tb+'_wrapper .col-md-6:eq(0)' );
 }
 dataTables("tb_disb");

  //Custom duration report
  $("#filterform").submit(function(e){
   e.preventDefault();
   var date1 = $("#date1").val();
   var date2 = $("#date2").val();
   $("#filterform .btn").attr("disabled","disabled");
   $("#filterstatus").html("<p class='alert alert-success' style='padding:10px;'><i class='fa fa-spinner fa-pulse'></i> Please wait....</p>");
   $.ajax({
    type: "POST",
    url: $("#portal_url").html()+"reports/ussdloans",
    data: {
      date1:date1,
      date2:date2
    },
    cache: false
   }).done(function(data){
    $("#filterform .btn").removeAttr("disabled");
    $("#filterstatus").html("");
    $(".report").html(data);
    $('#filtermodal').modal('toggle');
    dataTables("tb_disb");
   });
  });
});
 </script>
</body>
</html>